/**
 * java script -settings
 *
 * @author  Sampath Perera
 * @since   2020-12-04
 */

$(document).ready(function () {

    $('#tblTransactionItem').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "item_id" },
            { "data": "narration" },
            { "data": "type" },
            { "data": "edit", className: "edit" },
            { "data": "delete", className: "delete" },
            { "data": "status", className: "disable" },

        ],
        columnDefs: [
            { width: 20, targets: 0 },
            { width: 100, targets: 2 },
            { width: 20, targets: 3 },
            { width: 20, targets: 4 },
            { width: 20, targets: 5 },
        ],
        /*initComplete: function () {
            this.api().page(index).draw('page');
        },
        drawCallback: function () {

            $('.paginate_button', this.api().table().container())
                .on('click', function (event) {
                    dataTablePaginateButtonEvent(event);
                });
        }*/
    });


    //Load all transaction items to DataTable
    allTransactionItem(0);
});



/**
* showModal
* This function is used to open modal.
* @param event This is the paramter to identify save/update
* @param item_id This is the paramter use to update naration
* @param narration This is the paramter use to update naration value
* @param type This is the paramter use to identify earning/deductions
*/
function showModal(event, item_id, narration, narration_sinhala, type) {

    $('#hidItem_Id').val(item_id);
    $('#txtNarration').val(narration);
    $('#txtNarrationSinhala').val(narration_sinhala);
    setSelectedOption('selcType', type);

    if (event == 'save') {
        $('#transactionItemAddModal-title').text('Add transaction item here');
        $('#btnTransactionItem-action').text('Save');
        $('#transactionItemAddModal').modal('toggle');
    } else if (event == 'update') {
        $('#transactionItemAddModal-title').text('Update Transaction item');
        $('#btnTransactionItem-action').text('Update');
        $('#transactionItemAddModal').modal('toggle');
    }

}


/**
* actionPerformed
* This function is used to identify button event save/update.
*/
function actionPerformed() {
    var event = $('#btnTransactionItem-action').text();

    if (event == 'Save') {
        save();
    } else if (event == 'Update') {
        update();
    }
}




/**
* save
* This function is used to save transaction item.
*/
function save() {

    var _token = $("input[name='_token']").val();
    var narration = $('#txtNarration').val();
    var narration_sinhala = $('#txtNarrationSinhala').val();
    var type = $('#selcType').val();

    var form = new FormData();
    form.append("_token", _token);
    form.append("narration", narration);
    form.append("narration_sinhala", narration_sinhala);
    form.append("type", type);

    $.ajax({
        type: "POST",
        url: '/hr/transactionItem/save',
        data: form,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showSuccessMessage("TransactionItem has been saved successfully...");
                resetModal();
                allTransactionItem();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* update
* This function is used to update transaction item.
*/
function update() {

    $.ajax({
        type: 'PUT',
        url: '/hr/transactionItem/update',
        data: $('#formTransactionItem').serialize(),
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showSuccessMessage("Settings has been updated successfully...");
                resetModal();
                allTransactionItem();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}






/**
* resetModal
* This function is used to reset transaction item form.
*/
function resetModal() {
    $('#transactionItemAddModal').modal('hide');
    $('#formTransactionItem').trigger("reset");
}


/**
* allTransactionItem
* This function is used to get all transaaction items.
* @param index This is the paramter to Datatable paginate index
*/
function allTransactionItem(index) {
 
    $.ajax({
        type: "GET",
        url: '/hr/transactionItem/allTransactionItems',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                transactionItemLoadTable(response.data.result, index);
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* transactionItemLoadTable
* This function is used toload transaction item to DataTable.
*/
function transactionItemLoadTable(result, index) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var id = result[i]['item_id'];
        var narration = result[i]['narration'];
        var narration_sinhala = result[i]['narration_sinhala'];

        var type = "Earning";
        if (result[i]['type'] == 1) {
            type = "Deducation";
        }

        var status = "";
        if (result[i]['status'] == 1) {
            status = "checked";
        }

        var string_id = "'" + id + "'";
        var slide_switch = '<label class="switch"><input type="checkbox" id="1" onchange="disableTransactionItem(event,' + string_id + ')" ' + status + '><span class="slider round"></span></label>';
        data.push({
            "item_id": generateID(id),
            "narration": narration,
            "type": type,
            "edit": '<button class="btn btn-primary" onclick="showModal(' + "'" + 'update' + "'" + ',' + string_id + ',' + "'" + narration + "'" + ',' + "'" + narration_sinhala + "'" + ',' + result[i]['type'] + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
            "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
            "status": slide_switch,


        });
    }

    var table = $('#tblTransactionItem').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.edit').visible(false);
    table.columns('.delete').visible(false);
    table.columns('.disable').visible(false);



    if (edit_permission == 1) {
        table.columns('.edit').visible(true);
    }

    if (delete_permission == 1) {
        table.columns('.delete').visible(true);
    }

    if (disable_permission == 1) {
        table.columns('.disable').visible(true);
    }


}




/**
* disableTransactionItem
* This function is used disable transaction item.
*/
function disableTransactionItem(event, id) {

    var status = 0;
    if (event.target.checked) {
        status = 1;
    }

    $.ajax({
        type: 'PUT',
        url: '/hr/transactionItem/disableTransactionItem/' + id,
        data: {
            _token: $('input[name=_token]').val(),
            "status": status
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                if (response.data.result) {
                    showSuccessMessage("Transaction Item has been disabled successfully...");
                } else {
                    showWarningMessage('Transaction item cannot be disable ');
                }

                var index = dataTableSelectedPage();
                allTransactionItem(index);


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





function _delete(id) {

    $.ajax({
        type: "DELETE",
        url: "/hr/transactionItem/delete/" + id,
        data: {
            _token: $('input[name=_token]').val(),
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (response.data.result) {
                    showSuccessMessage("Transaction item has been deleted successfully...");
                    allTransactionItem(0);
                } else {
                    showWarningMessage('Transaction item cannot be delete ');
                }


            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}


/**
* setSelectedOption
* This function is used to set selected option to the select tag.
*/
function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "000",
        2: "00",
        3: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}


/**
* dataTableSelectedPage
* This function is used to get DataTable selected page index number.
*/
function dataTableSelectedPage() {
    var tbl = $('#tblTransactionItem').DataTable();
    return tbl.page.info().page;
}


/**
* dataTablePaginateButtonEvent
* This function is used as DataTable paginate button click event.
*/
function dataTablePaginateButtonEvent(event) {

}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* showWarrningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {

    toastr.warning(message);
}




