@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
<script>
    var remove_permission = "{{Auth::user()->can('employee_leave_remove')}}";
</script>
<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee Leave</h6>
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <i class="fa fa-money text-info" aria-hidden="true"></i>
                                <label>Leave Type</label>
                                <select class="form-control" id="selcLeaveType" name="selcLeaveType" onchange="allLeaveType()"></select>
                            </div>
                        </div>

                        <!--<div class="row">
                            <div class="col-md-6 mb-3">
                                <i class="fa fa-money text-info" aria-hidden="true"></i>
                                <label>Month</label>
                                <select class="form-control" id="selcLeaveMonth" name="selcLeaveMonth" onchange="">
                                    <option value="1">January</option>
                                    <option value="2">February</option>
                                    <option value="3">March</option>
                                    <option value="4">April</option>
                                    <option value="5">May</option>
                                    <option value="6">June</option>
                                    <option value="7">July</option>
                                    <option value="8">August</option>
                                    <option value="9">September</option>
                                    <option value="10">October</option>
                                    <option value="11">November</option>
                                    <option value="12">December</option>
                                </select>
                            </div>
                        </div>!-->

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <hr>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Category</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcCategory" name="selcCategory" onchange="getLeaveType('category')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_leave_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyLeaveType('category','selcCategory')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_leave_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="removeLeave('category','selcCategory')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Site</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSite" name="selcSite" onchange="getLeaveType('site')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_leave_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyLeaveType('site','selcSite')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_leave_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="removeLeave('site','selcSite')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Department</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcDepartment" name="selcDepartment" onchange="getLeaveType('department')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_leave_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyLeaveType('department','selcDepartment')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_leave_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="removeLeave('department','selcDepartment')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Section</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSection" name="selcSection" onchange="getLeaveType('section')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_leave_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyLeaveType('section','selcSection')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_leave_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="removeLeave('section','selcSection')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Subsection</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSubsection" name="selcSubsection" onchange="getLeaveType('subsection')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_leave_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyLeaveType('subsection','selcSubsection')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_leave_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="removeLeave('subsection','selcSubsection')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Company</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcCompany" name="selcCompany" onchange="getLeaveType('company')"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_leave_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyLeaveType('company','selcCompany')">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_leave_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="removeLeave('company','selcCompany')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>





                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Employee</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <input type="text" class="form-control auto-complete" id="auto-comp1" onchange="getLeaveType('employee')">
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_leave_create'))
                                                        <button type="button" class="btn btn-primary" onclick="applyLeaveByEmployeeID()">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_leave_remove'))
                                                        <button type="button" class="btn btn-danger" onclick="removeLeave('employee','auto-comp1')">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>




                        <div class="row">
                            <div class="col-md-12">
                                <br>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-control container">
                                                    <input type="checkbox" id="chkAllEmployee" name="chkAllEmployee" onchange="getLeaveType('allemployee')">
                                                    All Employee
                                                    <span class="checkmark"></span>
                                                </label>

                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        @if(Auth::user()->can('employee_leave_create'))
                                                        <button type="button" id="btnApplyAllEmployee" class="btn btn-primary" onclick="applyLeaveAllEmployee()">Apply</button>
                                                        @endif
                                                        @if(Auth::user()->can('employee_leave_remove'))
                                                        <button type="button" id="btnRemoveAllEmployee" class="btn btn-danger" onclick="removeLeave('allemployee',null)">Remove</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>

                <br>
                <div class="row">
                    <div class="col-md-12 seperator">
                        <div class="card bg-primary">
                            <div class="card-header"></div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <table id="tblEmployeeAllowance" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                            <thead>
                                <tr>
                                    <th class="id">Employee ID</th>
                                    <th>Name</th>
                                    <th>Leave Type</th>
                                    <th>Leave Count</th>
                                    <th class="delete">Delete</th>
                                </tr>
                            </thead>
                            <tbody id="tbody"></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- JQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/attendanceEmployeeLeave.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection