@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Attendance Post To Payroll</h6>
                <div class="row">
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>Current Year</label>
                                <select class="form-control" id="cmbCurrentYear"></select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>Current Month</label>
                                <select class="form-control" id="cmbCurrentMonth">
                                    <option value="1">January</option>
                                    <option value="2">February</option>
                                    <option value="3">March</option>
                                    <option value="4">April</option>
                                    <option value="5">May</option>
                                    <option value="6">June</option>
                                    <option value="7">July</option>
                                    <option value="8">August</option>
                                    <option value="9">September</option>
                                    <option value="10">October</option>
                                    <option value="11">November</option>
                                    <option value="12">December</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>From</label>
                                <input type="text" class="form-control" id="txtDateFrom" name="date">
                            </div>
                            <div class="col-md-4 mb-3">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>To</label>
                                <input type="text" class="form-control" id="txtDateTo" name="date">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3"></div>
                            <div class="col-md-4 mb-3">
                                @if(Auth::user()->can('employee_attendance_post_payrol_process'))
                                <button id="btnProccess" class="btn btn-primary" onclick="proccess()">Process</button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ URL::asset('assets/js/svr.js') }}"></script>
<script src="{{ Module::asset('hr:js/attendanceProccess.js') }}"></script>


<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection