@extends('hr::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/attendanceSettings.css') }}" type="text/css">
<script>
    var holiday_edit_permission = "{{Auth::user()->can('employee_attendance_holiday_edit')}}";
    var holiday_disable_permission = "{{Auth::user()->can('employee_attendance_holiday_enable_disable')}}";

    var workday_edit_permission = "{{Auth::user()->can('employee_attendance_workday_edit')}}";
    var workday_disable_permission = "{{Auth::user()->can('employee_attendance_workday_enable_disable')}}";

    var leave_edit_permission = "{{Auth::user()->can('employee_attendance_leave_edit')}}";
    var leave_disable_permission = "{{Auth::user()->can('employee_attendance_leave_enable_disable')}}";
</script>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Attendance Settings</h6>
                <div class="accordion" id="accordionExample">

                    @if(Auth::user()->can('employee_attendance_holiday'))
                    <div class="col-md-12 mb-3">
                        <div class="card ">
                            <div class="card-header" id="headingHoliday">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" id="settingsModal" data-toggle="collapse" data-target="#collapseHoliday" aria-expanded="false" aria-controls="collapseHoliday" onclick="getAll('AllHoliday')">
                                        <i class="ti-settings mr-2"></i> Holiday
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseHoliday" class="collapse" aria-labelledby="headingHoliday" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_attendance_holiday_create'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="saveHoliday()">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_holiday">Edit</th>
                                                    <th class="disable disable_holiday">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblHoliday"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_attendance_workday'))
                    <div class="col-md-12 mb-3">
                        <div class="card ">
                            <div class="card-header" id="headingWorkday">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" id="settingsModal" data-toggle="collapse" data-target="#collapseWorkday" aria-expanded="false" aria-controls="collapseWorkday" onclick="getAll('AllWorkDay')">
                                        <i class="ti-settings mr-2"></i> Work Day
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseWorkday" class="collapse" aria-labelledby="headingWorkday" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_attendance_workday_create'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="saveWorkDay()">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_workday">Edit</th>
                                                    <th class="disable disable_workday">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblWorkDay"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif


                    @if(Auth::user()->can('employee_attendance_leave'))
                    <div class="col-md-12 mb-3">
                        <div class="card ">
                            <div class="card-header" id="headingWorkday">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" id="settingsModal" data-toggle="collapse" data-target="#collapseLeave" aria-expanded="false" aria-controls="collapseLeave" onclick="getAll('AllLeave')">
                                        <i class="ti-settings mr-2"></i> Leave
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseLeave" class="collapse" aria-labelledby="headingLeave" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_attendance_leave_create'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="saveLeave()">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_leave">Edit</th>
                                                    <th class="disable disable_leave">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblLeave"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif


                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="settingsAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="settingsAddModalTitle">Modal title</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form method="POST" id="attSettingsForm">
                    {{csrf_field()}}
                    <div class="modal-body" id="settingsAddModalBody"></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnAction">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


@endsection

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- App scripts -->
<script src="{{ Module::asset('hr:js/attendanceSettings.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Sweet alert -->
<script src="{{ url('assets/js/examples/sweet-alert.js') }}"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection