<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Modules\Hr\Http\Controllers\AtdHolidayController;
use Modules\Hr\Http\Controllers\AtdSettingsController;
use Modules\Hr\Http\Controllers\AttachmentController;
use Modules\Hr\Http\Controllers\AttEmployeeLeaveController;
use Modules\Hr\Http\Controllers\AttEmployeeScheduleController;
use Modules\Hr\Http\Controllers\AttendanceReportEditController;
use Modules\Hr\Http\Controllers\AttEmployeeScheduleSupervisorController;
use Modules\Hr\Http\Controllers\AttendanceDriversScheduleController;
use Modules\Hr\Http\Controllers\AttendanceProcessController;
use Modules\Hr\Http\Controllers\AttScheduleController;
use Modules\Hr\Http\Controllers\AttShiftController;
use Modules\Hr\Http\Controllers\AttSpcWorkdaysController;
use Modules\Hr\Http\Controllers\CategoryController;
use Modules\Hr\Http\Controllers\DebtorLoanController;
use Modules\Hr\Http\Controllers\EmployeeController;
use Modules\Hr\Http\Controllers\EmployeeDetailReportController;
use Modules\Hr\Http\Controllers\EmployeeOtherEarningDeductionController;
use Modules\Hr\Http\Controllers\EmployeeTeamController;
use Modules\Hr\Http\Controllers\EmployeeTeamScheduleController;
use Modules\Hr\Http\Controllers\Employee3Month6MonthController;
use Modules\Hr\Http\Controllers\ImportSalaryDataController;
use Modules\Hr\Http\Controllers\LoanController;
use Modules\Hr\Http\Controllers\OtherEarningDeductionController;
use Modules\Hr\Http\Controllers\PrintIdController;
use Modules\Hr\Http\Controllers\ReportEmployeeListController;
use Modules\Hr\Http\Controllers\SalaryAdavnceController;
use Modules\Hr\Http\Controllers\SalaryController;
use Modules\Hr\Http\Controllers\SalaryDataController;
use Modules\Hr\Http\Controllers\SettingsController;
use Modules\Hr\Http\Controllers\TeamController;
use Modules\Hr\Http\Controllers\TransactionItemController;
use Modules\Hr\Http\Controllers\TransactionItemSetupController;
use Modules\Hr\Http\Controllers\LeaveController;
use Modules\Hr\Http\Controllers\PayrollReportController;
use Modules\Hr\Http\Controllers\RecruitmentController;
use Modules\Hr\Http\Controllers\ReportAttSheetController;
use Modules\Hr\Http\Controllers\SalaryDataListController;
use Modules\Hr\Http\Controllers\SupervisorApprovalController;
use Modules\Hr\Http\Controllers\SvrController;
use Modules\Hr\Http\Controllers\EmployeeAttendanceReportController;

Route::prefix('hr')->group(function () {

    //Route::get('/', 'HrController@index');


    Route::get('/dashboard', function () {
        return view('hr::dashboard');
    })->middleware('is.logged');


    Route::get('/employee', function () {
        return view('hr::employee');
    })->middleware(['is.logged', 'can:employee']);

    Route::get('/employeeList', function () {
        return view('hr::employeeList');
    })->middleware(['is.logged', 'can:employee_list']);

    Route::get('/settings', function () {
        return view('hr::settings');
    })->middleware(['is.logged', 'can:personal_information_general']);

    Route::get('/printid', function () {
        return view('hr::printID');
    })->middleware(['is.logged', 'can:create_id_card']);

    Route::get('/printid/preview', function () {
        return view('hr::print/idcard_print');
    })->middleware(['is.logged', 'can:employee_id_card_print']);

    Route::get('/attachment', function () {
        return view('hr::attachment');
    })->middleware(['is.logged', 'can:attachment']);

    Route::get('/transactionItem', function () {
        return view('hr::transactionItem');
    })->middleware(['is.logged', 'can:payroll_naration']);

    Route::get('/transactionItemSetup', function () {
        return view('hr::transactionItemSetup');
    })->middleware(['is.logged', 'can:payroll_naration_setup']);

    Route::get('/salarySheet', function () {
        return view('hr::salarySheet');
    })->middleware(['is.logged', 'can:salary_sheet']);

    Route::get('/salarySheetList', function () {
        return view('hr::salarySheetList');
    })->middleware(['is.logged', 'can:salary_sheet_list']);

    Route::get('/salary', function () {
        return view('hr::salary');
    })->middleware(['is.logged', 'can:personal_information_basic_salary']);


    Route::get('/category', function () {
        return view('hr::category');
    })->middleware(['is.logged', 'can:personal_information_category']);


    Route::get('/otherEarningDeduction', function () {
        return view('hr::otherEarningDeduction');
    })->middleware(['is.logged', 'can:payroll_earning_deduction']);


    Route::get('/employeeOtherEarningDeduction', function () {
        return view('hr::employeeOtherEarningDeduction');
    })->middleware(['is.logged', 'can:payroll_earning_deduction_setup']);


    Route::get('/salaryAdvance', function () {
        return view('hr::salaryAdvance');
    })->middleware(['is.logged', 'can:salary_advance']);


    Route::get('/salaryAdvanceList', function () {
        return view('hr::salaryAdvanceList');
    })->middleware(['is.logged', 'can:salary_advance_list']);


    Route::get('/loan', function () {
        return view('hr::loan');
    })->middleware(['is.logged', 'can:salary_loan']);


    Route::get('/loanList', function () {
        return view('hr::loanList');
    })->middleware(['is.logged', 'can:salary_loan_list']);


    Route::get('/debtorLoan', function () {
        return view('hr::debtorLoan');
    })->middleware(['is.logged', 'can:salary_debtor_loan']);


    Route::get('/debtorLoanList', function () {
        return view('hr::debtorLoanList');
    })->middleware(['is.logged', 'can:salary_debtor_loan_list']);


    Route::get('/attSettings', function () {
        return view('hr::attendanceSettings');
    })->middleware(['is.logged', 'can:attendance_general']);


    Route::get('/attHoliday', function () {
        return view('hr::attendanceHoliday');
    })->middleware(['is.logged', 'can:attendance_holiday']);


    Route::get('/specialWorkdays', function () {
        return view('hr::specialWorkdays');
    })->middleware(['is.logged', 'can:attendance_special_workdays']);


    Route::get('/attendanceEmployeeLeave', function () {
        return view('hr::attendanceEmployeeLeave');
    })->middleware(['is.logged', 'can:attendance_leave']);


    Route::get('/shift', function () {
        return view('hr::shift');
    })->middleware(['is.logged', 'can:attendance_shift']);



    Route::get('/attendanceEmployeeScheduleSetting', function () {
        return view('hr::attendanceEmployeeScheduleSetting');
    })->middleware(['is.logged', 'can:time_and_attendande_create']);



    Route::get('/attendanceEmployeeScheduleSupervisor', function () {
        return view('hr::attendanceEmployeeScheduleSupervisor');
    })->middleware(['is.logged', 'can:time_and_attendande_supervisor']);


    Route::get('/attendanceEmployeeSchedule', function () {
        return view('hr::attendanceEmployeeSchedule');
    })->middleware(['is.logged', 'can:time_and_attendande_employee']);


    Route::get('/employeeList_print', function () {
        return view('hr::print/employeeList_print');
    })->middleware(['is.logged', 'can:employee_report_print']);


    Route::get('/reportEmployeeList', function () {
        return view('hr::reportEmployeeList');
    })->middleware(['is.logged', 'can:persona_information_report_employee_list']);


    Route::get('/team', function () {
        return view('hr::team');
    })->middleware(['is.logged', 'can:team_create']);


    Route::get('/employeeTeam', function () {
        return view('hr::employee_team');
    })->middleware(['is.logged', 'can:team_assign']);


    Route::get('/employeeTeamSchedule', function () {
        return view('hr::employeeTeamSchedule');
    })->middleware(['is.logged', 'can:time_and_attendande_team']);

    /* Ishara */
    Route::get('/recruitment_request', function () {
        return view('hr::recruitment_request');
    })->middleware('is.logged');;

    Route::get('/recruitment_request_list', function () {
        return view('hr::recruitment_request_list');
    })->middleware('is.logged');;

    Route::get('/leave', function () {
        return view('hr::leave');
    })->middleware(['is.logged', 'can:hr_leave']);

    Route::get('/leave_list', function () {
        return view('hr::leave_list');
    })->middleware(['is.logged', 'can:hr_leave_list']);

    Route::get('/reportAttSheet', function () {
        return view('hr::reportAttSheet');
    })->middleware(['is.logged', 'can:attendance_sheet']);

    Route::get('/attendanceEdit', function () {
        return view('hr::attendanceEdit');
    })->middleware(['is.logged', 'can:attendance_edit']);


    Route::get('/attendanceProcess', function () {
        return view('hr::attendanceProcess');
    })->middleware(['is.logged', 'can:attendance_process']);
 

    Route::get('/salaryProcess', function () {
        return view('hr::salaryProcess');
    })->middleware('is.logged');


    Route::get('/supervisorAttendanceApproval', function () {
        return view('hr::supervisorAttendanceApproval');
    })->middleware(['is.logged', 'can:approve_supervisor']);



    Route::get('/payrollReport', function () {
        return view('hr::payrollReport');
    })->middleware(['is.logged', 'can:salary_payroll_report']);


    Route::get('/employeeDetailReport', function () {
        return view('hr::employeeDetailReport');
    })->middleware(['is.logged']);



    Route::get('/importSalaryData', function () {
        return view('hr::importSalaryData');
    })->middleware(['is.logged', 'can:salary_import_data']);


    Route::get('/notification/employee_3month_6month_completed/list', function () {
        return view('hr::employee_3_6_month_completed');
    })->middleware(['is.logged']);



    /** Settings */
    Route::post('/settings/town', [SettingsController::class, 'saveTown'])->middleware(['is.logged', 'can:employee_town_add']);
    Route::post('/settings/civilstatus', [SettingsController::class, 'saveCivilStatus'])->middleware(['is.logged', 'can:employee_civilstatus_add']);
    Route::post('/settings/designation', [SettingsController::class, 'saveDesignation'])->middleware(['is.logged', 'can:employee_designation_add']);
    Route::post('/settings/employeetype', [SettingsController::class, 'saveEmployeeType']);
    Route::post('/settings/employeestatus', [SettingsController::class, 'saveEmployeeStatus'])->middleware(['is.logged', 'can:employee_status_add']);
    Route::post('/settings/category', [SettingsController::class, 'saveCategory']);
    Route::post('/settings/site', [SettingsController::class, 'saveSite'])->middleware(['is.logged', 'can:employee_site_add']);
    Route::post('/settings/department', [SettingsController::class, 'saveDepartment'])->middleware(['is.logged', 'can:employee_department_add']);
    Route::post('/settings/section', [SettingsController::class, 'saveSection'])->middleware(['is.logged', 'can:employee_section_add']);
    Route::post('/settings/subsection', [SettingsController::class, 'saveSubsection'])->middleware(['is.logged', 'can:employee_subsection_add']);
    Route::post('/settings/mohdivision', [SettingsController::class, 'saveMohDivision'])->middleware(['is.logged', 'can:employee_mohdivision_add']);
    Route::post('/settings/police', [SettingsController::class, 'savePolice'])->middleware(['is.logged', 'can:employee_police_add']);
    Route::post('/settings/gsdivision', [SettingsController::class, 'saveGsDivision'])->middleware(['is.logged', 'can:employee_gsdivision_add']);

    Route::get('/settings/towns', [SettingsController::class, 'allTown']);
    Route::get('/settings/civilstatuses', [SettingsController::class, 'allCivilStatus']);
    Route::get('/settings/designations', [SettingsController::class, 'allDesignation']);
    Route::get('/settings/employeetypes', [SettingsController::class, 'allEmployeeType']);
    Route::get('/settings/employeestatuses', [SettingsController::class, 'allEmployeeStatus']);
    Route::get('/settings/categories', [SettingsController::class, 'allCategory']);
    Route::get('/settings/sites', [SettingsController::class, 'allSite']);
    Route::get('/settings/departments', [SettingsController::class, 'allDepartment']);
    Route::get('/settings/sections', [SettingsController::class, 'allSection']);
    Route::get('/settings/subsections', [SettingsController::class, 'allSubsection']);
    Route::get('/settings/mohdivision', [SettingsController::class, 'allMohDivision']);
    Route::get('/settings/police', [SettingsController::class, 'allPolice']);
    Route::get('/settings/gsdivision', [SettingsController::class, 'allGsDivision']);

    Route::put('/settings/town/{id}', [SettingsController::class, 'updateTown'])->middleware(['is.logged', 'can:employee_town_edit']);
    Route::put('/settings/civilstatus/{id}', [SettingsController::class, 'updateCivilStatus'])->middleware(['is.logged', 'can:employee_civilstatus_edit']);
    Route::put('/settings/designation/{id}', [SettingsController::class, 'updateDesignation'])->middleware(['is.logged', 'can:employee_designation_edit']);
    Route::put('/settings/employeetype/{id}', [SettingsController::class, 'updateEmployeeType']);
    Route::put('/settings/employeestatus/{id}', [SettingsController::class, 'updateEmployeeStatus'])->middleware(['is.logged', 'can:employee_status_edit']);
    Route::put('/settings/category/{id}', [SettingsController::class, 'updateCategory']);
    Route::put('/settings/site/{id}', [SettingsController::class, 'updateSite'])->middleware(['is.logged', 'can:employee_site_edit']);
    Route::put('/settings/department/{id}', [SettingsController::class, 'updateDepartment'])->middleware(['is.logged', 'can:employee_department_edit']);
    Route::put('/settings/section/{id}', [SettingsController::class, 'updateSection'])->middleware(['is.logged', 'can:employee_section_edit']);
    Route::put('/settings/subsection/{id}', [SettingsController::class, 'updateSubsection'])->middleware(['is.logged', 'can:employee_subsection_edit']);
    Route::put('/settings/mohdivision/{id}', [SettingsController::class, 'updateMohDivision'])->middleware(['is.logged', 'can:employee_mohdivision_edit']);
    Route::put('/settings/police/{id}', [SettingsController::class, 'updatePolice'])->middleware(['is.logged', 'can:employee_police_edit']);
    Route::put('/settings/gsdivision/{id}', [SettingsController::class, 'updateGsDivision'])->middleware(['is.logged', 'can:employee_gsdivision_edit']);



    Route::delete('/settings/town/{id}', [SettingsController::class, 'disableTown'])->middleware(['is.logged', 'can:employee_town_enable_disable']);
    Route::delete('/settings/civilstatus/{id}', [SettingsController::class, 'disableCivilStatus'])->middleware(['is.logged', 'can:employee_civilstatus_enable_disable']);
    Route::delete('/settings/designation/{id}', [SettingsController::class, 'disableDesignation'])->middleware(['is.logged', 'can:employee_designation_enable_disable']);
    Route::delete('/settings/employeetype/{id}', [SettingsController::class, 'desableEmployeeType']);
    Route::delete('/settings/employeestatus/{id}', [SettingsController::class, 'disableEmployeeStatus'])->middleware(['is.logged', 'can:employee_status_enable_disable']);
    Route::delete('/settings/category/{id}', [SettingsController::class, 'disableCategory']);
    Route::delete('/settings/site/{id}', [SettingsController::class, 'disableSite'])->middleware(['is.logged', 'can:employee_site_enable_disable']);
    Route::delete('/settings/department/{id}', [SettingsController::class, 'disableDepartment'])->middleware(['is.logged', 'can:employee_department_enable_disable']);
    Route::delete('/settings/section/{id}', [SettingsController::class, 'disableSection'])->middleware(['is.logged', 'can:employee_section_enable_disable']);
    Route::delete('/settings/subsection/{id}', [SettingsController::class, 'disableSubsection'])->middleware(['is.logged', 'can:employee_subsection_enable_disable']);
    Route::delete('/settings/mohdivision/{id}', [SettingsController::class, 'disableMohDivision'])->middleware(['is.logged', 'can:employee_mohdivision_enable_disable']);
    Route::delete('/settings/police/{id}', [SettingsController::class, 'disablePolice'])->middleware(['is.logged', 'can:employee_police_enable_disable']);
    Route::delete('/settings/gsdivision/{id}', [SettingsController::class, 'disableGsDivision'])->middleware(['is.logged', 'can:employee_gsdivision_enable_disable']);
    /** End Settings */



    /** Employee */
    Route::post('/employee', [EmployeeController::class, 'save'])->middleware(['is.logged', 'can:employee_create']);
    Route::post('/employee/update', [EmployeeController::class, 'update'])->middleware(['is.logged', 'can:employee_edit']);

    Route::get('/employee/allEmployee', [EmployeeController::class, 'allEmployee']);
    Route::get('/employee/settings', [EmployeeController::class, 'settings']);
    Route::get('/employee/employee/{id}', [EmployeeController::class, 'employee']);
    Route::get('/employee/bank/branch/{id}', [EmployeeController::class, 'bankBranch']);
    Route::get('/employee/section/subsection/{id}', [EmployeeController::class, 'subSection']);
    Route::get('/employee/pensionDate/{date}/{gender}', [EmployeeController::class, 'pensionDate']);

    Route::delete('/employee/{id}', [EmployeeController::class, 'delete'])->middleware(['is.logged', 'can:employee_delete']);
    /** End Employee */


    /** PrintID */
    Route::post('/print', [PrintIdController::class, 'save'])->middleware(['is.logged', 'can:employee_id_card_create']);
    Route::post('/print/update/{id}', [PrintIdController::class, 'update'])->middleware(['is.logged', 'can:employee_id_card_edit']);

    Route::get('/print/allEmployee', [PrintIdController::class, 'allEmployee']);
    Route::get('/print/allDesignation', [PrintIdController::class, 'allDesignation']);
    Route::get('/print/employee/{id}', [PrintIdController::class, 'employee']);
    Route::get('/print/employee/print/{print_list}', [PrintIdController::class, 'employeePrint'])->middleware(['is.logged', 'can:employee_id_card_print']);

    Route::put('/print/makedPrint', [PrintIdController::class, 'makedPrint'])->middleware(['is.logged', 'can:employee_id_card_make_all']);

    Route::delete('/print/employee/{id}', [EmployeeController::class, 'delete'])->middleware(['is.logged', 'can:employee_id_card_delete']);
    /** End PrintID */



    /** Attachment */
    Route::get('/attachment/allEmployee', [AttachmentController::class, 'allEmployee']);
    Route::get('/attachment/allEmployee/{id}', [AttachmentController::class, 'getEmployeeFromId']);
    Route::get('/attachment/delete/{id}', [AttachmentController::class, 'delete'])->middleware(['is.logged', 'can:employee_attachment_delete']);

    Route::get('/attachment/allFiles/{id}', [AttachmentController::class, 'allFiles']);

    Route::post('/attachment/upload', [AttachmentController::class, 'upload']);
	//->name('upload'); 
	//->middleware(['is.logged','can:employee_attachment_create']);
    /** End Attachment */



    /** Transaction Item */
    Route::post('/transactionItem/save', [TransactionItemController::class, 'save'])->middleware(['is.logged', 'can:employee_naration_create']);

    Route::put('/transactionItem/update', [TransactionItemController::class, 'update'])->middleware(['is.logged', 'can:employee_naration_edit']);
    Route::put('/transactionItem/disableTransactionItem/{id}', [TransactionItemController::class, 'disableTransactionItem'])->middleware(['is.logged', 'can:employee_naration_enable_disable']);

    Route::get('/transactionItem/allTransactionItems', [TransactionItemController::class, 'allTransactionItems']);

    Route::delete('/transactionItem/delete/{id}', [TransactionItemController::class, 'delete'])->middleware(['is.logged', 'can:employee_naration_delete']);
    /** End Transaction Item */


    /** Transaction Item Setup*/
    Route::post('/transactionItemSetup/save', [TransactionItemSetupController::class, 'save'])->middleware(['is.logged', 'can:employee_naration_setup_create']);
    Route::get('/transactionItemSetup/allTransactionItemEarnings', [TransactionItemSetupController::class, 'allTransactionItemEarnings']);
    Route::get('/transactionItemSetup/allTransactionItemDeducations', [TransactionItemSetupController::class, 'allTransactionItemDeducations']);
    Route::get('/transactionItemSetup/allTransactionItemSetup', [TransactionItemSetupController::class, 'allTransactionItemSetup']);
    /** End Transaction Item Setup*/



    /** Salary Sheet */
    Route::get('/salaryData/employeeID', [SalaryDataController::class, 'employeeID']);
    Route::get('/salaryData/employeeName', [SalaryDataController::class, 'employeeName']);
    Route::get('/salaryData/employeeData/{id}', [SalaryDataController::class, 'employeeData']);
    Route::get('/salaryData/currentMonthSalary/{id}', [SalaryDataController::class, 'currentMonthSalary']);
    Route::get('/salaryData/employeeSalaryData/{id}', [SalaryDataController::class, 'employeeSalaryData']);
    Route::post('/salaryData/save', [SalaryDataController::class, 'save'])->middleware(['is.logged', 'can:employee_salary_sheet_create']);
    Route::put('/salaryData/update/{id}', [SalaryDataController::class, 'update'])->middleware(['is.logged', 'can:employee_salary_sheet_edit']);
    Route::get('/salaryData/isMonthEndProcess', [SalaryDataController::class, 'isMonthEndProcess']);
    Route::get('/salaryData/getBasisMethod/{id}', [SalaryDataController::class, 'getBasisMethod']);
    /** End Salary Sheet */

    /** Salary Sheet List */
    Route::get('/salaryData/allSettings', [SalaryDataListController::class, "allSettings"]);
    Route::get('/salaryData/allSalaryData/{year}/{month}', [SalaryDataListController::class, "allSalaryData"]);
    Route::get('/salaryData/subSection/{section_id}', [SalaryDataListController::class, "subSection"]);
    Route::get('/salaryData/search', [SalaryDataListController::class, "search"]);

    Route::delete('/salaryData/deleteSalaryDataFromID/{id}', [SalaryDataListController::class, "deleteSalaryDataFromID"])->middleware(['is.logged', 'can:employee_salary_sheet_delete']);
    /** End of Salary Sheet List */




    /** Salary */
    Route::get('/salary/allEmployeeNameAndID', [SalaryController::class, 'allEmployeeNameAndID']);
    Route::get('/salary/employee/{id}', [SalaryController::class, 'employee']);
    Route::get('/salary/allSalary', [SalaryController::class, 'allSalary']);
    Route::get('/salary/employeeSalary/{id}', [SalaryController::class, 'employeeSalary']);

    Route::put('/salary/update/{id}', [SalaryController::class, 'update'])->middleware(['is.logged', 'can:employee_basic_salary_edit']);
    Route::put('/salary/disable/{id}', [SalaryController::class, 'disable'])->middleware(['is.logged', 'can:employee_basic_salary_enable_disable']);

    Route::delete('/salary/delete/{id}', [SalaryController::class, 'delete'])->middleware(['is.logged', 'can:employee_basic_salary_delete']);
    Route::post('/salary/save', [SalaryController::class, 'save'])->middleware(['is.logged', 'can:employee_basic_salary_create']);
    /** End Salary */



    /** Category */
    Route::post('/category', [CategoryController::class, 'save'])->middleware(['is.logged', 'can:employee_category_create']);

    Route::put('/category/update/{id}', [CategoryController::class, 'update'])->middleware(['is.logged', 'can:employee_category_edit']);
    Route::put('/category/disable/{id}', [CategoryController::class, 'disable'])->middleware(['is.logged', 'can:employee_category_enable_disable']);

    Route::get('/category/allCategories', [CategoryController::class, 'allCategories']);
    Route::get('/category/category/{id}', [CategoryController::class, 'category']);

    Route::delete('/category/delete/{id}', [CategoryController::class, 'delete'])->middleware(['is.logged', 'can:employee_category_delete']);
    /** End Category */


    /** Other Earning Deduction (Employee Allowance) */
    Route::get('/OtherEarningDeduction/narations/{type}', [OtherEarningDeductionController::class, 'narations']);
    Route::get('/OtherEarningDeduction/allAllowance', [OtherEarningDeductionController::class, 'allAllowance']);
    Route::get('/OtherEarningDeduction/allowance/{id}', [OtherEarningDeductionController::class, 'allowance']);

    Route::post('/OtherEarningDeduction', [OtherEarningDeductionController::class, 'save'])->middleware(['is.logged', 'can:employee_earn_deduct_create']);

    Route::put('/OtherEarningDeduction/update/{id}', [OtherEarningDeductionController::class, 'update'])->middleware(['is.logged', 'can:employee_earn_deduct_edit']);

    Route::delete('/OtherEarningDeduction/delete/{id}', [OtherEarningDeductionController::class, 'delete'])->middleware(['is.logged', 'can:employee_earn_deduct_delete']);
    /** End Other Earning Deduction */



    /** Employee Other Erning Deduction */
    Route::get('/employeeAllowance/allSettings', [EmployeeOtherEarningDeductionController::class, "allSettings"]);
    Route::get('/employeeAllowance/subSection/{section_id}', [EmployeeOtherEarningDeductionController::class, "subSection"]);

    Route::get('/employeeAllowance/category/{allowance_id}/{amount}', [EmployeeOtherEarningDeductionController::class, "applyCategory"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_create']);
    Route::get('/employeeAllowance/site/{allowance_id}/{amount}', [EmployeeOtherEarningDeductionController::class, "applySite"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_create']);
    Route::get('/employeeAllowance/department/{allowance_id}/{amount}', [EmployeeOtherEarningDeductionController::class, "applyDepartment"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_create']);
    Route::get('/employeeAllowance/section/{allowance_id}/{amount}', [EmployeeOtherEarningDeductionController::class, "applySection"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_create']);
    Route::get('/employeeAllowance/subsection/{allowance_id}/{amount}', [EmployeeOtherEarningDeductionController::class, "applySubsection"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_create']);
    Route::get('/employeeAllowance/company/{allowance_id}/{amount}', [EmployeeOtherEarningDeductionController::class, "applyCompany"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_create']);
    Route::get('/employeeAllowance/team/{allowance_id}/{amount}', [EmployeeOtherEarningDeductionController::class, "applyTeam"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_create']);
    Route::get('/employeeAllowance/byEmployeeId/{allowance_id}/{amount}', [EmployeeOtherEarningDeductionController::class, "applyByEmployeeId"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_create']);

    Route::get('/employeeAllowance/{settings}', [EmployeeOtherEarningDeductionController::class, "employeeAllowance"]);

    Route::get('/employeeAllowance/getAllowance/{id}', [EmployeeOtherEarningDeductionController::class, "getAllowance"]);

    Route::delete('/employeeAllowance/deny/category', [EmployeeOtherEarningDeductionController::class, "denyCategory"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_remove']);
    Route::delete('/employeeAllowance/deny/site', [EmployeeOtherEarningDeductionController::class, "denySite"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_remove']);
    Route::delete('/employeeAllowance/deny/department', [EmployeeOtherEarningDeductionController::class, "denyDepartment"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_remove']);
    Route::delete('/employeeAllowance/deny/section', [EmployeeOtherEarningDeductionController::class, "denySection"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_remove']);
    Route::delete('/employeeAllowance/deny/subsection', [EmployeeOtherEarningDeductionController::class, "denySubsection"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_remove']);
    Route::delete('/employeeAllowance/deny/company', [EmployeeOtherEarningDeductionController::class, "denyCompany"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_remove']);
    Route::delete('/employeeAllowance/deny/team', [EmployeeOtherEarningDeductionController::class, "denyTeam"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_remove']);
    Route::delete('/employeeAllowance/deny/employee', [EmployeeOtherEarningDeductionController::class, "denyEmployee"])->middleware(['is.logged', 'can:employee_earn_deduct_setup_remove']);
    Route::delete('/employeeAllowance/delete', [EmployeeOtherEarningDeductionController::class, "deleteAllowance"]);
    /** End Employee Other Erning Deduction */



    /** Salary Advance */
    Route::get('/salaryAdvance/allEmployeeId', [SalaryAdavnceController::class, 'allEmployeeId']);
    Route::get('/salaryAdvance/allEmployeeName', [SalaryAdavnceController::class, 'allEmployeeName']);
    Route::get('/salaryAdvance/employee/{id}', [SalaryAdavnceController::class, 'getEmployeeByID']);
    Route::get('/salaryAdvance/allSalaryAdvance', [SalaryAdavnceController::class, "allSalaryAdvance"]);
    Route::get('/salaryAdvance/employeeFromList/{id}', [SalaryAdavnceController::class, 'employeeFromList']);

    Route::post('/salaryAdvance', [SalaryAdavnceController::class, 'save'])->middleware(['is.logged', 'can:employee_salary_advance_create']);

    Route::put('/salaryAdvance/update/{id}', [SalaryAdavnceController::class, 'update'])->middleware(['is.logged', 'can:employee_salary_advance_edit']);

    Route::delete('/salaryAdvance/deleteSalaryDataFromID/{id}', [SalaryAdavnceController::class, "delete"])->middleware(['is.logged', 'can:employee_salary_advance_delete']);
    /** End Salary Advance */




    /** Loan */
    Route::get('/loan/allEmployeeId', [LoanController::class, 'allEmployeeId']);
    Route::get('/loan/allEmployeeName', [LoanController::class, 'allEmployeeName']);
    Route::get('/loan/employee/{id}', [LoanController::class, 'getEmployeeByID']);
    Route::get('/loan/allLoan', [LoanController::class, "allLoan"]);
    Route::get('/loan/loanFromList/{id}', [LoanController::class, 'loanFromList']);

    Route::post('/loan', [LoanController::class, 'save'])->middleware(['is.logged', 'can:employee_loan_create']);

    Route::put('/loan/update/{id}', [LoanController::class, 'update'])->middleware(['is.logged', 'can:employee_loan_edit']);

    Route::delete('/loan/deleteLoanFromID/{id}', [LoanController::class, "delete"])->middleware(['is.logged', 'can:employee_loan_delete']);
    /** End Loan */



    /** Debtor Loan */
    Route::get('/debtorLoan/allEmployeeId', [DebtorLoanController::class, 'allEmployeeId']);
    Route::get('/debtorLoan/allEmployeeName', [DebtorLoanController::class, 'allEmployeeName']);
    Route::get('/debtorLoan/employee/{id}', [DebtorLoanController::class, 'getEmployeeByID']);
    Route::get('/debtorLoan/allLoan', [DebtorLoanController::class, "allLoan"]);
    Route::get('/debtorLoan/loanFromList/{id}', [DebtorLoanController::class, 'loanFromList']);

    Route::post('/debtorLoan', [DebtorLoanController::class, 'save'])->middleware(['is.logged', 'can:employee_debtor_loan_create']);

    Route::put('/debtorLoan/update/{id}', [DebtorLoanController::class, 'update'])->middleware(['is.logged', 'can:employee_debtor_loan_edit']);

    Route::delete('/debtorLoan/deleteLoanFromID/{id}', [DebtorLoanController::class, "delete"])->middleware(['is.logged', 'can:employee_debtor_loan_delete']);
    /** End Debtor Loan */





    /** Attendance Settings */
    Route::post('/attSettings/attHolidayType', [AtdSettingsController::class, 'saveHolidayType'])->middleware(['is.logged', 'can:employee_attendance_holiday_create']);
    Route::post('/attSettings/attSpecialWorkDayType', [AtdSettingsController::class, 'saveWorkDayType'])->middleware(['is.logged', 'can:employee_attendance_workday_create']);
    Route::post('/attSettings/attLeaveType', [AtdSettingsController::class, 'saveLeaveType'])->middleware(['is.logged', 'can:employee_attendance_leave_create']);

    Route::get('/attSettings/attHolidayType/allHolidayType', [AtdSettingsController::class, 'allHolidayType']);
    Route::get('/attSettings/attWorkDayType/allWorkDayType', [AtdSettingsController::class, 'allWorkDayType']);
    Route::get('/attSettings/attLeaveType/allLeaveType', [AtdSettingsController::class, 'allLeaveType']);
    Route::get('/attSettings/attHolidayType/holidayType/{id}', [AtdSettingsController::class, 'holidayType']);
    Route::get('/attSettings/attWorkDayType/workdayType/{id}', [AtdSettingsController::class, 'workdayType']);
    Route::get('/attSettings/attLeaveType/leaveType/{id}', [AtdSettingsController::class, 'leaveType']);

    Route::put('/attSettings/attHolidayType/updateHolidayType/{id}', [AtdSettingsController::class, 'updateHolidayType'])->middleware(['is.logged', 'can:employee_attendance_holiday_edit']);
    Route::put('/attSettings/attHolidayType/updateWorkdayType/{id}', [AtdSettingsController::class, 'updateWorkdayType'])->middleware(['is.logged', 'can:employee_attendance_workday_edit']);
    Route::put('/attSettings/attLeaveType/updateLeaveType/{id}', [AtdSettingsController::class, 'updateLeaveType'])->middleware(['is.logged', 'can:employee_attendance_leave_edit']);

    Route::put('/attSettings/attHolidayType/disableHolidayType/{id}', [AtdSettingsController::class, 'disableHolidayType'])->middleware(['is.logged', 'can:employee_attendance_holiday_enable_disable']);
    Route::put('/attSettings/attWorkDayType/disableWorkDayType/{id}', [AtdSettingsController::class, 'disableWorkDayType'])->middleware(['is.logged', 'can:employee_attendance_workday_enable_disable']);
    Route::put('/attSettings/attLeaveType/disableLeaveType/{id}', [AtdSettingsController::class, 'disableLeaveType'])->middleware(['is.logged', 'can:employee_attendance_leave_enable_disable']);
    /** Attendance Settings */




    /** Holiday */ 
    Route::get('/holiday/allSite', [AtdHolidayController::class, 'allSite']);
    Route::get('/holiday/allHolidayType', [AtdHolidayController::class, 'allHolidayType']);
    Route::get('/holiday/allHoliday', [AtdHolidayController::class, 'allHoliday']);
    Route::get('/holiday/getHoliday/{id}', [AtdHolidayController::class, 'getHoliday']);

    Route::post('/atdHoliday', [AtdHolidayController::class, 'save'])->middleware(['is.logged', 'can:employee_holiday_create']);

    Route::put('/atdHoliday/updateHoliday/{id}', [AtdHolidayController::class, 'update'])->middleware(['is.logged', 'can:employee_holiday_edit']);

    Route::delete('/holiday/{id}', [AtdHolidayController::class, "delete"])->middleware(['is.logged', 'can:employee_holiday_delete']);
    /** End Holiday */



    /** SpWorkdays */
    Route::get('/spWorkday/allSpWorkdayType', [AttSpcWorkdaysController::class, 'allSpWorkdayType']);
    Route::get('/spWorkday/allSpWorkday', [AttSpcWorkdaysController::class, 'allSpWorkday']);
    Route::get('/spWorkday/getSpWorkday/{id}', [AttSpcWorkdaysController::class, 'getSpWorkday']);

    Route::post('/spWorkday', [AttSpcWorkdaysController::class, 'save'])->middleware(['is.logged', 'can:employee_special_workday_create']);

    Route::put('/spWorkday/updateSpWorkday/{id}', [AttSpcWorkdaysController::class, 'update'])->middleware(['is.logged', 'can:employee_special_workday_edit']);

    Route::delete('/spWorkday/{id}', [AttSpcWorkdaysController::class, "delete"])->middleware(['is.logged', 'can:employee_special_workday_delete']);
    /** End SpWorkdays */



    /** Attendance Employee Leave */
    Route::get('/attendanceEmployeeLeave/allSettings', [AttEmployeeLeaveController::class, "allSettings"]);
    Route::get('/attendanceEmployeeLeave/subSection/{section_id}', [AttEmployeeLeaveController::class, "subSection"]);
    Route::get('/attendanceEmployeeLeave/{settings}', [AttEmployeeLeaveController::class, "employeeLeave"]);
    Route::get('/attendanceEmployeeLeave/isExcededCount/{id}/{count}', [AttEmployeeLeaveController::class, "isExcededCount"]);

    Route::post('/attendanceEmployeeLeave/category', [AttEmployeeLeaveController::class, "applyCategory"])->middleware(['is.logged', 'can:employee_leave_create']);
    Route::post('/attendanceEmployeeLeave/site', [AttEmployeeLeaveController::class, "applySite"])->middleware(['is.logged', 'can:employee_leave_create']);
    Route::post('/attendanceEmployeeLeave/department', [AttEmployeeLeaveController::class, "applyDepartment"])->middleware(['is.logged', 'can:employee_leave_create']);
    Route::post('/attendanceEmployeeLeave/section', [AttEmployeeLeaveController::class, "applySection"])->middleware(['is.logged', 'can:employee_leave_create']);
    Route::post('/attendanceEmployeeLeave/subsection', [AttEmployeeLeaveController::class, "applySubsection"])->middleware(['is.logged', 'can:employee_leave_create']);
    Route::post('/attendanceEmployeeLeave/company', [AttEmployeeLeaveController::class, "applyCompany"])->middleware(['is.logged', 'can:employee_leave_create']);
    Route::post('/attendanceEmployeeLeave/byEmployeeId', [AttEmployeeLeaveController::class, "applyByEmployeeId"])->middleware(['is.logged', 'can:employee_leave_create']);
    Route::post('/attendanceEmployeeLeave/allEmployee', [AttEmployeeLeaveController::class, "applyAllEmployee"])->middleware(['is.logged', 'can:employee_leave_create']);
    Route::post('/attendanceEmployeeLeave/updateLeaveCount', [AttEmployeeLeaveController::class, "updateLeaveCount"]);

    Route::delete('/attendanceEmployeeLeave/remove/category', [AttEmployeeLeaveController::class, "removeCategory"])->middleware(['is.logged', 'can:employee_leave_remove']);
    Route::delete('/attendanceEmployeeLeave/remove/site', [AttEmployeeLeaveController::class, "removeSite"])->middleware(['is.logged', 'can:employee_leave_remove']);
    Route::delete('/attendanceEmployeeLeave/remove/department', [AttEmployeeLeaveController::class, "removeDepartment"])->middleware(['is.logged', 'can:employee_leave_remove']);
    Route::delete('/attendanceEmployeeLeave/remove/section', [AttEmployeeLeaveController::class, "removeSection"])->middleware(['is.logged', 'can:employee_leave_remove']);
    Route::delete('/attendanceEmployeeLeave/remove/subsection', [AttEmployeeLeaveController::class, "removeSubsection"])->middleware(['is.logged', 'can:employee_leave_remove']);
    Route::delete('/attendanceEmployeeLeave/remove/company', [AttEmployeeLeaveController::class, "removeCompany"])->middleware(['is.logged', 'can:employee_leave_remove']);
    Route::delete('/attendanceEmployeeLeave/remove/employee', [AttEmployeeLeaveController::class, "removeEmployee"])->middleware(['is.logged', 'can:employee_leave_remove']);
    Route::delete('/attendanceEmployeeLeave/remove/allemployee', [AttEmployeeLeaveController::class, "removeAllEmployee"])->middleware(['is.logged', 'can:employee_leave_remove']);
    Route::delete('/attendanceEmployeeLeave/delete', [AttEmployeeLeaveController::class, "deleteLeave"])->middleware(['is.logged', 'can:employee_leave_remove']);
    /** End Attendance Employee Leave */


    /** Shift */
    Route::post('/shift/store', [AttShiftController::class, 'save'])->middleware(['is.logged', 'can:employee_shift_create']);

    Route::put('/shift/update/{id}', [AttShiftController::class, 'update'])->middleware(['is.logged', 'can:employee_shift_edit']);
    Route::put('/shift/disable/{id}', [AttShiftController::class, 'disable'])->middleware(['is.logged', 'can:employee_shift_enable_disable']);

    Route::delete('/shift/delete/{id}', [AttShiftController::class, 'delete'])->middleware(['is.logged', 'can:employee_shift_delete']);

    Route::get('/shift/allShift', [AttShiftController::class, 'allShift']);
    Route::get('/shift/getShift/{id}', [AttShiftController::class, 'getShift']);
    /** End Shift */



    /** Attendance Schedule */
    Route::post('/attendanceEmployeeSchedule/applySchedule', [AttScheduleController::class, 'applySchedule'])->middleware(['is.logged', 'can:employee_schedule_create']);
    Route::get('/attendanceEmployeeScheduleSetting/allSettings', [AttScheduleController::class, 'allSettings']);
    Route::get('/attendanceEmployeeScheduleSetting/subsection/{section_id}', [AttScheduleController::class, 'subsection']);
    Route::get('/attendanceEmployeeSchedule/shiftIntimeOutTime/{shift_id}', [AttScheduleController::class, 'shiftIntimeOutTime']);
    Route::get('/attendanceEmployeeScheduleSetting/scheduleCategory/{shift_id}/{site_id}/{setting_array}/{select_option}/{start_date}/{end_date}', [AttScheduleController::class, 'loadScheduleFromSettings']);
    Route::get('/attendanceEmployeeSchedule/loadEmployeeFromSite/{site_id}',[AttScheduleController::class,'loadEmployeeFromSite']);
    Route::delete('/attendanceEmployeeSchedule/removeSchedule/{id}', [AttScheduleController::class, 'removeSchedule'])->middleware(['is.logged', 'can:employee_schedule_remove']);
    Route::post('/attendanceEmployeeSchedule/removeAllSchedule', [AttScheduleController::class, 'removeAllSchedule'])->middleware(['is.logged', 'can:employee_schedule_remove']);
    /** End Attendance Schedule */


    /** Attendance Employee Schedule Supervisor */
    Route::get('/attendanceEmployeeScheduleSupervisor/allEmployeeId', [AttEmployeeScheduleSupervisorController::class, 'allEmployeeId']);
    Route::get('/attendanceEmployeeScheduleSupervisor/allEmployeeName', [AttEmployeeScheduleSupervisorController::class, 'allEmployeeName']);
    Route::get('/attendanceEmployeeScheduleSupervisor/employee/{id}', [AttEmployeeScheduleSupervisorController::class, 'getEmployeeByID']);

    Route::get('/attendanceEmployeeScheduleSupervisor/allShift', [AttEmployeeScheduleSupervisorController::class, 'allShift']);
    Route::get('/attendanceEmployeeScheduleSupervisor/getShiftIntimeOutTime/{id}', [AttEmployeeScheduleSupervisorController::class, 'getShiftIntimeOutTime']);
    Route::get('/attendanceEmployeeScheduleSupervisor/allEmployeeSchedule/{id}', [AttEmployeeScheduleSupervisorController::class, 'getAllEmployeeSchedule']);
    Route::get('/attendanceEmployeeScheduleSupervisor/allEmployee/{id}', [AttEmployeeScheduleSupervisorController::class, 'getAllEmployee']);
    Route::get('/attendanceEmployeeScheduleSupervisor/getEmployeeShift/{id}', [AttEmployeeScheduleSupervisorController::class, 'getEmployeeShift']);
    Route::get('/attendanceEmployeeScheduleSupervisor/getServerDate', [AttEmployeeScheduleSupervisorController::class, 'serverDate']);
    Route::get('/attendanceEmployeeScheduleSupervisor/supervisorSchedule/{id}', [AttEmployeeScheduleSupervisorController::class, 'getSupervisorSchedule']);
    Route::get('/attendanceEmployeeScheduleSupervisor/supervisorScheduleDateRange/{id}', [AttEmployeeScheduleSupervisorController::class, 'getSupervisorDateRange']);
    Route::get('/attendanceEmployeeScheduleSupervisor/employeeHolidays', [AttEmployeeScheduleSupervisorController::class, 'getEmplyeeHolidays']);

    Route::delete('/attendanceEmployeeScheduleSupervisor/removeShift/{id}', [AttEmployeeScheduleSupervisorController::class, 'removeShift'])->middleware(['is.logged', 'can:employee_schedule_supervisor_remove']);

    Route::post('/attendanceEmployeeScheduleSupervisor/applySchedule', [AttEmployeeScheduleSupervisorController::class, 'applySchedule'])->middleware(['is.logged', 'can:employee_schedule_supervisor_create']);

    Route::put('/attendanceEmployeeScheduleSupervisor/updateShift/{id}', [AttEmployeeScheduleSupervisorController::class, 'updateShift'])->middleware(['is.logged', 'can:employee_schedule_supervisor_edit']);
    /** End Attendance Employee Schedule Supervisor */




    /** Attendance Employee Schedule */
    Route::get('/attendanceEmployeeSchedule/allEmployeeId', [AttEmployeeScheduleController::class, 'allEmployeeId']);
    Route::get('/attendanceEmployeeSchedule/allEmployeeName', [AttEmployeeScheduleController::class, 'allEmployeeName']);
    Route::get('/attendanceEmployeeSchedule/employee/{id}', [AttEmployeeScheduleController::class, 'getEmployeeByID']);
    Route::get('/attendanceEmployeeSchedule/employeeSchedule/{id}', [AttEmployeeScheduleController::class, 'getEmployeeSchedule']);
    Route::get('/attendanceEmployeeSchedule/employeeScheduleDateRange/{id}', [AttEmployeeScheduleController::class, 'getEmployeeScheduleDateRange']);
    Route::get('/attendanceEmployeeSchedule/employeeHolidays', [AttEmployeeScheduleController::class, 'getEmplyeeHolidays']);
    /** End Attendance Employee Schedule */



    /** Report Employee List */
    Route::get('/reportEmployeeList/allSettings', [ReportEmployeeListController::class, "allSettings"]);
    Route::get('/reportEmployeeList/search', [ReportEmployeeListController::class, "search"]);
    Route::get('/reportEmployeeList/allEmployeeSite/{id}', [ReportEmployeeListController::class, "allEmployeeSite"]);
    /** End Report Employee List */



    /** Team */
    Route::post('/team', [TeamController::class, 'save'])->middleware(['is.logged', 'can:employee_team_create']);

    Route::get('/team/allEmployeeName', [TeamController::class, 'allEmployeeName']);
    Route::get('/team/allTeams', [TeamController::class, 'allTeams']);
    Route::get('/team/team/{id}', [TeamController::class, 'team']);

    Route::put('/team/disable/{id}', [TeamController::class, 'disable'])->middleware(['is.logged', 'can:employee_team_enable_disable']);
    Route::put('/team/update/{id}', [TeamController::class, 'update'])->middleware(['is.logged', 'can:employee_team_edit']);

    Route::delete('/team/delete/{id}', [TeamController::class, 'delete'])->middleware(['is.logged', 'can:employee_team_delete']);
    /** End Team */




    /** Employee Team */
    Route::get('/teamEmployee/allEmployee', [EmployeeTeamController::class, 'getAllEmployee']);
    Route::get('/employeeTeam/allTeams', [EmployeeTeamController::class, 'allTeam']);
    Route::get('/employeeTeam/allTeamMembers/{id}', [EmployeeTeamController::class, 'getTeamMember']);
    Route::get('/employeeTeam/isAssignedMmber/{id}', [EmployeeTeamController::class, 'isAssignedMmber']);

    Route::post('/team/setTeam', [EmployeeTeamController::class, 'setTeam'])->middleware(['is.logged', 'can:employee_team_assign_set']);

    Route::delete('/employeeTeam/remove/{id}', [EmployeeTeamController::class, 'remove'])->middleware(['is.logged', 'can:employee_team_assign_remove']);
    /** End Employee Team */


    /** Employee Team Schedule */
    Route::get('/employeeTeamSchedule/allTeams', [EmployeeTeamScheduleController::class, 'allTeam']);
    Route::get('/employeeTeamSchedule/allTeamMembers/{id}', [EmployeeTeamScheduleController::class, 'getAllEmployee']);
    Route::get('/employeeTeamSchedule/allShift', [EmployeeTeamScheduleController::class, 'allShift']);
    Route::get('/employeeTeamSchedule/allEmployeeSchedule/{id}', [EmployeeTeamScheduleController::class, 'getAllEmployeeSchedule']);
    Route::get('/employeeTeamSchedule/getEmployeeShift/{id}', [EmployeeTeamScheduleController::class, 'getEmployeeShift']);
    Route::get('/employeeTeamSchedule/getServerDate', [EmployeeTeamScheduleController::class, 'serverDate']);
    Route::get('/employeeTeamSchedule/teamSchedule/{id}', [EmployeeTeamScheduleController::class, 'getTeamSchedule']);
    Route::get('/employeeTeamSchedule/teamScheduleDateRange/{id}', [EmployeeTeamScheduleController::class, 'getTeamScheduleDateRange']);
    Route::get('/employeeTeamSchedule/employeeHolidays', [EmployeeTeamScheduleController::class, 'getEmplyeeHolidays']);

    Route::delete('/employeeTeamSchedule/removeShift/{id}', [EmployeeTeamScheduleController::class, 'removeShift'])->middleware(['is.logged', 'can:employee_schedule_team_remove']);

    Route::post('/employeeTeamSchedule/applyShift', [EmployeeTeamScheduleController::class, 'applyShift'])->middleware(['is.logged', 'can:employee_schedule_team_create']);

    Route::put('/employeeTeamSchedule/updateShift/{id}', [EmployeeTeamScheduleController::class, 'updateShift'])->middleware(['is.logged', 'can:employee_schedule_team_edit']);
    /** End Employee Team Schedule */

    /** Recruitment */
    Route::post('/recruitment_request', [RecruitmentController::class, 'save']);
    Route::post('/recruitment/update', [RecruitmentController::class, 'update']);
    Route::get('/recruitment/allRecruitment', [RecruitmentController::class, 'allRecriutment']);
    Route::get('/recruitment/recruitment/{id}', [RecruitmentController::class, 'recruitment']);
    Route::get('/recruitment/settings', [RecruitmentController::class, 'settings']);
    Route::delete('/recruitment/{id}', [RecruitmentController::class, 'delete']);
    /** End Recruitment */

    /** Leave */
    Route::post('/leave', [LeaveController::class, 'save']);
    Route::post('/leave/update', [LeaveController::class, 'update']);
    Route::get('/leave/settings', [LeaveController::class, 'settings']);
    Route::get('/leave/type/{id}', [LeaveController::class, 'leaveType']);
    Route::get('/leave/searchName', [LeaveController::class, 'searchName']);
    Route::get('/leave/allEmployeeID', [LeaveController::class, 'allEmployeeID']);
    Route::get('/leave/employee/{id}', [LeaveController::class, 'employee']);
    Route::get('/leave/getName/{id}', [LeaveController::class, 'getName']);
    Route::get('/leave/allLeave', [LeaveController::class, 'allLeave']);
    Route::get('/leave/leave/{id}', [LeaveController::class, 'leave']);
    Route::delete('/leave/{id}', [LeaveController::class, 'delete']);
    Route::post('/leave/confirmed/{id}/{user_id}', [LeaveController::class, 'confirmed']);
    Route::post('/leave/reject/{id}', [LeaveController::class, 'reject']);
    Route::get('/leave/leaveCount/{employee_id}/{leaveType}/{year}', [LeaveController::class, 'leaveCount']);
    Route::get('/leave/employeeLeaveData/{year}/{employee_id}', [LeaveController::class, 'employeeLeaveData']);
    Route::get('/leave/employeeLeaveCount/{employee_id}/{year}/{leaveType}', [LeaveController::class, 'employeeLeaveCount']);
    Route::get('/leave/getDayCount/{dateFrom}/{dateTo}', [LeaveController::class, 'getDayCount']);
    /** End Leave */


    /** AttendanceReportEdit Controller */ 
    Route::get('/attendanceReportEdit/allEmployeeId', [AttendanceReportEditController::class, 'allEmployeeId']);
    Route::get('/attendanceReportEdit/allEmployeeName', [AttendanceReportEditController::class, 'allEmployeeName']);
    Route::get('/attendanceReportEdit/employee/{id}', [AttendanceReportEditController::class, 'employee']);
    Route::get('/attendanceReportEdit/employeeAttendance/{id}/{startDate}/{endDate}', [AttendanceReportEditController::class, 'getAttendance_test']);
    Route::get('/attendanceReportEdit/attendanceRawData/{id}/{date}', [AttendanceReportEditController::class, 'attendanceRawData']);
    Route::put('/attendanceReportEdit/updateInOut/{id}', [AttendanceReportEditController::class, 'updateInOut']);
    /** End AttendanceReportEdit Controller */

    /** svrController */
    Route::get('/svr/date', [SvrController::class, 'serverDate']);
    /** End svrController */


    /** ReportAttSheetController */
    Route::get('/reportAttSheet/allSettings', [ReportAttSheetController::class, 'allSettings']);
    Route::get('/reportAttSheet/subSection/{id}', [ReportAttSheetController::class, 'subSection']);
    Route::get('/reportAttSheet/attendanceReport/{setting}', [ReportAttSheetController::class, 'attendanceReport_test']);
    Route::get('/reportAttSheet/detailsReport/{setting}', [ReportAttSheetController::class, 'detailsReport_test']);
    Route::get('/reportAttSheet/attendanceMissingReport/{setting}', [ReportAttSheetController::class, 'attendanceMissingReport']);
    /** End ReportAttSheetController */


    /** AttendanceReportEdit Controller */
    Route::get('/attendanceReportEdit/allEmployeeId', [AttendanceReportEditController::class, 'allEmployeeId']);
    Route::get('/attendanceReportEdit/employee/{id}', [AttendanceReportEditController::class, 'employee']);
    Route::get('/attendanceReportEdit/employeeAttendance/{id}/{startDate}/{endDate}', [AttendanceReportEditController::class, 'getAttendance_test']);
    Route::get('/attendanceReportEdit/attendanceRawData/{id}/{date}', [AttendanceReportEditController::class, 'attendanceRawData']);
    Route::put('/attendanceReportEdit/updateInOut/{id}', [AttendanceReportEditController::class, 'updateInOut']);
    /** End AttendanceReportEdit Controller */

    /** AttendanceProcess Controller */
    Route::get('/attendanceProcess/allEmployees', [AttendanceProcessController::class, 'allEmployees']);
    Route::get('/attendanceProcess/allEmployeesSite', [AttendanceProcessController::class, 'allEmployeesSite']);
    Route::get('/attendanceProcess/getProcessEmployees', [AttendanceProcessController::class, 'getProcessEmployees']);
    Route::get('/attendanceRawDataProcessAll/{id}/{fromDate}/{toDate}', [AttendanceProcessController::class, 'attendanceRawDataProcessAll']);
    Route::get('/attendanceRawDataProcessEmployee/{id}/{fromDate}/{toDate}', [AttendanceProcessController::class, 'attendanceRawDataProcessEmployee']);
    Route::get('/attendanceCalculationEmployee/{id}/{fromDate}/{toDate}', [AttendanceProcessController::class, 'attendanceCalculationProcessEmployee']);
    Route::get('/attendanceCalculationAll/{id}/{fromDate}/{toDate}', [AttendanceProcessController::class, 'attendanceCalculationProcessAll']);
    Route::get('/attendancePostPayrollEmployee/{id}/{fromDate}/{toDate}', [AttendanceProcessController::class, 'attendancePostPayrollProcessEmployee']);
    Route::get('/attendancePostPayrollAll/{fromDate}/{toDate}', [AttendanceProcessController::class, 'attendancePostPayrollProcessAll']);
    Route::get('/attendanceMontendProcess/{year}/{month}', [AttendanceProcessController::class, 'attendanceMontendProcess']);
    /** End AttendanceProcess Controller */ 

    /** Supervisor Attendance Approval Controller */
    Route::get('/supervisorApproval/employeeAttendance/{uid}/{date}', [SupervisorApprovalController::class, 'attendance']);
    Route::post('/supervisorApproval/approval', [SupervisorApprovalController::class, 'approval'])->middleware(['is.logged', 'can:employee_supervisor_attendance_submit']);
    /** End Supervisor Attendance Approval Controller */


    /** PayRollReportController */
    Route::get('/payrollReport/allSettings', [PayrollReportController::class, 'allSettings']);
    Route::get('/payrollReport/subSection/{id}', [PayrollReportController::class, 'subSection']);
    Route::get('/payrollReport/dailyOTReport/{setting}/{date}', [PayrollReportController::class, 'dailyOTReport']);
    Route::get('/payrollReport/highOTReopt/{setting}/{date_from}/{date_to}', [PayrollReportController::class, 'highOTReopt']);
    Route::get('/payrollReport/monthlyOTSummaryReport/{setting}/{date_from}/{date_to}', [PayrollReportController::class, 'monthlyOTSummaryReport']);
    Route::get('/payrollReport/epf_etfReports/{setting}/{date}', [PayrollReportController::class, 'epf_etfReports']);
    Route::get('/payrollReport/nightAllowanceReport/{setting}/{start_date}/{end_date}', [PayrollReportController::class, 'nightAllowanceReport']);
    Route::get('/payrollReport/attendanceAllowanceReport/{setting}/{date}', [PayrollReportController::class, 'attendanceAllowanceReport']);
    Route::get('/payrollReport/payAdviceReport/{setting}', [PayrollReportController::class, 'payAdviceReport']);
    Route::get('/payrollReport/salaryReport/{setting}', [PayrollReportController::class, 'salaryReport']);
    Route::get('/payrollReport/employeeDailyOTReport/{setting}/{year}/{month}', [PayrollReportController::class, 'employeeDailyOTReport']);
    /** End PayRollReportController */


    /** EmployeeDetailReportController */
    Route::get('/employeeReport/allSettings', [EmployeeDetailReportController::class, 'allSettings']);
    Route::get('/employeeReport/subSection/{id}', [EmployeeDetailReportController::class, 'subSection']);
    Route::get('/employeeReport/detailReport/{setting}', [EmployeeDetailReportController::class, 'detailReport']);
    Route::get('/employeeReport/basicSalaryReport/{setting}/{date}', [EmployeeDetailReportController::class, 'basicSalaryReport']);
    Route::get('/employeeReport/resignEmployeeDetailsReport/{setting}/{date_from}/{date_to}', [EmployeeDetailReportController::class, 'resignEmployeeDetailsReport']);
    Route::get('/employeeReport/leaveStatusReport/{setting}', [EmployeeDetailReportController::class, 'leaveStatusReport']);
    /** End EmployeeDetailReportController */


    /** EmployeeAttendanceReportController */
    Route::get('/employeeAttendanceReport/allSettings', [EmployeeAttendanceReportController::class, 'allSettings']);
    Route::get('/employeeAttendanceReport/subSection/{id}', [EmployeeAttendanceReportController::class, 'subSection']);
    Route::get('/employeeAttendanceReport/dailyAbsentReport/{setting}/{date}', [EmployeeAttendanceReportController::class, 'dailyAbsentReport']);
    Route::get('/employeeAttendanceReport/dailyPresentReport/{setting}/{date}', [EmployeeAttendanceReportController::class, 'dailyPresentReport']);
    Route::get('/employeeAttendanceReport/attendanceRegisterReport/{setting}/{year}/{month}', [EmployeeAttendanceReportController::class, 'AttendanceRegisterReport']);
    Route::get('/employeeAttendanceReport/dailyMarkingSheetReport/{setting}/{date}', [EmployeeAttendanceReportController::class, 'dailyMarkingSheetReport']);
    Route::get('/employeeAttendanceReport/dailyHeadCountReport/{setting}/{date}', [EmployeeAttendanceReportController::class, 'dailyHeadCountReport']);
    Route::get('/employeeAttendanceReport/attendanceSummryReport/{setting}/{date_from}/{date_to}', [EmployeeAttendanceReportController::class, 'attendanceSummryReport']);
    Route::get('/employeeAttendanceReport/timeCardsReport/{setting}/{date_from}/{date_to}', [EmployeeAttendanceReportController::class, 'timeCardsReport']);
    Route::get('/employeeAttendanceReport/dailyInvalidReport/{setting}/{date}', [EmployeeAttendanceReportController::class, 'dailyInvalidReport']);
    Route::get('/employeeAttendanceReport/leaveReport/{setting}/{date_from}/{date_to}', [EmployeeAttendanceReportController::class, 'leaveReport']);
    Route::get('/employeeAttendanceReport/attendanceReport/{setting}/{date_from}/{date_to}', [EmployeeAttendanceReportController::class, 'attendanceReport2']);
    Route::get('/employeeAttendanceReport/supervisorApprovalReport/{id}/{date_from}', [EmployeeAttendanceReportController::class, 'supervisorApprovalReport']);
    Route::get('/employeeAttendanceReport/employeeMissingRosterReport/{setting}/{date_from}/{date_to}', [EmployeeAttendanceReportController::class, 'rosterMissingReport']);
    /** End EmployeeAttendanceReportController */


    /** Import Salary Data */
    Route::get('/importSalaryData/allNaration/{type}', [ImportSalaryDataController::class, 'leaveStatusReport']);
    Route::post('/importSalaryData/validate', [ImportSalaryDataController::class, 'validate']);
    Route::post('/importSalaryData/save', [ImportSalaryDataController::class, 'save']);
    /** End Import Salary Data */

    /** Log Activity Employee */
    Route::get('/logactivityemployee/recordHistory/{id}', [LogActivityEmployeeController::class, 'recordHistory']);

    /** End Of Log Activity Employee */



    /** Attendance Drivers Schedule */
    Route::get('/driverRosterSchedule/isRoster/{id}/{date}', [AttendanceDriversScheduleController::class, 'isAllocateRoster']);
    Route::put('/driverRosterSchedule/createRoster/{id}', [AttendanceDriversScheduleController::class, 'createRoster']);
    /** End Of Attendance Drivers Schedule */

    
    /** Employee 3Month 6Month Completed */
    Route::get('/Employee3Month6MonthController/employee_3month_6month_completed', [Employee3Month6MonthController::class, 'employee_3month_6month_completed']);
    /** End of Employee 3Month 6Month Completed */


});
