<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDebtorLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_debtor_loans', function (Blueprint $table) {
            $table->id();
            $table->string('employee_id',25);
            $table->foreign('employee_id')->references('employee_id')->on('hr_employees')->onDelete('cascade');
            $table->double('amount');
            $table->double('no_of_terms');
            $table->double('interest_percentage');
            $table->double('paid_amount');
            $table->double('paid_terms');
            $table->date('tran_date');
            $table->integer('deduct_year');
            $table->integer('deduct_month');
            $table->integer('requested_by');
            $table->integer('approved_by');
            $table->integer('status');
            $table->string('reason',250);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('debtor_loans');
    }
}
