<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class EmployeeCategory extends Model
{
    protected $table = 'hr_employee_categories';
    protected $primaryKey = 'category_id';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'category_id',
        'category',
        'wage_calculate',
        'wage_pay_type',
        'work_days_month',
        'work_hour_day',
        'ot_rate1',
        'ot_rate2',
        'ot_rate3',
        'fixed_ot_rate1',
        'fixed_ot_rate2',
        'fixed_ot_rate3',
        'epf_employer',
        'epf_employee',
        'etf_employee',
        'budget_allowance1',
        'budget_allowance2',
        'fine_rate',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_employee_categories";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
