<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class EmployeeDesignation extends Model
{
    protected $table = 'hr_employee_designations';
    protected $primaryKey = 'designation_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'designation_id',
        'designation',
        'designation_sinhala',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_employee_designations";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
