<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class EmployeeSubsection extends Model
{
    protected $table = 'hr_employee_subsections';
    protected $primaryKey = 'subsection_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'subsection_id',
        'subsection',
        'status',
        'section_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_employee_subsections";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
