<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;

class AttEmployeeScheduleController extends Controller
{
    //
    public function allEmployeeId()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }










    public function allEmployeeName()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function getEmployeeByID($id)
    {
        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }










    public function getEmployeeSchedule($id)
    {

        try {
            //$date = date('Y-') . "%";

            $employees = DB::select("SELECT
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_schedules.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_att_schedules.`status` AS status
       FROM
            `hr_att_shifts` hr_att_shifts INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_att_shifts.`shift_id` = hr_att_schedules.`shift_id` where schedule_date_from LIKE '202%' AND employee_id = '" . $id . "' ORDER BY schedule_date_from");
            $responseBody = $this->responseBody(true, "Employee", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function getEmployeeScheduleDateRange(Request $request, $id)
    {

        try {
            $start = $request->get('start');
            $end = $request->get('end');

            $employees = DB::select("SELECT
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_schedules.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_att_schedules.`status` AS status
       FROM
            `hr_att_shifts` hr_att_shifts INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_att_shifts.`shift_id` = hr_att_schedules.`shift_id` where employee_id = '" . $id . "' AND schedule_date_from BETWEEN '" . $start . "' AND '" . $end . "' ORDER BY schedule_date_from");
            $responseBody = $this->responseBody(true, "Employee", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function getEmplyeeHolidays()
    {

        try {
            $holidays = DB::select("SELECT
            hr_atd_holiday_types.`holyday_type_id` AS holyday_type_id,
            hr_atd_holidays.`holyday_date` AS holyday_date,
            hr_atd_holiday_types.`holyday_type` AS holyday_type
       FROM
            `hr_atd_holiday_types` hr_atd_holiday_types INNER JOIN `hr_atd_holidays` hr_atd_holidays ON hr_atd_holiday_types.`holyday_type_id` = hr_atd_holidays.`holyday_type_id`");
            $responseBody = $this->responseBody(true, "Holidays", "all", $holidays);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holidays", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
