<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttSpcWorkdays;
use Modules\Hr\Entities\AttSpWorkType;

class AttSpcWorkdaysController extends Controller
{
    //

    public function allSpWorkdayType()
    {
        try {
            $workTypes = AttSpWorkType::all();
            $responseBody = $this->responseBody(true, "Holiday", "Holiday", $workTypes);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function save(Request $request)
    {

        try {
            $spWorkdays = new AttSpcWorkdays();
            $spWorkdays->sp_work_date = $request->get('date');
            $spWorkdays->sp_work_type_id = $request->get('spWorkType');
            $spWorkdays->remarks = $request->get('remark');
            $spWorkdays->day_type = $request->get('dayType');
            $save = $spWorkdays->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "SpecialWorkdays", "saved", null);
            } else {
                $responseBody = $this->responseBody(true, "SpecialWorkdays", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SpecialWorkdays", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function update(Request $request,$id)
    {

        try {
            $spWorkdays = AttSpcWorkdays::find($id);
            $spWorkdays->sp_work_date = $request->get('date');
            $spWorkdays->sp_work_type_id = $request->get('spWorkType');
            $spWorkdays->remarks = $request->get('remark');
            $spWorkdays->day_type = $request->get('dayType');
            $save = $spWorkdays->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "SpecialWorkdays", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "SpecialWorkdays", "updated", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SpecialWorkdays", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    public function allSpWorkday()
    {

        try {
            $holiday = DB::select('SELECT
            att_spc_workdays.`id` AS id,
            att_spc_workdays.`sp_work_date` AS sp_work_date,
            att_sp_work_types.`sp_work_type` AS sp_work_type
       FROM
            `hr_att_sp_work_types` att_sp_work_types INNER JOIN `hr_att_spc_workdays` att_spc_workdays ON att_sp_work_types.`sp_work_type_id` = att_spc_workdays.`sp_work_type_id`');

            $responseBody = $this->responseBody(true, "SpecialWorkdays", "allSpWorkday", $holiday);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SpecialWorkdays", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function delete($id)
    {
        try {
            $spWorkdays = AttSpcWorkdays::find($id);
            $delete = $spWorkdays->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "SpecialWorkdays", "deleted", null);
            } else {
                $responseBody = $this->responseBody(false, "SpecialWorkdays", "not deleted", $delete);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SpecialWorkdays", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    function getSpWorkday($id)
    {
        try {
            $spWorkdays = AttSpcWorkdays::find($id);
            $responseBody = $this->responseBody(true, "SpecialWorkdays", "SpecialWorkdays", $spWorkdays);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SpecialWorkdays", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
