<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttSchedule;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeDesignation;

class AttendanceDriversScheduleController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('hr::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('hr::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('hr::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('hr::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }




    public function isAllocateRoster($id, $date)
    {
        $designation = null;
        $schedule = null;
        try {
            $employee = Employee::find($id);
            if ($employee) {
                $designation =  EmployeeDesignation::find($employee->designation_id);
                $schedule = AttSchedule::where([['employee_id', '=', $id], ['schedule_date_from', '=', $date]])->first();
            } else {
                $designation = null;
                $schedule = null;
            }
            $responseBody = $this->responseBody(true, "Subsection", "all", ['designation' => $designation, 'schedule' => $schedule]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Subsection", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function  createRoster(Request $request, $id)
    {

        try {
            $schedule = AttSchedule::where([['employee_id', '=', $request->employee_id], ['schedule_date_from', '=', $request->schedule_date_from]])->get();
            if ($schedule->isEmpty()) {
                $intime = explode(" ", $request->schedule_in)[1];
                $H = explode(":", $intime)[0];
                $M = explode(":", $intime)[1];
                $S = explode(":", $intime)[2];
                $duration = 9;

                $outtime = $this->getOutTime($H, $M, $S, $duration);

                $roster = new AttSchedule();
                $roster->employee_id = $request->employee_id;
                $roster->shift_id = $request->shift;
                $roster->schedule_date_from = $request->schedule_date_from;
                $roster->in_time = $request->schedule_in;
                $roster->out_time = $request->schedule_date_from . ' ' . $outtime;
                $roster->status = 1;
                if ($roster->save()) {
                    $query = "UPDATE hr_att_time SET EmployeeID = '" . $request->employee_id . "',
                 InTime = '" . $request->attendance_in . "',OutTime = '" . $request->attendance_out . "',
                 In_Status = '1',Out_Status = '1',ShiftNO = '0',Edited = '1',
                 Original_InTime = '" . $request->attendance_in . "',Original_OutTime = '" . $request->attendance_out . "',Date ='" . $request->schedule_date_from . "' WHERE ID = '" . $id . "'";
                    DB::select($query);
                }
            }

            $responseBody = $this->responseBody(true, "AttendanceDriversScheduleController", "createRoster", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AttendanceDriversScheduleController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getOutTime($H, $M, $S, $duration)
    {

        $hours = $H + ($M + ($S / 60.0)) / 60.0;
        $endTime =  ($hours + $duration);
        if ($endTime >= 24.0) {
            $endTime -= 24.0;
        }
        $hh = floor($endTime);
        $endTime = ($endTime - $hh) * 60;
        $mm = floor($endTime);
        $endTime = ($endTime - $mm) * 60;
        $ss = floor($endTime);

        if (strlen($hh) == 1) {
            $hh = '0' . $hh;
        }
        if (strlen($mm) == 1) {
            $mm = '0' . $mm;
        }
        if (strlen($ss) == 1) {
            $ss = '0' . $ss;
        }

        return $hh . ':' . $mm . ':' . $ss;
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
