<?php

namespace Modules\Hr\Http\Controllers;

use Facade\FlareClient\Http\Response;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\GlobalSettings;
use Modules\Hr\Entities\SalaryData;
use Modules\Hr\Entities\TransactionItem;

class ImportSalaryDataController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('hr::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('hr::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('hr::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('hr::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }





    public function leaveStatusReport($type)
    {
        try {

            $transaction_items = TransactionItem::where('type', '=', $type)->get();
            $responseBody = $this->responseBody(true, "Import Salary Data", "all", $transaction_items);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Import Salary Data", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function save(Request $request)
    {
        $salary = null;
        try {
            $type = $request->get('type');
            $narration_id = $request->get('narration_id');
            $salary_month = $request->get('salary_month');
            $salary_year = $request->get('salary_year');
            $data = json_decode($request->get('data'));
            foreach ($data as $d) {
                $id = $d[0];
                $value = $d[1];


                $salary =  SalaryData::where([['employee_id', '=', $id], ['salary_month', '=', $salary_month], ['salary_year', '=', $salary_year]])->first();
                if ($salary) {
                    if ($type == 0) {
                        if ($salary->earn_trans_id_01 == $narration_id) {
                            $salary->earn_01 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_02 == $narration_id) {
                            $salary->earn_02 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_03 == $narration_id) {
                            $salary->earn_03 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_04 == $narration_id) {
                            $salary->earn_04 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_05 == $narration_id) {
                            $salary->earn_05 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_06 == $narration_id) {
                            $salary->earn_06 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_07 == $narration_id) {
                            $salary->earn_07 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_08 == $narration_id) {
                            $salary->earn_08 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_09 == $narration_id) {
                            $salary->earn_09 = $value;
                            //$total_earnings += $value;
                        } else if ($salary->earn_trans_id_10 == $narration_id) {
                            $salary->earn_10 = $value;
                            //$total_earnings += $value;
                        }
                    } else if ($type == 1) {
                        if ($salary->deduct_trans_id_01 == $narration_id) {
                            $salary->deduct_01 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_02 == $narration_id) {
                            $salary->deduct_02 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_03 == $narration_id) {
                            $salary->deduct_03 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_04 == $narration_id) {
                            $salary->deduct_04 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_05 == $narration_id) {
                            $salary->deduct_05 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_06 == $narration_id) {
                            $salary->deduct_06 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_07 == $narration_id) {
                            $salary->deduct_07 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_08 == $narration_id) {
                            $salary->deduct_08 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_09 == $narration_id) {
                            $salary->deduct_09 = $value;
                            //$total_deductions += $value;
                        } else if ($salary->deduct_trans_id_10 == $narration_id) {
                            $salary->deduct_10 = $value;
                            //$total_deductions += $value;
                        }
                    }

                    $total_earnings = 0;
                    $total_deductions = 0;

                    $total_earnings += $salary->earn_01;
                    $total_earnings += $salary->earn_02;
                    $total_earnings += $salary->earn_03;
                    $total_earnings += $salary->earn_04;
                    $total_earnings += $salary->earn_05;
                    $total_earnings += $salary->earn_06;
                    $total_earnings += $salary->earn_07;
                    $total_earnings += $salary->earn_08;
                    $total_earnings += $salary->earn_09;
                    $total_earnings += $salary->earn_10;

                    $total_deductions += $salary->deduct_01;
                    $total_deductions += $salary->deduct_02;
                    $total_deductions += $salary->deduct_03;
                    $total_deductions += $salary->deduct_04;
                    $total_deductions += $salary->deduct_05;
                    $total_deductions += $salary->deduct_06;
                    $total_deductions += $salary->deduct_07;
                    $total_deductions += $salary->deduct_08;
                    $total_deductions += $salary->deduct_09;
                    $total_deductions += $salary->deduct_10;

                    $total_earnings += $salary->ot_amount1;
                    $total_earnings += $salary->ot_amount2;
                    $total_earnings += $salary->ot_amount3;


                    $basic_earning = ($salary->basic_salary + $salary->budget1 + $salary->budget2);
                    $salary->gross_salary = ($basic_earning + $total_earnings);
                    $salary->total_deduction = ($total_deductions + $salary->employee_epf + $salary->fine_amount);
                    $salary->net_salary = ($salary->gross_salary - $salary->total_deduction);
                    $salary->update();
                }
            }
            $responseBody = $this->responseBody(true, "Import Salary Data", "save", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Import Salary Data", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function validate(Request $request)
    {
        try {
            $type = $request->get('type');
            $narration_id = $request->get('narration_id');
            $data = json_decode($request->get('data'));
            $arr = array();
            foreach ($data as $d) {
                $id = $d[0];
                $value = $d[1];

                $employee = $this->validateEmployee($id);
                $narration = $this->validateNarration($id, $type, $narration_id);
                $salary = $this->validateSalary($id);
                array_push($arr, ["id" => $id, "value" => $value, "employee" => $employee, "narration" => $narration, "salary" => $salary]);
            }

            $responseBody = $this->responseBody(true, "Import Salary Data", "validate", $arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Import Salary Data", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function validateEmployee($id)
    {

        if (Employee::find($id)) {
            return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
        }
        return '<div style="text-align:center;"><i class="fa fa-times text-danger" aria-hidden="true"></i></div>';
    }


    private function validateNarration($id, $type, $narration_id)
    {

        $global_setting = $this->getGlobalSetiings();
        if ($global_setting) {


            $salary =  SalaryData::where([['employee_id', '=', $id], ['salary_month', '=', $global_setting->current_payroll_month], ['salary_year', '=', $global_setting->current_payroll_year]])->first();
            if ($salary) {
                if ($type == 0) {
                    if ($salary->earn_trans_id_01 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_02 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_03 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_04 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_05 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_06 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_07 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_08 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_09 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->earn_trans_id_10 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else {
                        return '<div style="text-align:center;"><i class="fa fa-times text-danger" aria-hidden="true"></i></div>';
                    }
                } else if ($type == 1) {
                    if ($salary->deduct_trans_id_01 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_02 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_03 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_04 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_05 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_06 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_07 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_08 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_09 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else if ($salary->deduct_trans_id_10 == $narration_id) {
                        return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
                    } else {
                        return '<div style="text-align:center;"><i class="fa fa-times text-danger" aria-hidden="true"></i></div>';
                    }
                }
            } else {
                return '<div style="text-align:center;"><i class="fa fa-times text-danger" aria-hidden="true"></i></div>';
            }
        }
    }


    private function validateSalary($id)
    {
        $global_setting = $this->getGlobalSetiings();
        if ($global_setting) {
            $salary =  SalaryData::where([['employee_id', '=', $id], ['salary_month', '=',  $global_setting->current_payroll_month], ['salary_year', '=', $global_setting->current_payroll_year]])->first();
            if ($salary) {
                return '<div style="text-align:center;"><i class="fa fa-check text-success" aria-hidden="true"></i></div>';
            }
        }
        return '<div style="text-align:center;"><i class="fa fa-times text-danger" aria-hidden="true"></i></div>';
    }



    private function getGlobalSetiings()
    {
        return GlobalSettings::find(1);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
