<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\OtherEarningDeduction;
use Modules\Hr\Entities\TransactionItem;

class OtherEarningDeductionController extends Controller
{
    //


    public function narations($type)
    {
        try {
            //$transaction_items = TransactionItem::where('type', '=', 1)->get();
            $transaction_items = TransactionItem::where('type','=',$type)->where('status', '=', 1)->get();
            $collection = [];
            for ($i = 0; $i < count($transaction_items); $i++) {
                array_push($collection, ["img" => "/images/diduction.png", "id" => $transaction_items[$i]->item_id, "value" => $transaction_items[$i]->narration]);
            }
            $responseBody = $this->responseBody(true, "TransactionItem", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItem", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allAllowance(){
        try {
            $categories = OtherEarningDeduction::all();
            $responseBody = $this->responseBody(true, "Allowance", "all", $categories);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Allowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function save(Request $request)
    {
        try {
            $other_earning_deduction = new OtherEarningDeduction();
            $other_earning_deduction->type = $request->get('selcType');
            $other_earning_deduction->title = $request->get('txtTitle');
            $other_earning_deduction->epf = $request->get('epf');
            $other_earning_deduction->item_id = $request->get('selcNaration');
            $other_earning_deduction->calcualte = $request->get('selcCalculate');
            $other_earning_deduction->formula = $request->get('txtFormula');
            $save = $other_earning_deduction->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "Allowance", "saved", null);
            }else{
                $responseBody = $this->responseBody(true, "Allowance", "error", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Allowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request,$id){
        try {
            $other_earning_deduction = OtherEarningDeduction::find($id);
            $other_earning_deduction->type = $request->get('selcType');
            $other_earning_deduction->title = $request->get('txtTitle');
            $other_earning_deduction->epf = $request->get('epf');
            $other_earning_deduction->item_id = $request->get('selcNaration');
            $other_earning_deduction->calcualte = $request->get('selcCalculate');
            $other_earning_deduction->formula = $request->get('txtFormula');
            $save = $other_earning_deduction->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "Allowance", "updated", null);
            }else{
                $responseBody = $this->responseBody(true, "Allowance", "error", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Allowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function allowance($id){
        try {
            $allowance = OtherEarningDeduction::find($id);
            $responseBody = $this->responseBody(true, "Allowance", "all", $allowance);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Allowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function delete($id){

        try {

            $allowance = OtherEarningDeduction::find($id);
            $delete = $allowance->delete();

            if ($delete) {
                $responseBody = $this->responseBody(true, "Allowance", "deleted", $allowance);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Allowance", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
