<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeSalary;

class SalaryController extends Controller
{
    //

    public function allEmployeeNameAndID()
    {

        try {
            $employees = Employee::all();

            $employee_id_arr = [];
            $employee_name_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_id_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
                array_push($employee_name_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", ["ID" => $employee_id_arr, "Name" => $employee_name_arr]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function employee($id)
    {

        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function save(Request $request)
    {

        try {
            $employee_id = $request->get('employee_id');
            $date = $request->get('dteDate');
            $salary =  $request->get('txtSalary');
            $remark = $request->get('remark');

            if (!$this->isActiveSalaryStatus($employee_id)) {
                $employee_salary = new EmployeeSalary();
                $employee_salary->employee_id = $employee_id;
                $employee_salary->salary = $salary;
                $employee_salary->remark = $remark;
                $employee_salary->tran_date = $date;
                $employee_salary->status = true;
                $save = $employee_salary->save();
                if ($save) {
                    $responseBody = $this->responseBody(true, "Salary", "saved", null);
                }
            } else {
                $responseBody = $this->responseBody(false, "Salary", "Activated", $employee_id);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Salary", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function isActiveSalaryStatus($employee_id)
    {
        $employee_salary = EmployeeSalary::where('employee_id', '=', $employee_id)->where('status', '=', true)->first();
        if ($employee_salary) {
            return true;
        }
        return false;
    }




    public function allSalary()
    {

        try {
            $query = "SELECT *FROM hr_employee_salary INNER JOIN hr_employees ON hr_employee_salary.employee_id = hr_employees.employee_id
            ORDER BY convert(hr_employees.employee_id, decimal) ASC";
            //$query = Auth::user()->categoryRestrictionQuery($query);
            $salaries = DB::select($query);
            for ($i = 0; $i < count($salaries); $i++) {
                $employee =  Employee::find($salaries[$i]->employee_id);
                if ($employee) {
                    $salaries[$i]->name = $employee->name_withinitial;
                }
            }
            $responseBody = $this->responseBody(true, "Salary", "all", $salaries);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Salary", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function employeeSalary($id)
    {
        try {
            $salary = EmployeeSalary::find($id);
            $employee = Employee::find($salary->employee_id);
            if ($employee) {
                $salary->employee_name = $employee->name_withinitial;
                $salary->employee_address = $employee->address;
                $salary->employee_img = $employee->photo_parth;
            }
            $responseBody = $this->responseBody(true, "Salary", "all", $salary);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Salary", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {

        try {
            $employee_id = $request->get('employee_id');
            $date = $request->get('dteDate');
            $salary =  $request->get('txtSalary');
            $remark = $request->get('remark');

            $employee_salary = EmployeeSalary::find($id);
            $employee_salary->employee_id = $employee_id;
            $employee_salary->tran_date = $date;
            $employee_salary->salary = $salary;
            $employee_salary->remark = $remark;
            $update = $employee_salary->save();

            if ($update) {
                $responseBody = $this->responseBody(true, "Salary", "updated", $employee_salary);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Salary", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function delete($id)
    {
        try {

            $employee_salary = EmployeeSalary::find($id);
            $delete = $employee_salary->delete();

            if ($delete) {
                $responseBody = $this->responseBody(true, "Salary", "deleted", $employee_salary);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Salary", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function disable(Request $request, $id)
    {

        try {
            $status = $request->get("status");
            $employee_salary = EmployeeSalary::find($id);
            $employee_salary->status = $status;
            $disable = $employee_salary->save();

            if ($disable) {
                $responseBody = $this->responseBody(true, "Salary", "updated", $employee_salary);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Salary", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
