var employee_id = '';


$(document).ready(function () {
  $('#myTable').DataTable({
    columnDefs: [
      { width: 50, targets: 1 },
      { width: 50, targets: 2 },
      { width: 50, targets: 3 }
    ],
  });
  allEmployee();



  $('#attachmentAddModal').on('hidden.bs.modal', function () {
    loadAttachment();
  })


});


function openModal() {

  $('#attachmentAddModal').modal('toggle');

}



function allEmployee() {

  $.ajax({
    type: "GET",
    url: "/hr/attachment/allEmployee",
    processData: false,
    contentType: false,
    cache: false,
    timeout: 800000,
    beforeSend: function () {

    },
    success: function (response) {
      console.log(response);
      if (response.data.success) {

        $('#auto-comp1').setData(response.data.result);
        //autocomplete(document.getElementById('txtAutoComplete'), response.data.result);
      } else {

      }


    },
    error: function (error) {
      console.log(error);

    },
    complete: function () {

    }



  });

}




function getSelectedEmployee(employee_id) {

  $.ajax({
    type: "GET",
    url: "/hr/attachment/allEmployee/" + employee_id,
    processData: false,
    contentType: false,
    cache: false,
    timeout: 800000,
    beforeSend: function () {

    },
    success: function (response) {
      console.log(response);
      if (response.data.success) {
        var employee = response.data.result;
        setEmployeeData(employee);
      } else {

      }

    },
    error: function (error) {
      console.log(error);

    },
    complete: function () {

    }



  });

}




function setEmployeeData(employee) {

  $('#txtEmployeeAddress').text(employee.address);
  $('#imgEmployee').attr("src", employee.photo_parth);
}


/*function employee(employee) {
  var employee_name = employee.split('#')[0];
  employee_id = employee.split('#')[1];
  getSelectedEmployee(employee_id);
  return employee_name;
}*/



function setEmployeeID(employee_id) {
  getSelectedEmployee(employee_id);
  $('#employee_id').val(employee_id);
  loadAttachment();
}



function loadAttachment() {
  //resetAttachment();

  $.ajax({
    type: "GET",
    url: "/hr/attachment/allFiles/" + $('#employee_id').val(),
    processData: false,
    contentType: false,
    cache: false,
    timeout: 800000,
    beforeSend: function () {

    },
    success: function (response) {
      console.log(response);
      if (response.data.success) {
        var data = [];
        for (i = 0; i < response.data.result.length; i++) {
          var title = response.data.result[i]['file_path'];
          var id = response.data.result[i]['id'];
          var file = "'" + title + "'";
          var string_id = "'" + id + "'";
          data.push({
            "thTitle": title,
            "thView": '<button class="btn btn-success" onclick="viewAttachment(' + file + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
            "thDownload": '<button class="btn btn-primary" onclick="downloadAttachment(' + file + ')"><i class="fa fa-download" aria-hidden="true"></i></button>',
            "thDelete": '<button class="btn btn-danger" onclick="attachmentDelete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
          });
        }

        $('#myTable').DataTable({
          destroy: true,
          responsive: true,
          "order": [],
          "data": data,
          "columns": [
            { "data": "thTitle" },
            { "data": "thView" },
            { "data": "thDownload" },
            { "data": "thDelete" },
          ],
        });
      } else {

      }

    },
    error: function (error) {
      console.log(error);

    },
    complete: function () {

    }
  });

}


/**
* resetAttachment
* This function is used to reset form.
*/
function resetAttachment() {
  $('#myAwesomeDropzone').trigger("reset");
  $("#imgEmployee").attr("src", "/images/employee.jpg");
  $("#txtAutoComplete").text('');
  $("#txtEmployeeAddress").text('');
  Dropzone.forElement('#myAwesomeDropzone').removeAllFiles(true);
}



function viewAttachment(file) {
  window.open('/employee/' + file);

}


function downloadAttachment(file) {

  var link = document.createElement("a");
  link.download = file;
  link.href = "/employee/" + file;
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
  delete link;

}

function attachmentDelete(attachment_id) {

  $.ajax({
    type: "GET",
    url: "/hr/attachment/delete/" + attachment_id,
    processData: false,
    contentType: false,
    cache: false,
    timeout: 800000,
    beforeSend: function () {

    },
    success: function (response) {
      console.log(response);
      if (response.data.success) {
        showSuccessMessage("Attachment has been deleted successfully...");
        loadAttachment();
      } else {
        showErrorMessage();
      }

    },
    error: function (error) {
      console.log(error);

    },
    complete: function () {

    }
  });
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
  toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
  toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
  toastr.error('Something went wrong');
}



function autoCompleteOnChange(){
  var employee_id = $('#auto-comp1').optionID();
  setEmployeeID(employee_id);
}


function autoCompleteSelectedOption(parent, args) {
  
}




