var row_id = null;
var selected_div = null;
var att_TimeTable = null;
var IS_ROSTER = false;
$(document).ready(function () {

    att_TimeTable = $('#att_timeTable').DataTable({
        //"scrollX": true,
        "pageLength": 50,
        "order": [],
        "columns": [
            { "data": "id" },
            { "data": "date" },
            { "data": "schedule_in" },
            { "data": "schedule_out" },
            { "data": "actual_in" },
            { "data": "actual_out" },
            { "data": "remark" },
            { "data": "actual_update", className: "edit" },
        ],
        columnDefs: [
            { width: 10, targets: 0 },
            { width: 50, targets: 1 },
            { width: 100, targets: 2 },
            { width: 100, targets: 3 },
            { width: 100, targets: 4 },
            { width: 100, targets: 5 },
            { width: 20, targets: 7 },
            {
                "targets": '_all',
                "createdCell": function (td, cellData, rowData, row, col) {
                    $(td).css('padding', '0px')
                }
            },
        ],
        "drawCallback": function (settings) {

        }



    });


    var datepicker = $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    datepicker.bind("change", function () {
        $('#tblRawData').empty();
        var employee_id = $('#txtEmployeeID').optionID();
        var startDate = new Date($('#txtDateFrom').val()).toISOString().slice(0, 10);
        var endDate = new Date($('#txtDateTo').val()).toISOString().slice(0, 10);
        loadAttendance(employee_id, startDate, endDate);
    });

    att_TimeTable.column(0).visible(false);
    att_TimeTable.column(6).visible(false);


    $('#att_timeTable tbody').on('click', 'tr', function () {

        if (edit_permission == 1) {
            if ($(this).hasClass('selected')) {
                //$(this).removeClass('selected');
            }
            else {
                att_TimeTable.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                $('#tblRawData').empty();

            }

            if (selected_div != null) {
                selected_div.innerHTML = "";
            }


            var rowData = att_TimeTable.row(this).data();
            var schedule_in = rowData.date;
            var attendance_id = $('#txtAttendanceID').text();
            var date = schedule_in.split(" ")[0];
            loadRawData(attendance_id, date);

            att_TimeTable.column(6).visible(true);

            row_id = rowData.id;
            var col = document.getElementById('btn_update_div_' + row_id);
            var update_btn = document.createElement('BUTTON');
            update_btn.setAttribute("class", "btn btn-success");
            update_btn.innerText = 'Update';
            update_btn.setAttribute("onclick", "update_intime_outtime('" + row_id + "')");
            col.innerHTML = "";
            col.append(update_btn);
            $('#txtInTime_' + row_id).css("color", "red");
            $('#txtOutTime_' + row_id).css("color", "red");
            selected_div = document.getElementById('btn_update_div_' + row_id);




        }

    });

    loadEmployee_ID();

});







/**
* loadEmployee_ID
* This function is used to load allemplyee id 
*/
function loadEmployee_ID() {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceReportEdit/allEmployeeId',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#txtEmployeeID").setData(response.data.result);


            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* loadEmployee
* This function is used to load allemplyee details
*/
function loadEmployee(id) {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceReportEdit/employee/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var employee = response.data.result;
                $("#txtAttendanceID").text(employee.attendance_id);
                $("#txtEmployeeName").val(employee.name_withinitial);
            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





/**
* loadAttendance att_time
* This function is used to load employee attendance
*/
function loadAttendance(id, startDate, endDate) {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceReportEdit/employeeAttendance/' + id + '/' + startDate + '/' + endDate,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                appendTableRow(result);
                $('.row_btn').hide();
            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



function autoCompleteSelectedOption(input, data) {
    loadEmployee(data.id);
    $('#tblRawData').empty();
    var startDate = new Date($('#txtDateFrom').val()).toISOString().slice(0, 10);
    var endDate = new Date($('#txtDateTo').val()).toISOString().slice(0, 10);
    loadAttendance(data.id, startDate, endDate);

}



function appendTableRow(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        if (result[i]['doctor_name'] != 'unspecified') {

            var id = result[i]['att_id'];
            var schedule_id = result[i]['schedule_id'];
            var date = result[i]['att_date'] + " " + result[i].day;
            var attendance_id = result[i]['attendance_id'];
            var schedule_intime = result[i]['shift_start_time'];
            var schedule_outtime = result[i]['shift_end_time'];
            var intime = result[i]['att_InTime'];
            var outtime = result[i]['att_OutTime'];
            var remark = result[i]['remark'];
            var original_intime = result[i]['att_original_InTime'];
            var original_outtime = result[i]['att_original_OutTime'];
            var string_id = "'" + id + "'";

            if (intime == null) {
                intime = '';
            }

            if (outtime == null) {
                outtime = '';
            }

            if (remark == null) {
                remark = '';
            }


            var schedule_date = "'" + date.split(' ')[0] + "'";
            data.push({
                "id": id,
                "date": date,
                "schedule_in": '<input data-id="'+schedule_id+'" type="text" autocomplete="off" id="txt_in_' + id + '" value="' + schedule_intime + '"  class="form-control border-0" style="width:100%; margin:0px;font-size: 11px;">',
                "schedule_out": '<input data-id="'+schedule_id+'" type="text" autocomplete="off" id="txt_out_' + id + '" value="' + schedule_outtime + '"  class="form-control border-0" style="width:100%; margin:0px;font-size: 11px;" onchange="changeScheduleOut(this)" onclick="checkRoster(' + schedule_date + ')">',
                "actual_in": '<input type="text" autocomplete="off" id="txtInTime_' + id + '"  value="' + intime + '" class="form-control border-0" style="width:100%; margin:0px;font-size: 11px;" onclick="checkRoster(' + schedule_date + ')">',
                "actual_out": '<input type="text" autocomplete="off" id="txtOutTime_' + id + '"  value="' + outtime + '" class="form-control border-0" style="width:100%; margin:0px;font-size: 11px;" onclick="checkRoster(' + schedule_date + ')">',
                "remark": '<input type="text" autocomplete="off" id="txtRemark_' + id + '" value="' + remark + '" class="form-control border-0" style="width:100%; margin:0px;font-size: 11px;">',
                "actual_update": '<div name="btn_update_div" id="btn_update_div_' + id + '"></div>',
                //"actual_original_in": original_intime,
                //"actual_original_out": original_outtime,
            });


        }


    }



    var table = $('#att_timeTable').DataTable();
    table.clear();
    table.rows.add(data).draw();




}






/**
* loadRawData 
* This function is used to load attendance raw data
*/
function loadRawData(id, date) {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceReportEdit/attendanceRawData/' + id + '/' + date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                $('#tblRawData').empty();
                for (i = 0; i < result.length; i++) {
                    var arg_v = "'" + result[i].attendance + "'";
                    var row = '<tr><td>';
                    row += '<div class="row">';
                    row += '<div class="col-md-7">' + result[i].attendance + '</div>';
                    row += '<div class="col-md-2"><button class="btn btn-primary" style="max-height:25px" onclick="setIntime(' + arg_v + ')">In</button></div>';
                    row += '<div class="col-md-2"><button class="btn btn-secondary" style="max-height:25px" onclick="setOuttime(' + arg_v + ')">Out</button></div>';
                    row += '</div></td></tr>';
                    $('#tblRawData').append(row);
                }
            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });

}








function update_intime_outtime(id) {


    /*if (!checkFormat($('#txtInTime_' + id))) {
        return;
    }
    if (!checkFormat($('#txtOutTime_' + id))) {
        return;
    }*/

    //alert($('#txt_out_' + id).val());

    if (IS_ROSTER) {

        $.ajax({
            type: 'PUT',
            url: '/hr/attendanceReportEdit/updateInOut/' + id,
            data: {
                _token: $('input[name=_token]').val(),
                "schedule_id":$('#txt_in_' + id).attr('data-id'),
                "schedule_intime": $('#txt_in_' + id).val(),
                "schedule_outtime": $('#txt_out_' + id).val(),
                "intime": $('#txtInTime_' + id).val(),
                "outtime": $('#txtOutTime_' + id).val(),
                "remark": $('#txtRemark_' + id).val(),
            },
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);

                if (response.data.success) {
                    showSuccessMessage("Attendance InTime has been updated successfully...");
                    var col = document.getElementById('btn_update_div_' + id);
                    col.innerHTML = '';
                    $('#txtInTime_' + id).css("color", "black");
                    $('#txtOutTime_' + id).css("color", "black");
                    if (att_TimeTable != null) {
                        att_TimeTable.column(6).visible(false);
                    }

                } else {
                    showErrorMessage();
                }

            },
            error: function (error) {
                console.log(error.message);
                showErrorMessage();
            },
            complete: function () {

            }

        });
    } else {
        createDriverRoster(id);
    }
}


function setIntime(time) {
    if (row_id != null) {
        $('#txtInTime_' + row_id).val(time);
    } else {
        showWarningMessage("Please select Actual InTime or OutTime from table...!");
    }

}


function setOuttime(time) {
    if (row_id != null) {
        $('#txtOutTime_' + row_id).val(time);
    } else {
        showWarningMessage("Please select Actual InTime or OutTime from table...!");
    }
}





function process() {
    var employee_id = $('#txtEmployeeID').optionID();
    var startDate = new Date($('#txtDateFrom').val()).toISOString().slice(0, 10);
    var endDate = new Date($('#txtDateTo').val()).toISOString().slice(0, 10);

    $.ajax({
        type: "GET",
        url: '/hr/attProcess/' + employee_id + '/' + startDate + '/' + endDate,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            $('#btnProcess').prop("disabled", true);
            document.getElementById('btnProcess').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            showSuccessMessage('Attendance Process completed successfully...!');

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('#btnProcess').text('Process');
            $('#btnProcess').prop("disabled", false);
        }

    });
}


function changeScheduleOut(event){
    $(event).attr("value",$(event).val());
}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}