
var setting_array = {
    "category": null,
    "site": null,
    "department": null,
    "section": null,
    "subsection": null,
    "company": null,
    "team": null,
    "employee": null,
};

var REPORT_ID = 0;

$(document).ready(function () {
    allSettings();
    $('#selcCategory').prop("disabled", true);
    $('#selcSite').prop("disabled", true);
    $('#selcDepartment').prop("disabled", true);
    $('#selcSection').prop("disabled", true);
    $('#selcSubsection').prop("disabled", true);
    $('#selcCompany').prop("disabled", true);
    $('#selcTeam').prop("disabled", true);
    $('#employee-autocomplete').prop("disabled", true);

    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('#checkCategorySearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcCategory').prop("disabled", false);
            setting_array.category = $('#selcCategory').val();
        } else {
            $('#selcCategory').prop("disabled", true);
            setting_array.category = null;
        }
        //switch_settings('checkCategorySearch');
        console.log(setting_array);
    });



    $('#checkSiteSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSite').prop("disabled", false);
            setting_array.site = $('#selcSite').val();
        } else {
            $('#selcSite').prop("disabled", true);
            setting_array.site = null;
        }
        //switch_settings('checkSiteSearch');
    });


    $('#checkDepartmentSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcDepartment').prop("disabled", false);
            setting_array.department = $('#selcDepartment').val();
        } else {
            $('#selcDepartment').prop("disabled", true);
            setting_array.department = null;
        }
        //switch_settings('checkDepartmentSearch');
    });


    $('#checkSectionSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSection').prop("disabled", false);
            var value = $('#selcSection').val();
            setting_array.section = $('#selcSection').val();
            allSubsection(value);
        } else {
            $('#selcSection').prop("disabled", true);
            setting_array.section = null;
            setting_array.subsection = null;
            $('#selcSubsection').empty();
            $('#checkSubsectionSearch').prop('checked', false);
        }
        //switch_settings('checkSectionSearch');
    });


    $('#checkSubsectionSearch').change(function () {
        var sectionbool = $('#checkSectionSearch').is(":checked");
        if (!sectionbool) {
            $('#checkSubsectionSearch').prop('checked', false);
            showWarningMessage('Please select section');
            return;
        }
        var subsectionbool = $(this).is(":checked");
        if (subsectionbool) {
            $('#selcSubsection').prop("disabled", false);
            setting_array.subsection = $('#selcSubsection').val();
        } else {
            $('#selcSubsection').prop("disabled", true);
            setting_array.subsection = null;
        }
        //switch_settings('checkSubsectionSearch');
    });


    $('#checkCompanySearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcCompany').prop("disabled", false);
            setting_array.company = $('#selcCompany').val();
        } else {
            $('#selcCompany').prop("disabled", true);
            setting_array.company = null;
        }
        //switch_settings('checkCompanySearch');
    });


    $('#checkTeamSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcTeam').prop("disabled", false);
            setting_array.team = $('#selcTeam').val();
        } else {
            $('#selcTeam').prop("disabled", true);
            setting_array.team = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkEmployeeSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#employee-autocomplete').prop("disabled", false);
            setting_array.employee = $('#employee-autocomplete').optionID();
        } else {
            $('#employee-autocomplete').prop("disabled", true);
            setting_array.employee = null;
        }
        //switch_settings('checkEmployeeSearch');
    });

    $('#selcCategory').change(function () {
        setting_array.category = $('#selcCategory').val();
    });

    $('#selcSite').change(function () {
        setting_array.site = $('#selcSite').val();
    });

    $('#selcDepartment').change(function () {
        setting_array.department = $('#selcDepartment').val();
    });

    $('#selcSection').change(function () {
        var value = $('#selcSection').val();
        setting_array.section = value;
        allSubsection(value);
    });

    $('#selcSubsection').change(function () {
        setting_array.subsection = $('#selcSubsection').val();
    });

    $('#selcCompany').change(function () {
        setting_array.company = $('#selcCompany').val();
    });

    $('#selcTeam').change(function () {
        setting_array.team = $('#selcTeam').val();
    });

    $('#employee-autocomplete').change(function () {
        setting_array.employee = $('#employee-autocomplete').optionID();
    });

    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        if (REPORT_ID == 1) {
            showDate('NON_DATE');
        } else if (REPORT_ID == 2) {
            showDate('NON_DATE');
        } else if (REPORT_ID == 3) {
            showDate('COUPLE_DATE');
        } else if (REPORT_ID == 4) {
            showDate('COUPLE_DATE');
        }
    });

});





function allSettings() {

    $.ajax({
        type: "GET",
        url: "/hr/employeeReport/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOption("selcCategory", settings.category);
                appendOption("selcSite", settings.site);
                appendOption("selcDepartment", settings.department);
                appendOption("selcSection", settings.section);
                appendOption("selcCompany", settings.company);
                appendOption("selcTeam", settings.team);
                $('#employee-autocomplete').setData(settings.employee);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}





function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}







function allSubsection(section_id) {


    $.ajax({
        type: "GET",
        url: "/hr/employeeReport/subSection/" + section_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                appendOption("selcSubsection", response.data.result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function settings() {

    return "category=" + setting_array.category + "&"
        + "site=" + setting_array.site + "&"
        + "department=" + setting_array.department + "&"
        + "section=" + setting_array.section + "&"
        + "subsection=" + setting_array.subsection + "&"
        + "company=" + setting_array.company + "&"
        + "employee=" + setting_array.employee;
}


function createReport(flag) {

    if (setting_array.category == null && setting_array.site == null && setting_array.department == null && setting_array.section == null && setting_array.subsection == null && setting_array.company == null && setting_array.team == null && setting_array.employee == null) {
        showWarningMessage("Please select setting");
        return;
    }

    var employee_id = $('#employee-autocomplete').optionID();
    if (setting_array.employee != null && employee_id == "") {
        showWarningMessage("Please select employee");
        return;
    }


    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report title");
        return;
    }



    if (REPORT_ID == 1) {

        $.ajax({
            type: "GET",
            url: "/hr/employeeReport/detailReport/" + JSON.stringify(setting_array),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                allEmployeeDetailsReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    } else if (REPORT_ID == 2) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeReport/basicSalaryReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                basicSalaryReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 3) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeReport/resignEmployeeDetailsReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                resignEmployeeDetailsReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 4) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeReport/leaveStatusReport/" + JSON.stringify(setting_array),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                leaveStatusReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    }
}











function allEmployeeDetailsReport(result, flag) {

    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            /*logo: {
                path: '/images/logo.png',
                width: 200,
                height: 30,
                alignment: 'left',
            },*/
            content: [

                {
                    table: {
                        widths: ['*', '*', '*'],
                        headerRows: 1,
                        body: [
                            [{ text: '', border: [false, false, false, false] }, { text: 'Riococo Lanka Pvt Ltd', fontSize: 5, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 5, bold: true, alignment: 'right', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 6, border: [false, false, false, false] }, { text: "\n", fontSize: 6, bold: true, alignment: 'center', border: [false, false, false, false] }, { text: '\n', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                            [{ text: 'June 2021', fontSize: 4, border: [false, false, false, false] }, { text: "EMPLOYEE'S DETAIL REPORT", fontSize: 6, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                }
            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 30, 80, 80, 30, 40, 30, 30, 50, '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'],
                headerRows: 1,
                body: allEmployeeDetailsReportBody(result),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A3');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }


}




function allEmployeeDetailsReportBody(result) {

    var font_size = 3;
    var body = [];
    body.push([
        { text: 'Employee ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'EPF No', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Name', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Address', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Date Of Birth', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Gender', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Designation', fontSize: font_size, border: [true, true, true, true] },
        { text: 'NIC', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Date Of Joined', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Civil Status', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Fixed Phone NO', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Attendance ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Employee Status', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Category', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Site', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Department', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Team', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Supervisior', fontSize: font_size, border: [true, true, true, true] },
        { text: 'GS Division', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Police Divition', fontSize: font_size, border: [true, true, true, true] },
        { text: 'MOH', fontSize: font_size, border: [true, true, true, true] },

    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].epf_no, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].address, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].birthday, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].gender, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].designation, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].nic, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].date_join, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].civilstatus, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].fixed_mobile, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].attendance_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employeestatus, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].category, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].site, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].department, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].team_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].supervisor, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].division, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].police, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].moh, fontSize: font_size, border: [false, false, false, true] },

        ]);
    }
    return body;
}



function basicSalaryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Basicsalary report', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

                {
                    table: {
                        widths: [30, 100, 98, 35, 35, 35, 35, 35, 30],
                        headerRows: 1,
                        body: [
                            [
                                { rowSpan: 2, text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { rowSpan: 2, text: 'Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { rowSpan: 2, text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { colSpan: 3, text: 'Basic', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }, '', '',
                                { colSpan: 2, text: 'Allowance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }, '',
                                { rowSpan: 2, text: 'Total Day Salary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }
                            ],
                            [
                                '',
                                '',
                                '',
                                { text: 'Basicsalary', fontSize: 6, rowspan: 2, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'BR1', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'BR2', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Travalling Allowance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Production Incentive', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Total Day Salary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }
                            ],



                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [

        {
            table: {
                widths: [30, 100, 98, 35, 35, 35, 35, 35, 30],
                headerRows: 0,
                body: basicSalaryReportBody(result.body),

            },
            /*layout: {
                hLineStyle: function (i, node) {
                    return { dash: { length: 1, space: 2 } };
                },
                hLineWidth: function (i, node) {
                    return 0.2;
                },



            },*/
            margin: [0, 0],
        },

    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function basicSalaryReportBody(result) {
    var font_size = 6;
    var body = [];
    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].br1, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].br2, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].travalling_allowance, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].production_incentive, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].total_day_salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}



function resignEmployeeDetailsReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Resign Employee Report', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, 30, 110, 140, 40, 110, 110, 110, 40, 40, 40, 40, 40, 40, '*'],
                headerRows: 1,
                body:
                    resignEmployeeDetailsReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A3');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function resignEmployeeDetailsReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'EPF No', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Address', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Mobile No', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Department', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Section', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'DOB', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Gender', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'NIC', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Register Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Resign Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Service', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Basicsalary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].epf_no, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].address, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].mobile, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].department, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].section, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].dob, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].gender, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].nic, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].date_join, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].resign_date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].service, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}



function attendanceSummryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Attendance Data - Summary ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, 130, 50, 50, 50, 50, '*'],
                headerRows: 1,
                body: attendanceSummryReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function attendanceSummryReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Working Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Poya OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Signature', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].worked_day, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].poya_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: '', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}





function dailyInvalidReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Invalied Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, '*', '*', 'auto', 70, 70],
                headerRows: 1,
                body: dailyInvalidReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyInvalidReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Shift', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'In Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].shift, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].in_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].out_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}





function leaveStatusReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Leave Status Report', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: ['*', '*', '*', '*', '*'],
                headerRows: 1,
                body: leaveStatusReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function leaveStatusReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Leave Type', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Allocated', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Used', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Unlimited', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Balance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].leave_type, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].allocated, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].used, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].unlimited, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].balance, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}



















function daysInMonth(month, year) {
    return new Date(year, month, 0).getDate();
}

function switch_settings(setting) {

    if (setting != 'checkCategorySearch') {
        $('#checkCategorySearch').prop('checked', false);
        $('#selcCategory').prop("disabled", true);
        setting_array.category = null;
    }
    if (setting != 'checkSiteSearch') {
        $('#checkSiteSearch').prop('checked', false);
        $('#selcSite').prop("disabled", true);
        setting_array.site = null;
    }
    if (setting != 'checkDepartmentSearch') {
        $('#checkDepartmentSearch').prop('checked', false);
        $('#selcDepartment').prop("disabled", true);
        setting_array.department = null;
    }
    if (setting != 'checkSectionSearch') {
        $('#checkSectionSearch').prop('checked', false);
        $('#selcSection').prop("disabled", true);
        setting_array.section = null;
    }
    if (setting != 'checkSubsectionSearch') {
        $('#checkSubsectionSearch').prop('checked', false);
        $('#selcSubsection').prop("disabled", true);
        setting_array.subsection = null;
    }
    if (setting != 'checkCompanySearch') {
        $('#checkCompanySearch').prop('checked', false);
        $('#selcCompany').prop("disabled", true);
        setting_array.company = null;
    }
    if (setting != 'checkTeamSearch') {
        $('#checkTeamSearch').prop('checked', false);
        $('#selcTeam').prop("disabled", true);
        setting_array.team = null;
    }
    if (setting != 'checkEmployeeSearch') {
        $('#checkEmployeeSearch').prop('checked', false);
        $('#selcEmployee').prop("disabled", true);
        setting_array.employee = null;
    }
}


function showDate(args) {

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else if (args == 'COUPLE_DATE') {
        $('#startDate').show();
        $('#endDate').show();
    } else if (args == 'NON_DATE') {
        $('#startDate').hide();
        $('#endDate').hide();
    }
}



function _export() {
    createReport('EXPORT');
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
