
$(document).ready(function () {

    $('#tblEmployee').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name" },
            { "data": "category" },
            { "data": "site" },
            { "data": "department" },
            { "data": "section" },
            { "data": "subsection" },
            { "data": "set", className: "set" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 50, targets: 7 },
        ],
    });



    $('#tblEmployeeSchedule').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "employee_name" },
            { "data": "team" },
            { "data": "leader" },
            { "data": "remove", className: "remove" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 50, targets: 4 },
        ],
    });


    getAllEmployees();
    getAllTeams();
});



function getAllEmployees() {


    $.ajax({
        type: "GET",
        url: '/hr/teamEmployee/allEmployee',
        data: { "date": $('#txtDate').val() },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                appendTableRow_Employee(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}










function appendTableRow_Employee(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        emp_id = result[i]['employee_id'];
        var name = result[i]['name_withinitial'];
        var category = result[i]['category'];
        var site = result[i]['site'];
        var department = result[i]['department'];
        var section = result[i]['section'];
        var subsection = result[i]['subsection'];
        //var company = result[i]['company'];
        var string_id = "'" + emp_id + "'";


        data.push({
            "employee_id": emp_id,
            "name": name,
            "category": category,
            "site": site,
            "department": department,
            "section": section,
            "subsection": subsection,
            "set": '<button class="btn btn-primary" onclick="setTeam(' + string_id + ')">Set</button>',
        });
    }

    var table = $('#tblEmployee').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.set').visible(false);


    if (set_permission == 1) {
        table.columns('.set').visible(true);
    }



}






function getAllTeams() {

    $.ajax({
        type: "GET",
        url: "/hr/employeeTeam/allTeams",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var result = response.data.result;
                appendOption("cmbTeam", result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].team_id + '">' + result[i].team_name + '</option>');
    }
}




function setTeam(emp_id) {

    if($('#cmbTeam').val() == undefined){
        showWarningMessage('Please select team.');
        return;
    }

    if (isAssignedMmber(emp_id)) {
        showWarningMessage(emp_id + ' Employee Already assigned.');
        return;
    }
    var team_id = $('#cmbTeam').val();
    var _token = $("input[name='_token']").val();

    var data = new FormData();
    data.append('team_id', team_id);
    data.append('employee_id', emp_id);
    data.append('_token', _token);

    $.ajax({
        type: "POST",
        url: "/hr/team/setTeam",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Employee has been saved in team successfully...");
                getAllTeamMmbers(team_id);
                getAllEmployees();
                //resetLoan();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}







function getAllTeamMmbers(id) {
    $.ajax({
        type: "GET",
        url: "/hr/employeeTeam/allTeamMembers/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var result = response.data.result;
                appendTableRow_TeamMembers(result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}






function appendTableRow_TeamMembers(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var emp_team_id = result[i]['employee_team_id'];
        var team = result[i]['team_name'];
        var team_id = result[i]['team_id'];
        var leader = result[i]['leader'];
        var employee_id = result[i]['employee_id'];
        var employee_name = result[i]['name_withinitial'];
        var string_id = "'" + emp_team_id + "'";


        data.push({
            "employee_id": employee_id,
            "employee_name": employee_name,
            "team": team,
            "leader": leader,
            "remove": '<button class="btn btn-danger" onclick="removeTeam(' + string_id + ')">Remove</button>',
        });
    }

    var table = $('#tblEmployeeSchedule').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.remove').visible(false);


    if (remove_permission == 1) {
        table.columns('.remove').visible(true);
    }



}




$(document).ready(function () {

    $('#cmbTeam').on('change', function (event) {
        getAllTeamMmbers(event.target.value);
    });
});





function removeTeam(id) {
    $.ajax({
        type: 'DELETE',
        url: '/hr/employeeTeam/remove/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Employee has been deleted in team successfully...")
                getAllTeamMmbers($('#cmbTeam').val());
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



function isAssignedMmber(id) {

    var bool = false;
    $.ajax({
        type: "GET",
        url: "/hr/employeeTeam/isAssignedMmber/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                bool = response.data.result;
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

    return bool;
}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "000",
        2: "00",
        3: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}


function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}
