$(document).ready(function () {


    $('#myTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "leave_id" },
            { "data": "employee_name" },
            { "data": "from" },
            { "data": "to" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
            { "data": "confirm", className: "confirm" },
            { "data": "reject", className: "reject" }
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 30, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 },
            { width: 30, targets: 7 },
            { width: 30, targets: 8 },
        ],
    });

    getLeave(1);

});


function getLeave(page_id) {

    $.ajax({
        type: "GET",
        url: "/hr/leave/allLeave",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['leave_id'];
                    var employee_name = response.data.result[i]['employee_name'];
                    var from = response.data.result[i]['from'];
                    var to = response.data.result[i]['to'];
                    var string_id = "'" + id + "'";
                    data.push({
                        "leave_id": id,
                        "employee_name": employee_name,
                        "from": from,
                        "to": to,
                        "edit": '<button class="btn btn-primary mr-4 ml-2" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success mr-4" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
                        "confirm": '<button class="btn btn-success ml-3" onclick="confirmed(' + string_id + ')"><i class="fa fa-check" aria-hidden="true"></i></button>',
                        "reject": '<button class="btn btn-danger ml-3" onclick="reject(' + string_id + ')"><i class="fa fa-times" aria-hidden="true"></i></button>'
                    });
                }

                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();

                table.columns('.edit').visible(false);
                table.columns('.view').visible(false);
                table.columns('.delete').visible(false);
                table.columns('.confirm').visible(false);
                table.columns('.reject').visible(false);

                if (edit_permission == 1) {
                    table.columns('.edit').visible(true);
                }

                if (view_permission == 1) {
                    table.columns('.view').visible(true);
                }

                if (delete_permission == 1) {
                    table.columns('.delete').visible(true);
                }

                if (confirm_permission == 1) {
                    table.columns('.confirm').visible(true);
                }

                if (reject_permission == 1) {
                    table.columns('.reject').visible(true);
                }

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}

function edit(id) {
    location.href = "/hr/leave?" + id;
}


function view(id) {
    location.href = "/hr/leave?" + id + "&view";
}


function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/hr/leave/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Leave record has been deleted successfully...")
                getLeave(1);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}

/**
* confirm
* This function is used to confirm leave.
* @param data This is the paramter to ajax data
*/
function confirmed(id) {

    $.ajax({
        type: "POST",

        url: '/hr/leave/confirmed/' + id + "/" + user_id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Leave has been confirmed...");

            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}

/**
* confirm
* This function is used to confirm leave.
* @param data This is the paramter to ajax data
*/
function reject(id) {

    $.ajax({
        type: "POST",

        url: '/hr/leave/reject/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Leave has been rejected...");

            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}