const CARD_COUNT_PAGE = 4.0; //how many you want cards in one page, max 4 and minimum 1

function loadEmployee() {


    var param;
    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        param = sPageURL.split('&');
    }

    $.ajax({
        type: "GET",
        url: "/hr/print/employee/print/" + param,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                printPage(response.data.result);
            } else {

            }

        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {

        }

    });

}



function printPage(cardCollection) {

    var cardCount = cardCollection.length;
    var pageCount = getPageCount(cardCount);
    makePageEliment(cardCollection, pageCount, cardCount);
    setTimeout(function () {
        window.print();
    }, 1000);

}

function getPageCount(cardCount) {
    var count = Math.floor(cardCount / CARD_COUNT_PAGE);
    if (((cardCount / CARD_COUNT_PAGE) - count) > 0.0) {
        count++;
    }
    return count;
}


function makePageEliment(result, page_count, card_count) {

    var count = Math.floor(card_count / CARD_COUNT_PAGE);
    var skip_count = (page_count - count);
    var true_count = (page_count - skip_count);

    var content_count = 0;
    for (var i = 0; i < true_count; i++) {
        var page_content = '<div class="page">';
        for (var i2 = 0; i2 < CARD_COUNT_PAGE; i2++) {
            page_content += makeCardElement(result[content_count]);
            content_count++;
        }
        page_content += '</div>';
        $('.book').append(page_content);
    }

    var skip_card_count = (card_count % CARD_COUNT_PAGE);

    for (var i = 0; i < skip_count; i++) {
        var page_content = '<div class="page">';
        for (var i2 = 0; i2 < skip_card_count; i2++) {
            page_content += makeCardElement(result[(true_count * CARD_COUNT_PAGE) + i2]);
        }
        page_content += '</div>';
        $('.book').append(page_content);
    }
}


function makeCardElement(result) {
    var card = Card.newCard(result);
    return card;
}



