
allSettings();
var settings_name = "";


function allSettings() {

    $.ajax({
        type: "GET",
        url: "/hr/reportEmployeeList/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOption("selcCategory", settings.category);
                appendOption("selcSite", settings.site);
                appendOption("selcDepartment", settings.department);
                appendOption("selcSection", settings.section);
                appendOption("selcCompany", settings.company);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            $('#selcSection').trigger('change');
        }

    });
}





function appendOption(combobox, result) {

    $('#' + combobox).empty();
    //$('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}







$('#selcSection').change(function (event) {


    if (event.target.value == "") {
        return;
    }
    $.ajax({
        type: "GET",
        url: "/hr/salaryData/subSection/" + event.target.value,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                appendOption("selcSubsection", response.data.result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
});







function settings() {

    return "is_category=" + $('#checkCategorySearch').is(":checked") + ","
        + $('#selcCategory').val() + "&"
        + "is_site=" + $('#checkSiteSearch').is(":checked") + ","
        + $('#selcSite').val() + "&"
        + "is_department=" + $('#checkDepartmentSearch').is(":checked") + ","
        + $('#selcDepartment').val() + "&"
        + "is_section=" + $('#checkSectionSearch').is(":checked") + ","
        + $('#selcSection').val() + "&"
        + "is_subsection=" + $('#checkSubsectionSearch').is(":checked") + ","
        + $('#selcSubsection').val() + "&"
        + "is_company=" + $('#checkCompanySearch').is(":checked") + ","
        + $('#selcCompany').val();
}




function print() {
    window.open('/hr/employeeList_print?' + settings()+"&print");
}


function _export() {
    window.open('/hr/employeeList_print?' + settings()+"&export");
}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
