var imgBase64 = null;
var print_list = [];

$(document).ready(function () {

    drawImage('/images/employee.jpg');

    $('#printTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "print" },
            { "data": "employee_id" },
            { "data": "attendance_id" },
            { "data": "nic" },
            { "data": "name_withinitial" },
            { "data": "address" },
            { "data": "date_join" },
            { "data": "id_issue_date" },
            { "data": "id_expire_date" },
            { "data": "designation" },
            { "data": "photo_parth" },
            { "data": "subcontractor" },
            { "data": "edit", className: "edit" },
            { "data": "delete", className: "delete" },
        ],
        scrollCollapse: true,
        paging: false,

    });

    /**
    * datepicker
    * This is jquery foe datepicker .
    */
    $('input[name="dteDateOfJoined"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });


    /**
    * datepicker
    * This is jquery foe datepicker .
    */
    $('input[name="txtIDCardIssueDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false,
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });


    /**
    * datepicker
    * This is jquery foe datepicker .
    */
    $('input[name="txtIDCardExpireDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });

    $('#btnAction').click(function (event) {
        event.preventDefault();

        var action = $('#btnAction').text();
        if (action == 'Save') {

            var form = $('#printIdForm').get(0);
            var data = new FormData(form);
            data.append('imgBase64', imgBase64);
            save(data);

        } else if (action == 'Update') {

            var form = $('#printIdForm').get(0);
            var data = new FormData(form);
            var employee_id = $('#txtEmployeeID').val();
            data.append('imgBase64', imgBase64);
            update(data, employee_id);

        }
    });

    allEmployee();
    allDesignation();
});




function imageChooser() {

    var elem = document.getElementById('imgFile');
    if (elem && document.createEvent) {
        var evt = document.createEvent("MouseEvents");
        evt.initEvent("click", true, false);
        elem.dispatchEvent(evt);
    }

}



/**
    * imgTag
    * This function is used to set image to img tag.
    */
document.getElementById('imgFile').onchange = function (evt) {

    var img_url = URL.createObjectURL(evt.target.files[0]);
    var cnv = document.getElementById('canvas');
    var context = cnv.getContext('2d');
    context.clearRect(0, 0, cnv.width, cnv.height);
    var base_image = new Image();
    base_image.src = img_url;
    base_image.onerror = function () {
        this.src = '/images/employee.jpg'; // place your error.png image instead
    };

    base_image.onload = function () {
        context.drawImage(base_image, 0, 0, 300, 150);
    }
    imgBase64 = cnv.toDataURL();

}




///////////////////////////// Web Cam /////////////////////////////

function openWebCam() {

    if ($('#btnTakePhoto').text() == 'Take a photo') {
        stopWebCam();
        return;
    }
    $('#imgWebCam').hide();
    $('#videoTag').show();

    var video = document.querySelector("#videoElement");

    if (navigator.mediaDevices.getUserMedia) {
        navigator.mediaDevices.getUserMedia({ video: true })
            .then(function (stream) {
                $('#btnTakePhoto').text('Take a photo');
                video.srcObject = stream;
            })
            .catch(function (err0r) {
                console.log("Something went wrong!");
            });
    }
}



function stopWebCam() {

    takePhoto();
    var video = document.querySelector("#videoElement");
    var stream = video.srcObject;
    var tracks = stream.getTracks();
    console.log(tracks);

    for (var i = 0; i < tracks.length; i++) {
        var track = tracks[i];
        track.stop();
        $('#btnTakePhoto').text('Open Webcam');
    }


    video.srcObject = null;

}


function generateThumbnail() {

    var context = canvas.getContext('2d');
    context.drawImage(videoElement, 0, 0, 300, 150);
    drawingProgress();
}



function takePhoto() {
    generateThumbnail();
    var mycanvas = document.getElementById('canvas');
    imgBase64 = mycanvas.toDataURL();
    //console.log(imgBase64);
}


/////////////////////// End Webcam ////////////////////////


function drawImage(img_url) {
    var context = canvas.getContext('2d');
    context.clearRect(0, 0, canvas.width, canvas.height);
    var base_image = new Image();
    base_image.src = img_url;
    base_image.onerror = function () {
        this.src = '/images/employee.jpg'; // place your error.png image instead
    };

    base_image.onload = function () {
        context.drawImage(base_image, 0, 0, 300, 150);
    }

    drawingProgress();
}


function drawingProgress() {
    var progress = document.getElementById('progresImg');

    progress.style.width = 100 + "%";

    setTimeout(function () {
        progress.style.width = 0 + "%";
    }, 1000);
}



function allEmployee() {

    $.ajax({
        type: "GET",
        url: "/hr/print/allEmployee",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            var result = response.data.result;
            if (response.data.success) {
                loadTableResult(result);
            } else {
                console.log(result);
            }


        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

}



function loadTableResult(result) {

    var data = [];
    $.each(result, function (index, employee) {
        var string_id = "'" + employee['employee_id'] + "'";
        var print_status = employee['print_status'];
        var checkbox = '';
        var bool = false;
        if (print_status) {
            checkbox = 'checked';
            bool = true;
        }
        data.push({
            'print': '<input type="checkbox" class="checkbox form-control" id="' + employee['employee_id'] + '" name="chekPrintStatus" value="' + employee['employee_id'] + '" ' + checkbox + ' onchange="selectCard(' + string_id + ')">',
            'employee_id': employee['employee_id'],
            'attendance_id': employee['attendance_id'],
            'nic': employee['nic'],
            'name_withinitial': employee['name_withinitial'],
            'address': employee['address'],
            'date_join': employee['date_join'],
            'id_issue_date': employee['id_issue_date'],
            'id_expire_date': employee['id_expire_date'],
            'designation': employee['designation'],
            'photo_parth': '<img src="' + employee['photo_parth'] + '" class="img-thumbnail" alt="Cinque Terre">',
            'subcontractor': employee['subcontractor'],
            "edit": '<button type="button" class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
            "delete": '<button type="button" class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
        });


    });


    var table = $('#printTable').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.edit').visible(false);
    table.columns('.delete').visible(false);



    if (edit_permission == 1) {
        table.columns('.edit').visible(true);
    }


    if (delete_permission == 1) {
        table.columns('.delete').visible(true);
    }



}


function edit(employee_id) {

    loadEmployee(employee_id);

}



function _delete(employee_id) {
    $.ajax({
        type: 'DELETE',
        url: '/hr/print/employee/' + employee_id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Employee has been deleted successfully...")
                allEmployee();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function allDesignation() {
    $.ajax({
        type: "GET",
        url: "/hr/print/allDesignation",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var result = response.data.result;

            if (response.data.success) {
                appendSettings(result);
            } else {
                console.log(result);
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



/**
* appendSettings
* This function is used append option to combobox.
* @param collection This is the paramter to combobox elements item
*/
function appendSettings(result) {

    $.each(result, function (index, designation) {
        $('#selcDesignation').append('<option value="' + designation['designation_id'] + '">' + designation['designation'] + '</option>');
    });

}


/**
* loadEmployee
* This function used to load employee detailsa and settings, in update and view time
*/
function loadEmployee(employee_id) {


    $.ajax({
        type: "GET",
        url: "/hr/print/employee/" + employee_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var employee = response.data.result;

                var employee_id = employee['employee_id'];
                var name_withinitial = employee['name_withinitial'];
                var nic = employee['nic'];
                var address = employee['address'];
                var date_join = employee['date_join'];
                var photo_parth = employee['photo_parth'];
                var attendance_id = employee['attendance_id'];
                var designation = employee['designation'];
                var subcontractor = employee['subcontractor'];



                $('#txtEmployeeID').val(employee_id);
                $('#txtName').val(name_withinitial);
                $('#txtEmployeeAddress').val(address);
                $('#txtNic').val(nic);
                $('#dteDateOfJoined').val(date_join);
                $('#txtIDCardIssueDate').val(formatDate(new Date()));
                $('#txtIDCardExpireDate').val(formatDate(new Date()));
                drawImage(photo_parth);
                $("#txtAttendanceID").val(attendance_id);
                $("#txtSubContractor").val(subcontractor);
                $("#selcDesignation option").filter(function () {
                    return $(this).text() == designation;
                }).prop('selected', true);


                $('#btnAction').text('Update');
            }


        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {
            $('.nicescroll-cursors').hide().show(0);
        }

    });



}



function formatDate(date) {
    var d = new Date(date),
        month = '' + (d.getMonth() + 1),
        day = '' + d.getDate(),
        year = d.getFullYear();

    if (month.length < 2)
        month = '0' + month;
    if (day.length < 2)
        day = '0' + day;

    return [year, month, day].join('-');
}



function save(data) {
    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: '/hr/print',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var name = response.data.name;
                var message = response.data.message;
                if (name == "duplicate") {
                    showWarningMessage(message);
                    return;
                }

                $('#printIdForm').trigger("reset");
                showSuccessMessage("Employee has been saved successfully...");
                drawImage('/images/employee.jpg');
                imgBase64 = null;
                allEmployee();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}


function update(data, employee_id) {


    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: '/hr/print/update/' + employee_id,
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                $('#printIdForm').trigger("reset");
                $('#btnAction').text('Save');
                showSuccessMessage("Employee has been updated successfully...");
                drawImage('/images/employee.jpg');
                imgBase64 = null;
                allEmployee();

            } else {
                showErrorMessage();
            }



        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}




function makedPrint() {
    var makePrint = Array();
    $.each($("input[name='chekPrintStatus']:checked"), function () {
        makePrint.push($(this).val());
    });

    if (makePrint.length > 0) {
        var _token = $("input[name='_token']").val();
        $.ajax({
            type: "PUT",
            url: '/hr/print/makedPrint',
            data: { 'maked': makePrint },
            headers: { 'X-CSRF-TOKEN': _token },
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);
                if (response.data.success) {
                    print_list = [];
                    showSuccessMessage("IDCards has been printed successfully...");
                    allEmployee();
                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {
                //location.href = "/hr/employeeList";
            }

        });
    } else {
        showWarningMessage('There are no selected items...!');
    }
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}



function resetForm() {
    $('#printIdForm').trigger("reset");
    $('#btnAction').text('Save');
    drawImage('/images/employee.jpg');
    imgBase64 = null;
}


function printPreview() {

    /*var makePrint = [];
    $.each($("input[name='chekPrintStatus']:checked"), function () {
        makePrint.push($(this).val());
    });*/


    var param = "?";
    for (var i = 0; i < print_list.length; i++) {
        param += print_list[i];
        if ((print_list.length - 1) != i) {
            param += "&";
        }
    }

    if (print_list.length > 0) {
        window.open('/hr/printid/preview' + param);
    } else {
        showWarningMessage('Please select employees...!');
    }


}


function selectCard(id) {
    var bool = $('#' + id).is(':checked');
    if (bool) {
        print_list.push(id);
    } else {
        const index = print_list.indexOf(id);
        if (index > -1) {
            print_list.splice(index, 1);
        }
    }
}







