/**
 * java script -salartSheet
 *
 * @author  Sampath Perera
 * @since   2020-11-27
 */


loadEmployee_Name_And_ID();
allEmployeeSalary();
var update_id = 0;
$(document).ready(function () {


    /**
     * datepicker
     * This is jquery foe datepicker .
     */
    $('input[name="dteDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });



    $('#salaryTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name_full" },
            { "data": "salary" },
            { "data": "edit", className: "edit" },
            { "data": "delete", className: "delete" },
            { "data": "status", className: "disable" },
        ],
        columnDefs: [
            { width: 80, targets: 0 },
            { width: 150, targets: 2 },
            { width: 30, targets: 3 },
            { width: 30, targets: 4 },
            { width: 30, targets: 5 },
        ],
    });
});


/**
* loadEmployee_Name_And_ID
* This function is used to load allemplyee name
*/
function loadEmployee_Name_And_ID() {

    $.ajax({
        type: "GET",
        url: '/hr/salary/allEmployeeNameAndID',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp1").setData(response.data.result.Name);
                $("#auto-comp2").setData(response.data.result.ID);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}

function autoCompleteSelectedOption(input, data) {
    //console.log(data);

}

function onChangeAutoCompleteOption(event) {
    loadEmployee($('#' + event.target.id).optionID());

}



function loadEmployee(employee_id) {

    $('#formSalaryEmployee').trigger("reset");
    $('#btnAction').text('Save');

    $.ajax({
        type: "GET",
        url: '/hr/salary/employee/' + employee_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var employee = response.data.result;
                $('#auto-comp2').attr('data-id', employee.employee_id);
                $('#auto-comp2').val(employee.employee_id);
                $('#auto-comp1').attr('data-id', employee.employee_id);
                $('#auto-comp1').val(employee.name_withinitial);
                $('#txtEmployeeAddress').val(employee.address);
                $('#imgEmployee').attr("src", employee.photo_parth);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}


function actionBtn() {

    var text = $('#btnAction').text();
    if (text == "Save") {
        save();
    } else if (text == "Update") {
        update();
    }
}


/**
* save
* This function is used to save employee salary.
*/
function save() {

    var form = $('#formSalaryEmployee').get(0);
    var data = new FormData(form);
    data.append("employee_id", $('#auto-comp1').optionID());

    $.ajax({
        type: "POST",
        url: "/hr/salary/save",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success == true) {
                showSuccessMessage("Salary has been saved successfully...");
                resetSalary();
            } else {
                if (response.data.message == "Activated") {
                    showWarningMessage(response.data.result + " : this employee's salary status already activated...");
                } else {
                    showErrorMessage();
                }

            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            allEmployeeSalary();
        }

    });
}


function update() {

    $.ajax({
        type: 'PUT',
        url: '/hr/salary/update/' + update_id,
        data: $('#formSalaryEmployee').serialize() + '&' + $.param({ "employee_id": $('#auto-comp1').optionID() }, true),
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Employee salary has been updated successfully...");
                resetSalary();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error.message);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



function allEmployeeSalary() {
    $.ajax({
        type: "GET",
        url: '/hr/salary/allSalary',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                loadTable(response.data.result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function loadTable(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {

        var status = "";
        if (result[i]['status'] == 1) {
            status = "checked";
        }
        var string_id = "'" + result[i]['id'] + "'";
        data.push({
            "employee_id": result[i]['employee_id'],
            "name_full": result[i]['name'],
            "salary": result[i]['salary'] + ".00.Rs",
            "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
            "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
            "status": '<label class="switch"><input type="checkbox" id="1" onchange="disable(event,' + string_id + ')" ' + status + '><span class="slider round"></span></label>'
        });
    }
    var table = $('#salaryTable').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.edit').visible(false);
    table.columns('.delete').visible(false);
    table.columns('.disable').visible(false);



    if (edit_permission == 1) {
        table.columns('.edit').visible(true);
    }

    if (delete_permission == 1) {
        table.columns('.delete').visible(true);
    }

    if (disable_permission == 1) {
        table.columns('.disable').visible(true);
    }


}



function edit(id) {

    $.ajax({
        type: "GET",
        url: '/hr/salary/employeeSalary/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                update_id = response.data.result.id;
                $('#auto-comp1').val(response.data.result.employee_name);
                $('#auto-comp1').attr("data-id", response.data.result.employee_id);
                $('#auto-comp2').attr('data-id', response.data.result.employee_id);
                $('#auto-comp2').val(response.data.result.employee_id);
                $('#txtEmployeeAddress').val(response.data.result.employee_address);
                $('#imgEmployee').attr("src", response.data.result.employee_img);
                $('#dteDate').val(response.data.result.tran_date);
                $('#txtSalary').val(response.data.result.salary);
                $('#txtRemark').val(response.data.result.remark);
                $('#btnAction').text('Update');

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}

function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/hr/salary/delete/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Employee salary has been deleted successfully...");
                allEmployeeSalary();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}

function disable(event, id) {

    var status = 0;
    if (event.target.checked) {
        status = 1;
    }

    $.ajax({
        type: 'PUT',
        url: '/hr/salary/disable/' + id,
        data: {
            _token: $('input[name=_token]').val(),
            "status": status
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Employee salary has been updated successfully...");
                //resetSalary();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error.message);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


/**
* resetSalary
* This function is used to reset form.
*/
function resetSalary() {
    $('#auto-comp1').val("");
    $('#auto-comp1').attr("data-id", "");
    $('#txtEmployeeAddress').val("");
    $('#formSalaryEmployee').trigger("reset");
    $('#btnAction').text('Save');
    $("#imgEmployee").attr("src", "/images/employee.jpg");
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
