

var month_end_year = null;
var month_end_month = null;

$(document).ready(function () {

    $('#tblSalaryData').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name_full" },
            { "data": "net_salary" },
            { "data": "date" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
            { "data": "print", className: "print" },
        ],
        columnDefs: [
            { width: 80, targets: 0 },
            { width: 100, targets: 2 },
            { width: 100, targets: 3 },
            { width: 20, targets: 4 },
            { width: 20, targets: 5 },
            { width: 20, targets: 6 },
            { width: 20, targets: 7 },
        ],
    });

    $(".modal-dialog").css("min-width", "50%");

    isMonthEndPeocess();
    allSettings();
    loadSlaryData_afterMonthendProcess()
});

function showModal() {
    $("#searchModal").modal('toggle');
}




function edit(id, month, year) {
    location.href = "/hr/salarySheet?edit=" + id + "&mm=" + month + "&yy=" + year;
}



function view(id, month, year) {
    location.href = "/hr/salarySheet?view=" + id + "&mm=" + month + "&yy=" + year;
}







function _delete(id) {



    swal({
        title: "Are you sure?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
        .then((willDelete) => {
            if (willDelete) {
                do_delete(id);
            }
        });
}





function do_delete(id) {

    $.ajax({
        type: 'DELETE',
        url: '/hr/salaryData/deleteSalaryDataFromID/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Employee has been deleted successfully...")
                loadSlaryData_afterMonthendProcess()
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });

}


function allSettings() {

    $.ajax({
        type: "GET",
        url: "/hr/salaryData/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                console.log(settings.allowance);
                appendOption("selcCategory", settings.category);
                appendOption("selcSite", settings.site);
                appendOption("selcDepartment", settings.department);
                appendOption("selcSection", settings.section);
                appendOption("selcCompany", settings.company);
                $('#auto-comp3').setData(settings.employee);
                appendYear();
                appendMonth();

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            $('#selcSection').trigger('change');
        }

    });
}






$('#selcSection').change(function (event) {


    if (event.target.value == "") {
        return;
    }
    $.ajax({
        type: "GET",
        url: "/hr/salaryData/subSection/" + event.target.value,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                appendOption("selcSubsection", response.data.result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
});







function appendOption(combobox, result) {

    $('#' + combobox).empty();
    //$('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}



function appendYear() {

    var date = new Date();
    var year = date.getFullYear();

    $('#selcYear').empty();
    //$('#selcYear').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 2015; i <= year; i++) {
        $('#selcYear').append('<option value="' + i + '">' + i + '</option>');
    }

    let element = document.getElementById('selcYear');
    element.value = year;
}


function appendMonth() {
    var month = {
        1: "January",
        2: "February",
        3: "March",
        4: "April",
        5: "May",
        6: "June",
        7: "July",
        8: "August",
        9: "September",
        10: "October",
        11: "November",
        12: "December",
    };


    $('#selcMonth').empty();
    //$('#selcMonth').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 1; i <= 12; i++) {
        $('#selcMonth').append('<option value="' + i + '">' + month[i] + '</option>');
    }

    var date = new Date();
    var mon = date.getMonth() + 1;
    let element = document.getElementById('selcMonth');
    element.value = mon;
}



function search() {

    $.ajax({
        type: "GET",
        url: '/hr/salaryData/search',
        data: {
            _token: $('input[name=_token]').val(),
            "is_category": $('#checkCategorySearch').is(":checked"),
            "category": $('#selcCategory').val(),
            "is_site": $('#checkSiteSearch').is(":checked"),
            "site": $('#selcSite').val(),
            "is_department": $('#checkDepartmentSearch').is(":checked"),
            "department": $('#selcDepartment').val(),
            "is_section": $('#checkSectionSearch').is(":checked"),
            "section": $('#selcSection').val(),
            "is_subsection": $('#checkSubsectionSearch').is(":checked"),
            "subsection": $('#selcSubsection').val(),
            "is_company": $('#checkCompanySearch').is(":checked"),
            "company": $('#selcCompany').val(),
            "is_employee": $('#checkEmployeeSearch').is(":checked"),
            "employee": $('#auto-comp3').optionID(),
            "is_year_month": $('#checkYearMonth').is(":checked"),
            "year": $('#selcYear').val(),
            "month": $('#selcMonth').val(),

        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                appendTableRow(response.data.result);
                $("#searchModal").modal('hide');
            }


        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function isMonthEndPeocess() {
    $.ajax({
        type: "GET",
        url: '/hr/salaryData/isMonthEndProcess',
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                month_end_year = response.data.result.year;
                month_end_month = response.data.result.month;



            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function appendTableRow(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var id = "'" + result[i]['id'] + "'";
        var employee_id = result[i]['employee_id'];
        var name = result[i]['name'];
        var date = result[i]['salary_year'];
        var salary_month = result[i]['salary_month'] + "";
        if (salary_month.length == 1) {
            date = date + "-0" + salary_month;
        } else {
            date = date + "-" + salary_month;
        }
        var net_salary = result[i]['net_salary'];
        var year = "'" + result[i]['salary_year'] + "'";
        var month = "'" + result[i]['salary_month'] + "'";


        var disabled = "";
        if (result[i]['salary_year'] != month_end_year || result[i]['salary_month'] != month_end_month) {
            disabled = "disabled";
        } else {
            disabled = "";
        }

        data.push({
            "employee_id": employee_id,
            "name_full": name,
            "net_salary": net_salary.toFixed(2),
            "date": date,
            "edit": '<button type="button" class="btn btn-primary" onclick="edit(' + id + ',' + month + ',' + year + ')" ' + disabled + '><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
            "view": '<button type="button" class="btn btn-success" onclick="view(' + id + ',' + month + ',' + year + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
            "delete": '<button type="button" class="btn btn-danger" onclick="_delete(' + id + ')" ' + disabled + '><i class="fa fa-trash" aria-hidden="true"></i></button>',
            "print": '<button type="button" class="btn btn-dark" onclick=""><i class="fa fa-print" aria-hidden="true"></i></button>'
        });
    }

    var table = $('#tblSalaryData').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.edit').visible(false);
    table.columns('.view').visible(false);
    table.columns('.delete').visible(false);
    table.columns('.print').visible(false);



    if (edit_permission == 1) {
        table.columns('.edit').visible(true);
    }

    if (view_permission == 1) {
        table.columns('.view').visible(true);
    }

    if (delete_permission == 1) {
        table.columns('.delete').visible(true);
    }

    if (print_permission == 1) {
        table.columns('.print').visible(true);
    }

}







function allSalaryData(year, month) {

    $.ajax({
        type: "GET",
        url: "/hr/salaryData/allSalaryData/" + year + "/" + month,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                appendTableRow(response.data.result);
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            $('#selcSection').trigger('change');
        }

    });
}





function loadSlaryData_afterMonthendProcess() {
    $.ajax({
        type: "GET",
        url: '/hr/salaryData/isMonthEndProcess',
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var month_end_year = response.data.result.year;
                var month_end_month = response.data.result.month;

                allSalaryData(month_end_year,month_end_month);



            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}







/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
