@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ url('vendors/selects/select2.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<style>
    td {
        font-size: 11px;
    }
</style>
<script>
    var edit_permission = "{{Auth::user()->can('employee_attendance_edit')}}";
    var process_permission = "{{Auth::user()->can('employee_attendance_process')}}";
</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title">Attendance Edit</h6>
                {{csrf_field()}}
                <!--<div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="row">
                            <div class="col-md-8">
                                <i class="fa fa-users text-info" aria-hidden="true"></i>
                                <label>Employee ID</label>
                                <input autocomplete="off" type="text" class="form-control auto-complete" id="txtEmployeeID">
                            </div>
                            <div class="col-md-4">
                                <label>Attendance ID</label>
                                <label class="form-control" id="txtAttendanceID"></label>
                            </div>
                        </div>
                    </div>
                </div>!-->
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="row">
                            <div class="col-md-8">
                                <i class="fa fa-users text-info" aria-hidden="true"></i>
                                <label>Employee ID</label>
                                <select autocomplete="off" type="text" class="form-control select2" id="cmbEmployeeID"></select>
                            </div>
                            <div class="col-md-4">
                                <label>Attendance ID</label>
                                <label class="form-control" id="txtAttendanceID"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                        <label>Employee Name</label>
                        <input type="text" class="form-control auto-complete" id="txtEmployeeName">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="row">
                            <div class="col-md-6">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>From</label>
                                <input type="text" class="form-control" id="txtDateFrom" name="date">
                            </div>
                            <div class="col-md-6">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>To</label>
                                <input type="text" class="form-control" id="txtDateTo" name="date">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <hr>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-9">
                        <div class="row">
                            <div class="col-md-12 seperator">
                                <div class="card bg-light">
                                    <div class="card-header">Net Salary</div>
                                    <table id="att_timeTable" class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Date</th>
                                                <th>Schedule InTime</th>
                                                <th>Schedule OutTime</th>
                                                <th>Actual InTime</th>
                                                <th>Actual OutTime</th>
                                                <th>Remark</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody id="att_timeBody"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12" style="text-align: right;">
                                @if(Auth::user()->can('employee_attendance_process'))
                                <button id="btnProcess" class="btn btn-primary" onclick="process()">Process</button>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="row">
                            <div class="col-md-12 seperator">
                                <div class="card bg-light">
                                    <div class="card-header">Raw Data</div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table" id="tblRawDataTable">
                                            <thead>
                                                <tr>
                                                    <th>Attendance</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblRawData"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>

    </div>
</div>

@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ url('vendors/selects/select2.min.js') }}"></script>

<script src="{{ Module::asset('hr:js/attendanceReportEdit.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/attendanceDriversSchedule.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection