@extends('hr::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Salary Advance</h6>
                <div class="row">
                    <div class="col-md-7">
                        <form method="POST" id="salaryAdvanceForm" name="salaryAdvanceForm">
                            {{ csrf_field() }}
                            <div class="row">
                                <div class="col-md-4">
                                    <i class="fa fa-search text-info" aria-hidden="true"></i>
                                    <label>Employee ID</label>
                                    <input type="hidden" value="1" id="employee_id" name="employee_id">
                                    <input type="text" class="form-control auto-complete" id="auto-comp1">
                                </div>
                                <div class="col-md-8">
                                    <i class="fa fa-search text-info" aria-hidden="true"></i>
                                    <label>Name(with initials)</label>
                                    <input type="text" class="form-control auto-complete" id="auto-comp2">
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Amount</label>
                                            <input type="text" class="form-control float" id="txtAmount" name="txtAmount">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Date</label>
                                            <input type="text" class="form-control" id="txtTranDate" name="txtTranDate">
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Deduction Year</label>
                                            <select class="form-control" id="selcDeductYear" name="selcDeductYear"></select>
                                        </div>
                                        <div class="col-md-6">
                                            <i class="fa fa-tag text-info" aria-hidden="true"></i>
                                            <label>Deduction Month</label>
                                            <select class="form-control" id="selcDeductMonth" name="selcDeductMonth"></select>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6"></div>
                                        <div class="col-md-6">
                                            <table style="width: 100%;">
                                                <tr>
                                                    <td style="padding-right: 20px;">
                                                        @if(Auth::user()->can('employee_salary_advance_delete'))
                                                        <button type="button" class="btn btn-danger" id="btnDelete" onclick="_delete()"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                                        @endif
                                                    </td>
                                                    <td style="text-align: right;">
                                                        <button type="button" class="btn btn-warning" id="btnReset" onclick="resetSalaryAdvance()">Reset</button>
                                                    </td>
                                                    <td style="text-align: right;">
                                                        @if(Auth::user()->can('employee_salary_advance_create'))
                                                        <button type="button" class="btn btn-primary" id="btnAction">Save</button>
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="col-md-5">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="imgContainer">
                                    <img class="img img-thumbnail" src="/images/employee.jpg" id="imgEmployee" alt="image/">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}"></script>

<script src="{{ Module::asset('hr:js/etc/numeric.js') }}"></script>

<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('hr:js/salaryAdvance.js') }}"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection