@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!--<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/salarySheetList.css') }}" type="text/css">!-->
<script>
    var view_permission = "{{Auth::user()->can('employee_salary_sheet_view')}}";
    var edit_permission = "{{Auth::user()->can('employee_salary_sheet_edit')}}";
    var delete_permission = "{{Auth::user()->can('employee_salary_sheet_delete')}}";
    var print_permission = "{{Auth::user()->can('employee_salary_sheet_print')}}";
</script>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-11">
                        <h6 class="card-title">Employee Salary</h6>
                    </div>
                    <div class="col-md-1">
                        @if(Auth::user()->can('employee_salary_sheet_search'))
                        <button class="btn btn-primary" onclick="showModal()"><i class="fa fa-search" aria-hidden="true"></i></button>
                        @endif
                    </div>
                </div>

                {{ csrf_field() }}
                <table id="tblSalaryData" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                    <thead>
                        <tr>
                            <th class="id">Employee ID</th>
                            <th>Name</th>
                            <th class="amount">Net Salary</th>
                            <th class="date">Date</th>
                            <th class="edit">Edit</th>
                            <th class="view">View</th>
                            <th class="delete">Delete</th>
                            <th class="print">Print</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="searchModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="searchModalTitle">Search For Employee Salary</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <form method="POST" id="myForm">
                {{csrf_field()}}
                <input type="hidden" id="settingID" name="settingID" value>
                <div class="modal-body" id="searchModalBody">
                    <hr>
                    <div class="row">

                        <div class="col-md-6" style="padding-top: 5px;">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <table style="width:100%">
                                                <tr>
                                                    <td>
                                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                        <label>Category</label>
                                                    </td>
                                                    <td style="text-align: right">
                                                        <label class="switch"><input type="checkbox" id="checkCategorySearch"><span class="slider round"></span></label>
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 mb-0">
                                            <select class="form-control" id="selcCategory" name="selcCategory"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" style="padding-top: 5px;">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <table style="width:100%">
                                                <tr>
                                                    <td>
                                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                        <label>Section</label>
                                                    </td>
                                                    <td style="text-align: right">
                                                        <label class="switch"><input type="checkbox" id="checkSectionSearch"><span class="slider round"></span></label>
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 mb-0">
                                            <select class="form-control" id="selcSection" name="selcSection"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>


                    <div class="row">

                        <div class="col-md-6" style="padding-top: 5px;">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <table style="width:100%">
                                                <tr>
                                                    <td>
                                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                        <label>Site</label>
                                                    </td>
                                                    <td style="text-align: right">
                                                        <label class="switch"><input type="checkbox" id="checkSiteSearch"><span class="slider round"></span></label>
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 mb-0">
                                            <select class="form-control" id="selcSite" name="selcSite"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" style="padding-top: 5px;">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <table style="width:100%">
                                                <tr>
                                                    <td>
                                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                        <label>Sub Section</label>
                                                    </td>
                                                    <td style="text-align: right">
                                                        <label class="switch"><input type="checkbox" id="checkSubsectionSearch"><span class="slider round"></span></label>
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 mb-0">
                                            <select class="form-control" id="selcSubsection" name="selcSubsection"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>



                    <div class="row">

                        <div class="col-md-6" style="padding-top: 5px;">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <table style="width:100%">
                                                <tr>
                                                    <td>
                                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                        <label>Department</label>
                                                    </td>
                                                    <td style="text-align: right">
                                                        <label class="switch"><input type="checkbox" id="checkDepartmentSearch"><span class="slider round"></span></label>
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 mb-0">
                                            <select class="form-control" id="selcDepartment" name="selcDepartment"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" style="padding-top: 5px;">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <table style="width:100%">
                                                <tr>
                                                    <td>
                                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                        <label>Company</label>
                                                    </td>
                                                    <td style="text-align: right">
                                                        <label class="switch"><input type="checkbox" id="checkCompanySearch"><span class="slider round"></span></label>
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 mb-0">
                                            <select class="form-control" id="selcCompany" name="selcCompany"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>


                    <div class="row">

                        <div class="col-md-6" style="padding-top: 5px;">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <table style="width:100%">
                                                <tr>
                                                    <td>
                                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                        <label>Employee</label>
                                                    </td>
                                                    <td style="text-align: right">
                                                        <label class="switch"><input type="checkbox" id="checkEmployeeSearch"><span class="slider round"></span></label>
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 mb-0">
                                            <input type="text" class="form-control auto-complete" id="auto-comp3">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" style="padding-top: 5px;">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <table style="width:100%">
                                                <tr>
                                                    <td>
                                                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                                        <label>Year / Month</label>
                                                    </td>
                                                    <td style="text-align: right">
                                                        <label class="switch"><input type="checkbox" id="checkYearMonth"><span class="slider round"></span></label>
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-0">
                                            <select class="form-control" id="selcYear" name="selcYear"></select>
                                        </div>
                                        <div class="col-md-6 mb-0">
                                            <select class="form-control" id="selcMonth" name="selcMonth"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                    </button>
                    <button type="button" class="btn btn-primary" id="btnSetting" onclick="search()">Search</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/salarySheetList.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Sweet alert -->
<script src="{{ url('assets/js/examples/sweet-alert.js') }}"></script>


<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection