<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttSchedulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_att_schedules', function (Blueprint $table) {
            $table->id('schedule_id');
            $table->string('employee_id', 25);
            $table->foreign('employee_id')->references('employee_id')->on('hr_employees')->onDelete('cascade');
            $table->foreignId('shift_id');
            $table->foreign('shift_id')->references('shift_id')->on('hr_att_shifts')->onDelete('cascade');
            $table->date('schedule_date_from');
            $table->dateTime('in_time');
            $table->dateTime('out_time');
            $table->string('remark', 250);
            $table->boolean('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hr_att_schedules');
    }
}
