<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class AtdHoliday extends Model
{
    protected $table = 'hr_atd_holidays';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'id',
        'holyday_date',
        'holyday_type_id',
        'site_id',
        'remarks',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_atd_holidays";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
