<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class EmployeeStatus extends Model
{
    protected $table = 'hr_employee_statuses';
    protected $primaryKey = 'employeestatus_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'employeestatus_id',
        'employeestatus',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_employee_statuses";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
