<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\AttShift;

class AttShiftController extends Controller
{
    //

    public function save(Request $request)
    {
        try {

            $duration_hours = $request->get('durationHours');
            $duration_minutes = $request->get('durationMinutes');
            $duration_hours = ($duration_hours + ($duration_minutes / 60.0));

            $shift = new AttShift();
            $shift->shift_name = $request->get('shiftName');
            $shift->start_time = $request->get('startTime');
            $shift->duration = $duration_hours;
            $shift->breack_hours = $request->get('breackHours');
            $shift->short_leave_duration = $request->get('shortLeaveDuration');
            $shift->halfday_time = $request->get('halfdayTime');
            $shift->ot_after_minutes = $request->get('otAfterMinutes');
            $shift->days_count = $request->get('daysCount');
            $shift->status = true;

            $save = $shift->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "Shift", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function update(Request $request,$id)
    {
        try {
            $duration_hours = $request->get('durationHours');
            $duration_minutes = $request->get('durationMinutes');
            $duration_hours = ($duration_hours + ($duration_minutes / 60.0));

            $shift = AttShift::find($id);
            $shift->shift_name = $request->get('shiftName');
            $shift->start_time = $request->get('startTime');
            $shift->duration = $duration_hours;
            $shift->breack_hours = $request->get('breackHours');
            $shift->short_leave_duration = $request->get('shortLeaveDuration');
            $shift->halfday_time = $request->get('halfdayTime');
            $shift->ot_after_minutes = $request->get('otAfterMinutes');
            $shift->days_count = $request->get('daysCount');

            $update = $shift->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Shift", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function delete($id){
        try {

            $assigned = $this->isAssigned($id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Category", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $shift = AttShift::find($id);
            $delete = $shift->delete();

            if ($delete) {
                $responseBody = $this->responseBody(true, "Shift", "deleted",null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function disable(Request $request, $id)
    {

        try {
            $assigned = $this->isAssigned($id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Shift", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $shift = AttShift::find($id);
            $shift->status = $request->get('status');
            $disable = $shift->save();
            if ($disable) {
                $responseBody = $this->responseBody(true, "Shift", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "Shift", "updated", $disable);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    

    private function isAssigned($id)
    {

       /* $setting = DB::table('employees')->where('category_id', $id)->first();
        if ($setting) {
            return true;
        }*/
        return false;
    }





    public function allShift()
    {
        try {
            $shift = AttShift::all();
            $responseBody = $this->responseBody(true, "Shift", "all", $shift);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function getShift($id)
    {
        try {
            $shift = AttShift::find($id);
            $responseBody = $this->responseBody(true, "Shift", "shift", $shift);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
