<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeAttachment;

class AttachmentController extends Controller
{
    //

    public function allEmployee()
    {

        try {
            $employee = Employee::all();
            $collection = [];
            for ($i = 0; $i < count($employee); $i++) {
                //$value = $employee[$i]->name_withinitial . '#' . $employee[$i]->employee_id;
                array_push($collection, ["img" => $employee[$i]->photo_parth, "id" => $employee[$i]->employee_id, "value" => $employee[$i]->name_withinitial]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getEmployeeFromId($id)
    {

        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    function upload(Request $request)
    {

        try {
            $id = $request->get('employee_id');
            $file = $request->file('file');
            $file_name = $file->getClientOriginalName();
            $file->move(public_path('employee'), $file_name);

            $employee_attachment = new EmployeeAttachment();
            $employee_attachment->employee_id = $id;
            $employee_attachment->file_path = $file_name;
            $employee_attachment->save();
        } catch (\Exception $exception) {
            //$responseBody = $this->responseBody(false, "error", "upload", $exception);
        }
        return true;
        //return response()->json(["data" => $responseBody]);
    }


    function allFiles($id)
    {
        try {
            $all_attachment = EmployeeAttachment::where('employee_id', '=', $id)->get();
            $responseBody = $this->responseBody(true, "Attachment", "all", $all_attachment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attachment", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    function delete($id)
    {
        try {
            $attachment = EmployeeAttachment::find($id);
            $delete = $attachment->delete();

            if ($delete) {
                $responseBody = $this->responseBody(true, "Attachment", "deleted", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attachment", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
