<?php

namespace Modules\Hr\Http\Controllers;

use DateTime;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttSchedule;
use Modules\Hr\Entities\Employee;

class AttendanceReportEditController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('hr::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('hr::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('hr::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('hr::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }



    /**
     * allEmployeeId
     * This function is used to get all employee's id for auto complete.
     */
    public function allEmployeeId()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    /**
     * allEmployeeName
     * This function is used to get all employee's id for auto complete.
     */
    public function allEmployeeName()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function employee($id)
    {
        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getAttendance($id, $startDate, $endDate)
    {
        try {


            $query = "SELECT
            hr_employees.`employee_id` AS employee_id,
            hr_employees.`name_withinitial` AS employees_name,
            hr_employees.`attendance_id` AS attendance_id,
            hr_att_time.`InTime` AS att_InTime,
            hr_att_time.`OutTime` AS att_OutTime,
            hr_att_time.`Date` AS att_date,
            hr_att_time.`ID` AS att_id,
            hr_att_time.`Original_InTime` AS att_original_InTime,
            hr_att_time.`Original_OutTime` AS att_original_OutTime,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`start_time` AS shift_start_time,
            hr_att_shifts.`duration` AS shift_duration,
            hr_att_shifts.`shift_id` AS shift_id
            FROM
            `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`attendance_id` = hr_att_time.`EmployeeID`
            INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_time.`ShiftNo` = hr_att_shifts.`shift_id` WHERE hr_employees.`employee_id` = '" . $id . "'  AND hr_att_time.`Date`  BETWEEN '" . $startDate . "' AND '" . $endDate . "'";


            $result = DB::select($query);
            foreach ($result as $row) {

                $schedule = DB::select("SELECT DISTINCT in_time,out_time FROM `hr_att_schedules` where shift_id = '" . $row->shift_id . "' AND schedule_date_from  = '" . $row->att_date . "'")[0];
                $row->shift_start_time = $schedule->in_time;
                $row->shift_end_time = $schedule->out_time;
            }


            $employees = Employee::all();
            //$attendance_report_array = array();
            $attendance_array = array();
            foreach ($employees as $employee) {
                foreach ($result as $attendance) {
                    if ($employee->employee_id == $attendance->employee_id) {
                        array_push($attendance_array, $attendance);
                    }
                }
                /*if (count($attendance_array) > 0) {
                    array_push($attendance_report_array, ["header" => $employee, "body" => $attendance_array]);
                }*/
            }
            $responseBody = $this->responseBody(true, "Attendance", "all", $attendance_array);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function getAttendance_test($id, $startDate, $endDate)
    {
        try {


            $query = "SELECT
            hr_employees.`employee_id` AS employee_id,
            hr_employees.`name_withinitial` AS employees_name,
            hr_employees.`attendance_id` AS attendance_id,
            hr_att_time.`ID` AS att_id,
            hr_att_time.`InTime` AS att_InTime,
            hr_att_time.`OutTime` AS att_OutTime,
            hr_att_time.`Date` AS att_date,
            hr_att_time.`Day_Type` AS Day_Type,
            hr_att_time.`Worked_Day` AS Worked_Day,
            hr_att_time.`Overtime` AS Overtime,
            hr_att_time.`NoPay` AS NoPay,
            hr_att_time.`LeaveType` AS LeaveType,
            hr_att_time.`Late_Arriver` AS Late_Arriver,
            hr_att_time.`remark` AS remark,
            hr_att_time.`Early_Departure` AS Early_Departure
            FROM
            `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`employee_id` = hr_att_time.`EmployeeID` WHERE hr_employees.`employee_id` = '" . $id . "' AND hr_att_time.`Date`  BETWEEN '" . $startDate . "' AND '" . $endDate . "'  GROUP BY hr_att_time.Date";

            $result = DB::select($query);
            foreach ($result as $row) {

                $query2 = "SELECT
                hr_att_schedules.`schedule_id` AS schedule_id,
                hr_att_shifts.`shift_name` AS shift_name,
                hr_att_shifts.`duration` AS duration,
                hr_att_schedules.`schedule_date_from` AS date_from,
                hr_att_schedules.`in_time` AS in_time,
                hr_att_schedules.`out_time` AS out_time
                FROM
                `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id`
                INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id` WHERE hr_employees.`employee_id` = '" . $row->employee_id . "' AND hr_att_schedules.`schedule_date_from` = '" . $row->att_date . "'";

                $schedule = DB::select($query2);
                if (count($schedule) > 0) {
                    $row->schedule_id = $schedule[0]->schedule_id;
                    $row->shift_start_time = $schedule[0]->in_time;
                    $row->shift_end_time = $schedule[0]->out_time;
                    $row->shift_name = $schedule[0]->shift_name;
                    $row->shift_duration = $schedule[0]->duration;
                } else {
                    $row->schedule_id = '';
                    $row->shift_start_time = '';
                    $row->shift_end_time = '';
                    $row->shift_name = '';
                }

                /*$leaveType = AttLeaveType::find($row->LeaveType);
                if ($leaveType) {
                    $row->leave_type = $leaveType->leave_type;
                }*/

                $d    = new DateTime($row->att_date);
                $row->day = substr($d->format('l'), 0, 1);
            }


            /*$employees = Employee::all();
            $attendance_report_array = array();
            foreach ($employees as $employee) {
                $attendance_array = array();
                foreach ($result as $attendance) {
                    if ($employee->employee_id == $attendance->employee_id) {
                        array_push($attendance_array, $attendance);
                    }
                }
                if (count($attendance_array) > 0) {
                    array_push($attendance_report_array, ["header" => $employee, "body" => $attendance_array]);
                }
            }*/
            $responseBody = $this->responseBody(true, "Attendance", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function attendanceRawData($id, $date)
    {
        try {
            $query = "SELECT hr_att_raw_data.ID As attendance_id,hr_att_raw_data.ChecKINOUT As attendance FROM `hr_att_raw_data` WHERE ID = '" . $id . "' AND DATE(ChecKINOUT) = '" . $date . "'";
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "Attendance", "all", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function updateInTime(Request $request, $id)
    {
        try {
            $intime = $request->get('intime');
            DB::update("UPDATE `hr_att_time` SET InTime = '" . $intime . "' WHERE ID = '" . $id . "'");
            $responseBody = $this->responseBody(true, "Attendance", "Updated", NULL);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function updateOutTime(Request $request, $id)
    {
        try {
            $intime = $request->get('outtime');
            DB::update("UPDATE `hr_att_time` SET OutTime = '" . $intime . "' WHERE ID = '" . $id . "'");
            $responseBody = $this->responseBody(true, "Attendance", "Updated", NULL);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function updateInOut(Request $request, $id)
    {
        try {
            $schedule_id = $request->get('schedule_id');
            $schedule_intime = $request->get('schedule_intime');
            $schedule_outtime = $request->get('schedule_outtime');
            $intime = $request->get('intime');
            $outtime = $request->get('outtime');
            $remark = $request->get('remark');
            $date = explode(" ", $intime)[0];

            $shift = $this->getShift($id, $date);
            $shift_id = '';
            if (count($shift) > 0) {
                $shift_id = $shift[0]->shift_id;
            }


            DB::update("UPDATE `hr_att_time` SET InTime = (null), OutTime = (null), In_Status = '0',Out_Status = '0', Edited = '0', ShiftNo = '" . $shift_id . "', remark = '" . $remark . "' WHERE ID = '" . $id . "'");
            if ($intime) {
                DB::update("UPDATE `hr_att_time` SET InTime = '" . $intime . "', In_Status = '1', Edited = '1', ShiftNo = '" . $shift_id . "', remark = '" . $remark . "' WHERE ID = '" . $id . "'");
            }
            if ($outtime) {
                DB::update("UPDATE `hr_att_time` SET OutTime = '" . $outtime . "', Out_Status = '1', Edited = '1', ShiftNo = '" . $shift_id . "', remark = '" . $remark . "' WHERE ID = '" . $id . "'");
            }
           $this->updateScheduleInOut($schedule_intime,$schedule_outtime,$schedule_id);

            $responseBody = $this->responseBody(true, "Attendance", "Updated", $shift);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function updateScheduleInOut($intime, $outtime, $id)
    {
        $schedule = AttSchedule::find($id);
        if($schedule){
            $schedule->in_time = $intime;
            $schedule->out_time = $outtime;
            $schedule->update();
        }
    }


    private function getShift($id, $date)
    {

        $query = "SELECT hr_att_time.EmployeeID FROM hr_att_time WHERE hr_att_time.ID ='" . $id . "'";
        $result = DB::select($query);
        $employee_id = '';
        if (count($result) > 0) {
            $employee_id = $result[0]->EmployeeID;
        }

        return AttSchedule::where([['employee_id', '=', $employee_id], ['schedule_date_from', '=', $date]])->get();
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
