<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeTeam;
use Modules\Hr\Entities\Team;

class EmployeeTeamController extends Controller
{
    //



    public function getAllEmployee()
    {

        $query = "SELECT 
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_employee_categories.`category` AS category,
        hr_employee_sites.`site` AS site,
        hr_employee_departments.`department` AS department,
        hr_employee_sections.`section` AS section,
        hr_employee_subsections.`subsection` AS subsection
        from hr_employees
        LEFT JOIN hr_employee_categories ON hr_employees.category_id = hr_employee_categories.category_id
        LEFT JOIN hr_employee_sites ON hr_employees.site_id = hr_employee_sites.site_id
        LEFT JOIN hr_employee_departments ON hr_employees.department_id = hr_employee_departments.department_id
        LEFT JOIN hr_employee_sections ON hr_employees.section_id = hr_employee_sections.section_id
        LEFT JOIN hr_employee_subsections ON hr_employees.subsection_id = hr_employee_subsections.subsection_id
        LEFT JOIN hr_employee_teams on hr_employees.employee_id = hr_employee_teams.employee_id WHERE ISNULL(hr_employee_teams.employee_id) ";

        try {
            $employees = DB::select($query);
            $responseBody = $this->responseBody(true, "EmployeeTeam", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeam", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allTeam()
    {
        try {
            $teams = Team::all();
            $responseBody = $this->responseBody(true, "Team", "all", $teams);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function setTeam(Request $request)
    {

        try {
            $team = new EmployeeTeam();
            $team->team_id = $request->get('team_id');
            $team->employee_id = $request->get('employee_id');
            $save = $team->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "Team", "saved", null);
            } else {
                $responseBody = $this->responseBody(false, "Team", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function getTeamMember($id)
    {
        try {
            $query = "SELECT
            hr_teams.`team_name` AS team_name,
            hr_teams.`leader_id` AS leader_id,
            hr_employee_teams.`employee_id` AS employee_id,
            hr_employee_teams.`employee_team_id` AS employee_team_id
       FROM
            `hr_teams` hr_teams INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_teams.`team_id` = hr_employee_teams.`team_id` WHERE hr_employee_teams.`team_id` = '" . $id . "'";

            $team_members = DB::select($query);
            for ($i = 0; $i < count($team_members); $i++) {
                $emp_id = $team_members[$i]->employee_id;
                $employee = Employee::find($emp_id);
                $team_members[$i]->name_withinitial = $employee->name_withinitial;

                $lead_id = $team_members[$i]->leader_id;
                $leader = Employee::find($lead_id);
                $team_members[$i]->leader = $leader->name_withinitial;
            }
            $responseBody = $this->responseBody(true, "EmployeeTeam", "all", $team_members);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeam", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




   public function isAssignedMmber($id)
    {
        try {
            $bool = false;
            $result = EmployeeTeam::where('employee_id', '=', $id)->get();
            if (count($result) > 0) {
                $bool = true;
            }
            $responseBody = $this->responseBody(true, "EmployeeTeam", "isAssignedMmber", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeam", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function remove($id)
    {
        try {
            $team = EmployeeTeam::find($id);
            $delete = $team->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "EmployeeTeam", "deleted", null);
            } else {
                $responseBody = $this->responseBody(false, "EmployeeTeam", "not deleted", $delete);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeam", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
