<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Intervention\Image\Facades\Image;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeDesignation;

class PrintIdController extends Controller
{
    //

    /**
     * allEmployee
     * This function is used to search all employee records from the database.
     * @return Json This returns as response.
     */
    public function allEmployee()
    {

        try {
            //$employeeResult =  Employee::orderBy('name_full')->get();
            $employeeResult =  Employee::where('print_status','=',0)->get();
            foreach ($employeeResult as $employee) {
                $designation = SettingsController::getSettingsFromID('Designation', $employee->designation_id);
                $employee->designation = $designation->designation; //create a new variable and assign value
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employeeResult);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allDesignation
     * This function is used to search all designation records from the database.
     * @return Json This returns as response.
     */
    public function allDesignation()
    {
        try {
            $result = SettingsController::allSettings('Designation');
            $responseBody = $this->responseBody(true, "Designation", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Designation", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }



    /**
     * employee
     * This function is used to search employe from employee id.
     * @return Json This returns as response.
     */
    public function employee($id)
    {

        try {
            $employee = Employee::find($id);

            $designation = SettingsController::getSettingsFromID('Designation', $employee->designation_id);
            $employee->designation = $designation->designation;

            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function update(Request $request, $id)
    {

        try {
            $employee = Employee::find($id);
            $employee->name_withinitial = $request->get('txtName');
            $employee->nic = $request->get('txtNic');
            $imageBase64 = $request->get('imgBase64');
            if ($imageBase64 != "null") {
                $employee->photo_parth =  '/' . $this->fileUpload($request->get('imgBase64'));
            }
            //$employee->designation = $request->get('selcDesignation');
            $employee->employee_id = $request->get('txtEmployeeID');
            $employee->attendance_id = $request->get('txtAttendanceID');
            $employee->date_join = $request->get('dteDateOfJoined');
            $employee->id_issue_date = $request->get('txtIDCardIssueDate');
            $employee->id_expire_date = $request->get('txtIDCardExpireDate');
            $employee->address = $request->get('txtEmployeeAddress');
            $employee->subcontractor = $request->get('txtSubContractor');
            $update = $employee->save();

            if ($update) {
                $responseBody = $this->responseBody(true, "Employee", "updated", $imageBase64);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }
    /**
     * fileUpload
     * This function is used to upload image.
     * @return String This returns as return value.
     */
    private function fileUpload($img)
    {
        $folderPath = "images/";
        $image_parts = explode(";base64,", $img);
        $image_base64 = base64_decode($image_parts[1]);
        $file = $folderPath . rand() . '.png';
        file_put_contents($file, $image_base64);
        return $file;
    }




    public function save(Request $request)
    {
        try {
            $employeeID = $request->get('txtEmployeeID');
            if ($this->isDuplicateEmployee($employeeID)) {
                $responseBody = $this->responseBody(true, "duplicate", "Duplicate Employee ID " . $employeeID, $employeeID);

                return response()->json(["data" => $responseBody]);
            }

            $employee = new Employee();
            $employee->name_full = "";
            $employee->town_id = "1";

            $employee->passport = "";
            $employee->drvl = "";
            $employee->birthday = $request->get('dteDateOfJoined');


            $employee->gender_id = "1";
            $employee->civilstatus_id = "1";
            $employee->bank_account = "";
            $employee->bank_id = "1";

            $employee->bankbranch_id = "1";
            $employee->email = "";
            $employee->mobile = "";
            $employee->fixed = "";

            $employee->gmap = "";
            $employee->emegency_contact = "";
            $employee->emegency_contactno1 = "";
            $employee->emegency_contactno2 = "";

            $employee->epf_no = "";
            $employee->employeetype_id = "1";
            $employee->employeestatus_id = "1";
            $employee->category_id = "1";
            $employee->site_id = "1";

            $employee->department_id = "1";
            $employee->section_id = "1";
            $employee->subsection_id = "1";
            $employee->company_id = "1";
            $employee->supervisor_id = "Unspecified";
            $employee->notes = "";
            $employee->contract_expire = "2020-11-23";

            $employee->print_status = false;
            $employee->email_alert = false;
            $employee->sms_alert = false;
            $employee->contract = false;





            $employee->name_withinitial = $request->get('txtName');
            $employee->nic = $request->get('txtNic');
            $imageBase64 = $request->get('imgBase64');
            if ($imageBase64 != "null") {
                $employee->photo_parth =  '/' . $this->fileUpload($request->get('imgBase64'));
            } else {
                $employee->photo_parth = "";
            }
            $employee->designation_id = $request->get('selcDesignation');
            $employee->employee_id = $employeeID;
            $employee->attendance_id = $request->get('txtAttendanceID');
            $employee->date_join = $request->get('dteDateOfJoined');
            $employee->id_issue_date = $request->get('txtIDCardIssueDate');
            $employee->id_expire_date = $request->get('txtIDCardExpireDate');
            $employee->address = $request->get('txtEmployeeAddress');
            $employee->subcontractor = $request->get('txtSubContractor');
            $save = $employee->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Employee", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
        //return $imageBase64;
    }



    /**
     * isDuplicateEmployee
     * This function is used to check is duplocate employee id.
     * @return boolean This returns as return value.
     */
    private function isDuplicateEmployee($employeeID)
    {

        $duplicate = Employee::find($employeeID);
        if ($duplicate) {
            return true;
        }
        return false;
    }




    /**
     * delete
     * This function is used to delete employe from employee id.
     * @return Json This returns as response.
     */
    public function delete($id)
    {
        try {
            $employee = Employee::find($id);
            $delete = $employee->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "Employee", "deleted", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function employeePrint($print_list)
    {
        try {
            $list = explode(',', $print_list);
            $employee_list = [];
            for ($i = 0; $i < count($list); $i++) {
                $employee = Employee::find($list[$i]);
                $designation = EmployeeDesignation::find($employee->designation_id);
                $employee->designation = $designation->designation;
                if (!$employee->print_status) {
                    array_push($employee_list, $employee);
                }
            }
            $responseBody = $this->responseBody(true, "Employee", "print", $employee_list);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function makedPrint(Request $request)
    {
        try {
            $maked =  $request->get('maked');
            for ($i = 0; $i < count($maked); $i++) {
                $employee_id =  $maked[$i];
                $employee = Employee::find($employee_id);
                $employee->print_status = true;
                $update = $employee->save();
                if ($update) {
                    $responseBody = $this->responseBody(true, "Employee", "update", $employee);
                }
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }
}
