<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeSubsection;
use Modules\Hr\Entities\SalaryData;

class SalaryDataListController extends Controller
{

    /**
     * search
     * This function is used to getall saved salary sheet.
     */
    public function allSalaryData($year,$month)
    {
        try {
            $query = "SELECT `salary_data`.id AS id,`salary_data`.employee_id AS employee_id, `employees`.name_withinitial AS name,(`salary_data`.net_salary - `salary_data`.fine_amount) AS net_salary,`salary_data`.salary_month,`salary_data`.salary_year FROM `hr_employees` employees INNER JOIN `hr_salary_data` salary_data ON employees.employee_id = salary_data.employee_id WHERE salary_data.salary_year >= '".$year."' AND salary_month = '".$month."' AND (employees.employeestatus_id = '2' || employees.employeestatus_id = '7')  ORDER BY convert(employees.employee_id, decimal) ASC";
            $salary_data = DB::select($query);
            $responseBody = $this->responseBody(true, "SalaryData", "all", $salary_data);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryData", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * deleteSalaryDataFromID
     * This function is used to delete salary sheet from id.
     * @param id This is the paramter to delete salary sheet.
     */
    public function deleteSalaryDataFromID($id)
    {
        try {
            $salary_data = SalaryData::find($id);
            $delete = $salary_data->delete();
            $responseBody = $this->responseBody(true, "SalaryData", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryData", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * allSettings
     * This function is used to get employee settings.
     */
    public function allSettings()
    {

        try {
            $settings = [
                "category" => $this->category(),
                "site" => $this->site(),
                "section" => $this->section(),
                "department" => $this->department(),
                "company" => $this->company(),
                "employee" => $this->allEmployee(),
            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * category
     * This function is used to get employee category.
     */
    private function category()
    {

        try {
            $category = EmployeeCategory::all();
            $collection = [];
            for ($i = 0; $i < count($category); $i++) {
                array_push($collection, ["id" => $category[$i]['category_id'], "value" => $category[$i]['category']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    /**
     * site
     * This function is used to get employee site.
     */
    private function site()
    {

        try {
            $site = EmployeeSite::all();
            $collection = [];
            for ($i = 0; $i < count($site); $i++) {
                array_push($collection, ["id" => $site[$i]['site_id'], "value" => $site[$i]['site']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    /**
     * department
     * This function is used to get employee department.
     */
    private function department()
    {

        try {
            $section = EmployeeDepartment::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['department_id'], "value" => $section[$i]['department']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    /**
     * section
     * This function is used to get employee section.
     */
    private function section()
    {

        try {
            $section = EmployeeSection::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['section_id'], "value" => $section[$i]['section']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    /**
     * subSection
     * This function is used to get employee subSection.
     */
    public function subSection($section_id)
    {
        try {
            $subsection = EmployeeSubsection::where('section_id', '=', $section_id)->get();
            $collection = [];
            for ($i = 0; $i < count($subsection); $i++) {
                array_push($collection, ["id" => $subsection[$i]['subsection_id'], "value" => $subsection[$i]['subsection']]);
            }
            $responseBody = $this->responseBody(true, "Subsection", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Subsection", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * company
     * This function is used to get employee company.
     */
    private function company()
    {

        try {
            $section = Company::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['company_id'], "value" => $section[$i]['company']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    /**
     * allEmployee
     * This function is used to get all employee.
     */
    private function allEmployee()
    {
        try {
            $employees = Employee::all();

            $collection = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($collection, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    /**
     * search
     * This function is used to get all saved salary sheet from settings.
     */
    public function search(Request $request)
    {

        try {

            $is_category = $request->get('is_category');
            $category = $request->get('category');

            $is_site = $request->get('is_site');
            $site = $request->get('site');

            $is_department = $request->get('is_department');
            $department = $request->get('department');

            $is_section = $request->get('is_section');
            $section = $request->get('section');

            $is_subsection = $request->get('is_subsection');
            $subsection = $request->get('subsection');

            $is_company = $request->get('is_company');
            $company = $request->get('company');

            $is_employee = $request->get('is_employee');
            $employee = $request->get('employee');

            $is_year_month = $request->get('is_year_month');
            $year = $request->get('year');
            $month = $request->get('month'); 

            $query = "SELECT `salary_data`.id AS id,`salary_data`.employee_id AS employee_id, `employees`.name_withinitial AS name,  (`salary_data`.net_salary - `salary_data`.fine_amount) AS net_salary FROM `hr_employees` employees INNER JOIN `hr_salary_data` salary_data ON employees.employee_id = salary_data.employee_id WHERE";
            if ($is_category == 'true') {
                $query .= " salary_data.category_id = '" . $category . "' ";
            }
            if ($is_site == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " salary_data.site_id = '" . $site . "' ";
                } else {
                    $query .= " OR salary_data.site_id = '" . $site . "' ";
                }
            }
            if ($is_department == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " salary_data.department_id = '" . $department . "' ";
                } else {
                    $query .= " OR salary_data.department_id = '" . $department . "' ";
                }
            }
            if ($is_section == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " salary_data.section_id = '" . $section . "' ";
                } else {
                    $query .= " OR salary_data.section_id = '" . $section . "' ";
                }
            }
            if ($is_subsection == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " salary_data.subsection_id = '" . $subsection . "' ";
                } else {
                    $query .= " OR salary_data.subsection_id = '" . $subsection . "' ";
                }
            }
            if ($is_company == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " salary_data.company_id = '" . $company . "' ";
                } else {
                    $query .= " OR salary_data.company_id = '" . $company . "' ";
                }
            }
            if ($is_employee == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " salary_data.employee_id = '" . $employee . "' ";
                } else {
                    $query .= " OR salary_data.employee_id = '" . $employee . "' ";
                }
            }
            if ($is_year_month == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " salary_data.salary_year = '" . $year . "' AND salary_data.salary_month = '" . $month . "'";
                } else {
                    $query .= " OR salary_data.salary_year = '" . $year . "' AND salary_data.salary_month = '" . $month . "'";
                }
            }

            $salary_data = DB::select($query);
            $responseBody = $this->responseBody(true, "SalaryData", "all", $salary_data);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryData", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
