
const NARATION_MAP = {
    1: 0,
    2: 0,
    3: 1
};

$(document).ready(function () {

    $('#tblAllowance').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "earn_deduct_id" },
            { "data": "type" },
            { "data": "title" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 120, targets: 0 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
            { width: 50, targets: 5 }
        ],
    });
    allAllowance();
});



function showModal() {
    resetAllowance();
    naration(1, null);
    $('#allowanceAddModal').modal('toggle');
}

function hideModal() {
    $('#allowanceAddModal').modal('hide');
}

function resetAllowance() {
    $('#allowanceForm').trigger("reset");
    $('#btnAction').show();
    $('#btnAction').text('Save');
}

function actionBtn() {

    var text = $('#btnAction').text();
    if (text == "Save") {
        save();
    } else if (text == "Update") {
        update();
    }
}




function naration(type, selected) {

    var naration_type = NARATION_MAP[type];

    $.ajax({
        type: "GET",
        url: "/hr/OtherEarningDeduction/narations/" + naration_type,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                $('#selcNaration').empty();
                var result = response.data.result;
                for (i = 0; i < result.length; i++) {
                    $('#selcNaration').append('<option value="' + result[i].id + '">' + result[i].value + '</option>')
                }
            } else {
                showErrorMessage();
            }

            if (selected != null) {
                setSelectedOption('selcNaration', selected);
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}


/**
* save
* This function is used to save employee salary.
*/
function save() {


    var epf = 0;
    if ($('#checkEPF').is(":checked")) {
        epf = 1;
    }
    var form = $('#allowanceForm').get(0);
    var data = new FormData(form);
    data.append('epf', epf);


    $.ajax({
        type: "POST",
        url: "/hr/OtherEarningDeduction",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success == true) {
                showSuccessMessage("Allowance has been saved successfully...");
                hideModal();
                allAllowance();
            } else {
                showErrorMessage();

            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





function allAllowance() {

    $.ajax({
        type: "GET",
        url: "/hr/OtherEarningDeduction/allAllowance",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['earn_deduct_id'];
                    var string_id = "'" + id + "'";

                    var type_id = response.data.result[i]['type'];
                    var title = response.data.result[i]['title'];
                    var type = "Allowance";
                    if (type_id == 1) {
                        type = "Allowance";
                    } else if (type_id == 2) {
                        type = "Incentive";
                    } else if (type_id == 3) {
                        type = "Deduction";
                    }



                    data.push({
                        "earn_deduct_id": generateID(id),
                        "type": type,
                        "title": title,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>'
                    });
                }

                var table = $('#tblAllowance').DataTable();
                table.clear();
                table.rows.add(data).draw();
                table.columns('.edit').visible(false);
                table.columns('.view').visible(false);
                table.columns('.delete').visible(false);



                if (edit_permission == 1) {
                    table.columns('.edit').visible(true);
                }

                if (view_permission == 1) {
                    table.columns('.view').visible(true);
                }

                if (delete_permission == 1) {
                    table.columns('.delete').visible(true);
                }




            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



var update_id = 0;
function edit(id) {
    $.ajax({
        type: "GET",
        url: '/hr/OtherEarningDeduction/allowance/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showModal();
                naration(response.data.result.type, response.data.result.item_id);
                $('#txtTitle').val(response.data.result.title);
                update_id = response.data.result.earn_deduct_id;
                setSelectedOption('selcType', response.data.result.type);
                setSelectedOption('selcCalculate', response.data.result.calcualte);
                $('#txtFormula').val(response.data.result.formula);
                if (response.data.result.epf == 1) {
                    $('#checkEPF').prop("checked", true);
                } else {
                    $('#checkEPF').prop("checked", false);
                }

                $('#btnAction').text('Update');


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



function update() {
    var epf = 0;
    if ($('#checkEPF').is(":checked")) {
        epf = 1;
    }
    $.ajax({
        type: 'PUT',
        url: '/hr/OtherEarningDeduction/update/' + update_id,
        data: $('#allowanceForm').serialize() + '&' + $.param({ "epf": epf }, true),
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Allowance has been updated successfully...");
                hideModal();
                resetAllowance();
                allAllowance();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error.message);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function view(id) {
    $.ajax({
        type: "GET",
        url: '/hr/OtherEarningDeduction/allowance/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showModal();
                setSelectedOption('selcType', response.data.result.type);
                $('#txtTitle').val(response.data.result.title);
                setSelectedOption('selcNaration', response.data.result.item_id);
                setSelectedOption('selcCalculate', response.data.result.calcualte);
                $('#txtFormula').val(response.data.result.formula);
                if (response.data.result.epf == 1) {
                    $('#checkEPF').prop("checked", true);
                } else {
                    $('#checkEPF').prop("checked", false);
                }

                $('#btnAction').hide();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}

function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/hr/OtherEarningDeduction/delete/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Allowance has been deleted successfully...");
                allAllowance();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "000",
        2: "00",
        3: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}

