
/**
 * java script -salartSheet
 *
 * @author  Sampath Perera
 * @since   2020-12-25
 */

var loan_id = null;

loadEmployee_ID();
loadEmployee_Name();
appendYear();
appendMonth();
setDeduct_current_year_month();
edit_and_view();

$(document).ready(function () {
    /**
    * datepicker
    * This is jquery foe datepicker .
    */
    $('input[name="txtTranDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });
    var date = new Date();
    $("#txtTranDate").val(date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate());




    
    $('#btnAction').click(function () {

        var event = $('#btnAction').text();
        if (event == "Save") {
            save();
        }else if(event == "Update"){
            update();
        }
    });

});




/**
* loadEmployee_ID
* This function is used to load allemplyee id 
*/
function loadEmployee_ID() {


    $.ajax({
        type: "GET",
        url: '/hr/debtorLoan/allEmployeeId',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp1").setData(response.data.result);


            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





/**
* loadEmployee_Name
* This function is used to load allemplyee name 
*/
function loadEmployee_Name() {


    $.ajax({
        type: "GET",
        url: '/hr/debtorLoan/allEmployeeName',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp2").setData(response.data.result);
                //$("#auto-comp3").setData(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





function appendYear() {

    var date = new Date();
    var year = date.getFullYear();

    $('#selcDeductYear').empty();
    //$('#selcYear').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 2015; i <= year; i++) {
        $('#selcDeductYear').append('<option value="' + i + '">' + i + '</option>');
    }

}


function appendMonth() {
    var month = {
        1: "January",
        2: "February",
        3: "March",
        4: "April",
        5: "May",
        6: "June",
        7: "July",
        8: "August",
        9: "September",
        10: "October",
        11: "November",
        12: "December",
    };


    $('#selcDeductMonth').empty();
    //$('#selcMonth').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 1; i <= 12; i++) {
        $('#selcDeductMonth').append('<option value="' + i + '">' + month[i] + '</option>');
    }


}




function setDeduct_current_year_month() {

    var date = new Date();
    var year = date.getFullYear();
    var mon = date.getMonth() + 1;

    let month_element = document.getElementById('selcDeductMonth');
    month_element.value = mon;

    let year_element = document.getElementById('selcDeductYear');
    year_element.value = year;


}



function loadEmployee(employee_id) {

    $.ajax({
        type: "GET",
        url: '/hr/debtorLoan/employee/' + employee_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var employee = response.data.result;
                $('#imgEmployee').attr("src", employee.photo_parth);
                $('#employee_id').val(employee.employee_id);
                $('#auto-comp1').val(employee.employee_id);
                $('#auto-comp2').val(employee.name_withinitial);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}




function edit_and_view() {

    if (window.location.search.length > 0) {
        $('#btnReset').show();
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('&');

        if (param.length == 2) {
            if (param[1] != "view") {
                location.href = "/hr/debtorLoanList";
            }
            $('#btnAction').hide();
            $('#btnDelete').hide();
        } else {
            $('#btnAction').show();
        }

        var id = param[0];
        loan_id = id;
        loadLoanFromList(id);
    } else {
        $('#btnReset').hide();
        $('#btnDelete').hide();
        $('#btnAction').show();
    }
}





function save() {

    var form = $('#loanForm').get(0);
    var data = new FormData(form);

    $.ajax({
        type: "POST",
        url: "/hr/debtorLoan",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Loan has been saved successfully...");
                resetLoan();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });


}






function update() {

    if (loan_id != null) {
        $.ajax({
            type: 'PUT',
            url: '/hr/debtorLoan/update/' + loan_id,
            data: $('#loanForm').serialize(),
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);

                if (response.data.success) {
                    showSuccessMessage("Loan has been updated successfully...");
                    loan_id = null;
                    location.href = "/hr/debtorLoanList";
                } else {
                    showErrorMessage();
                }

            },
            error: function (error) {
                console.log(error.message);
                showErrorMessage();
            },
            complete: function () {

            }

        });
    }
}





function _delete() {

    swal({
        title: "Are you sure?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
        .then((willDelete) => {
            if (willDelete) {
                do_delete();
            }
        });
}





function do_delete() {

    if (loan_id != null) {
        $.ajax({
            type: 'DELETE',
            url: '/hr/debtorLoan/deleteLoanFromID/' + loan_id,
            data: {
                _token: $('input[name=_token]').val()
            },
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);
                if (response.data.success) {
                    showSuccessMessage("Loan has been deleted successfully...");
                    location.href = "/hr/debtorLoanList";

                } else {
                    showErrorMessage();
                }
            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }

        });
    }

}







function loadLoanFromList(id) {

    $.ajax({
        type: "GET",
        url: '/hr/debtorLoan/loanFromList/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var loan = response.data.result;
                var employee = loan.employee;
                $('#imgEmployee').attr("src", employee.photo_parth);
                $('#employee_id').val(employee.employee_id);
                $('#auto-comp1').val(employee.employee_id);
                $('#auto-comp2').val(employee.name_withinitial);

                var amount = parseFloat(loan.amount);
                $('#txtAmount').val(amount.toFixed(2));

                var no_of_terms = parseFloat(loan.no_of_terms);
                $('#txtNoOfTearms').val(no_of_terms.toFixed(2));

                var interest = parseFloat(loan.interest_percentage);
                $('#txtInterest').val(interest.toFixed(2));

                $('#txtTranDate').val(loan.tran_date);
                setSelectedOption('selcDeductYear', loan.deduct_year);
                setSelectedOption('selcDeductMonth', loan.deduct_month);

                $('#txtReason').val(loan.reason);
                $('#btnAction').text('Update');

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function resetLoan() {
    $('#loanForm').trigger("reset");
    $('#btnReset').hide();
    $('#btnDelete').hide();
    $('#btnAction').text("Save");
    $('#btnAction').show();
    $("#imgEmployee").attr("src", "/images/employee.jpg");
    var date = new Date();
    $("#txtTranDate").val(date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate());
    setSelectedOption('selcDeductYear',date.getFullYear());
    setSelectedOption('selcDeductMonth',date.getMonth() + 1);
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
    $('#' + id).trigger('change');
}



//This function is override from autocomplete.min.js
function autoCompleteSelectedOption(input, data) {

    loadEmployee(data.id);

}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
