var DAY_COUNT = 0;
$(document).ready(function () {
    $('#tblLeave').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "leave_type" },
            { "data": "allocated" },
            { "data": "used" },
            { "data": "unlimited" },
            { "data": "balance" },
        ],

    });






    $('#btnResetLeave').hide();

    /**
        * datepicker
        * This is jquery foe datepicker .
        */

    $('input[name="dteFrom"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="dteFrom"]').on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
        setDayCount($('#dteFrom').val(), $('#dteTo').val());

    });


    $('input[name="dteTo"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="dteTo"]').on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
        setDayCount($('#dteFrom').val(), $('#dteTo').val());

    });

    $('input[name="dteDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    }).on('apply.daterangepicker', function (ev, picker) {



        $('#dteFrom').val($('#dteDate').val());
        $('#dteFrom').daterangepicker({
            singleDatePicker: true,
            minDate: new Date($('#dteDate').val()),
            locale: {
                format: 'YYYY-MM-DD'
            }
        });
        $('input[name="dteFrom"]').on('apply.daterangepicker', function (ev, picker) {
            $(this).val(picker.startDate.format('YYYY-MM-DD'));
            setDayCount($('#dteFrom').val(), $('#dteTo').val());

        });

        $('#dteTo').val($('#dteDate').val());
        $('#dteTo').daterangepicker({
            singleDatePicker: true,
            minDate: new Date($('#dteDate').val()),
            locale: {
                format: 'YYYY-MM-DD'
            }
        });
        $('input[name="dteTo"]').on('apply.daterangepicker', function (ev, picker) {
            $(this).val(picker.startDate.format('YYYY-MM-DD'));
            setDayCount($('#dteFrom').val(), $('#dteTo').val());

        });


        $(this).val(picker.startDate.format('YYYY-MM-DD'));
        var year = $('#dteDate').val().split("-")[0];
        var id = $('#txtEmployeeID').optionID();
        if (id != '') {
            getEmployeeLeaveData(year, id);
        }
    });





    let today = new Date().toISOString().substr(0, 10);
    document.querySelector("#dteDate").value = today;
    document.querySelector("#dteFrom").value = today;
    document.querySelector("#dteTo").value = today;

    //Toast library for message
    toastr.options = {
        timeOut: 3000,
        progressBar: true,
        showMethod: "slideDown",
        hideMethod: "slideUp",
        showDuration: 200,
        hideDuration: 200
    };
    ////////////

    allSettings();//when call this function, all settings auto load

    /**
        * Save Leave
        * This function is used to save leave data.
        */
    $('#btnSaveLeave').click(function (event) {
        event.preventDefault();
        var form = $('#leaveForm').get(0);
        var data = new FormData(form);
        data.append('approved_by', user_id);

        if ($('#btnSaveLeave').text() == "Save") {
            save(data);
        } else if ($('#btnSaveLeave').text() == "Update") {
            //var id = $('#hidUserID').val();
            update2(data);
        }


    });


    /**
        * resetLeave
        * This function is used to reset form.
        */
    $('#btnResetLeave').click(function (event) {
        event.preventDefault();
        resetLeave();
    });


    //Ajax call for Auto complete Employee Name Field.
    $.ajax({
        type: 'GET',
        url: '/hr/leave/searchName',
        success: function (response) {
            if (response) {
                $("#txtEmpName").setData(response);
            } else {
                showErrorMessage();
            }
        },
        error: function (data) {
            console.log(error);
            showErrorMessage();
        }

        ,
        complete: function () {

        }
    });



    $.ajax({
        type: 'GET',
        url: '/hr/leave/allEmployeeID',
        success: function (response) {
            if (response) {
                $("#txtEmployeeID").setData(response);
            } else {
                showErrorMessage();
            }
        },
        error: function (data) {
            console.log(error);
            showErrorMessage();
        }

        ,
        complete: function () {

        }
    });

    loadLeave();


    $('#txtDayCount').on('input', function () {
        isValiedDayCount();
    });


    setDayCount($('#dteFrom').val(), $('#dteTo').val());

});


function getEmployee(id) {
    $.ajax({
        type: 'GET',
        url: '/hr/leave/employee/' + id,
        success: function (response) {
            if (response) {
                $("#txtEmployeeID").attr("data-id", response.employee_id);
                $("#txtEmpName").attr("data-id", response.employee_id);
                $("#txtEmployeeID").val(response.employee_id);
                $("#txtEmpName").val(response.name_withinitial);

                /*$('#dteDate').daterangepicker({
                    singleDatePicker: true,
                    minDate: new Date(response.date_join),
                    locale: {
                        format: 'YYYY-MM-DD'
                    }
                });
                $('#dteFrom').daterangepicker({
                    singleDatePicker: true,
                    minDate: new Date(response.date_join),
                    locale: {
                        format: 'YYYY-MM-DD'
                    }
                });
                $('#dteTo').daterangepicker({
                    singleDatePicker: true,
                    minDate: new Date(response.date_join),
                    locale: {
                        format: 'YYYY-MM-DD'
                    }
                });*/
            } else {
                showErrorMessage();
            }
        },
        error: function (data) {
            console.log(error);
            showErrorMessage();
        }

        ,
        complete: function () {

        }
    });
}


/**
* loadLeave
* This function used to load leave details and settings, in update and view time
*/
function loadLeave() {

    if (window.location.search.length > 0) {
        $('#btnResetLeave').show();
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('&');

        if (param.length == 2) {
            $('#btnSaveLeave').hide();
        } else {
            $('#btnSaveLeave').show();
        }

        var id = param[0];
        $('#hidUserID').val(id);
        $.ajax({
            type: "GET",
            url: "/hr/leave/leave/" + id,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);
                var employee_id = response.data.result['leave']['employee_id'];
                var employee_name = response.data.result['leave']['employee_name'];
                var date = response.data.result['leave']['date'];
                var from = response.data.result['leave']['from'];
                var to = response.data.result['leave']['to'];
                var reason = response.data.result['leave']['reason'];
                var leave_type = response.data.result['settings']['leave_type'];


                $('#txtEmployeeID').val(employee_id);
                $('#txtEmpName').val(employee_name);
                $('#dteDate').val(date);
                $('#dteFrom').val(from);
                $('#dteTo').val(to);
                $('#txtReason').val(reason);


                $("#selcType option").filter(function () {
                    return $(this).text() == leave_type;
                }).prop('selected', true);

                $('#btnSaveLeave').text('Update');

            },
            error: function (error) {
                console.log(error);

            },
            complete: function () {

            }

        });
    }


}




/**
* save
* This function is used to save leaveEmployee.
* @param dara This is the paramter to ajax data
*/
function save(data) {

    var leave_type = $('#selcType').val();
    var employee_id = $('#txtEmpName').optionID();
    var year = $('#dteDate').val().split("-")[0];

    if (employee_id == '') {
        showWarningMessage("Please select employee");
        return;
    }
    if (leave_type == null) {
        showWarningMessage("Please select leave type");
        return;
    }

    if ($('#txtDayCount').val().trim() == '') {
        showWarningMessage("Invalied Day count");
        return;
    }

    if (!isValiedDayCount()) {
        showWarningMessage("Invalied Day count");
        return;
    }


    //var LEAVE_DAY_COUNT = leaveCount(employee_id, leave_type, year);
    var EMPLOYEE_LEAVE_DAY_COUNT = employeeLeaveCount(employee_id, year, leave_type);

    if (leave_type == 6) {
        if (!(EMPLOYEE_LEAVE_DAY_COUNT >= 0.5)) {
            showWarningMessage('Leave not available...!');
            return;
        }
    }/* else if (leave_type != 6) {
        if (!(EMPLOYEE_LEAVE_DAY_COUNT >= 1)) {
            showWarningMessage('Leave not available...!');
            return;
        }
    }*/



    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: '/hr/leave',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Leave details have been saved successfully...");
                var year = $('#dteDate').val().split("-")[0];
                getEmployeeLeaveData(year, employee_id);
                //resetLeave();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}





function setDayCount(dateFrom, dateTo) {
    $.ajax({
        type: 'GET',
        url: '/hr/leave/getDayCount/' + dateFrom + "/" + dateTo,
        async: false,
        success: function (response) {
            DAY_COUNT = response.data;
            $('#txtDayCount').val(DAY_COUNT);
            isValiedDayCount();
        },
        error: function (data) {
            console.log(error);
        }

        ,
        complete: function () {

        }
    });
}


function isValiedDayCount() {
    var bool = true;
    if (DAY_COUNT <= 0) {
        $('#txtDayCount').css('background-color', 'red');
        bool = false;
    } else if (DAY_COUNT < parseFloat($('#txtDayCount').val())) {
        $('#txtDayCount').css('background-color', 'red');
        bool = false;
    } else {
        $('#txtDayCount').css('background-color', 'white');
        bool = true;
    }
    return bool
}

/**
* allSettings
* This function is used to load all settings.
*/
function allSettings() {
    $.ajax({
        type: "GET",
        url: "/hr/leave/settings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var result = response.data.result;
                appendSettings(result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}

/**
* appendSettings
* This function is used append option to combobox.
* @param collection This is the paramter to combobox elements item
*/
function appendSettings(collection) {

    $('#selcType').append(' <option value="" disabled selected>Select Leave Type</option>');
    $.each(collection['LeaveType'], function (index, value) {
        $('#selcType').append('<option value="' + value['leave_type_id'] + '">' + value['leave_type'] + '</option>');
    });


}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}

/**
* leaveType
* This function is used to select the leave Type.
*/
function leaveType() {
    var leave_type_id = $('#selcType').val();
    $.ajax({
        type: "GET",
        url: "/hr/leave/type/" + leave_type_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
        }
    });
}

/**
* getEmpName
* Function for Auto Complete to fill other fields by enter the Name Field.
*/
function getEmpName() {
    $.ajax({
        type: 'GET',
        url: '/hr/leave/getName/' + $('#txtEmpName').optionID(),
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response) {
                $('#txtEmployeeID').val(response.employee_id);

            } else {
                showErrorMessage();
            }
        },
        error: function (data) {
            showErrorMessage();
            console.log(data);
        },
        complete: function () {
        }
    });
}


/**
* update
* This function is used to update leave.
* @param data This is the paramter to ajax data
*/
function update2(data) {

    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: '/hr/leave/update',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Leave record has been updated successfully...");

            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            location.href = "/hr/leave_list";
        }

    });
}


/**
* resetEmployee
* This function is used to reset form.
*/
function resetLeave() {
    $('#leaveForm').trigger("reset");
    $('#dteDate').daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        locale: {
            format: 'YYYY-MM-DD'
        }
    });
    $('#btnResetLeave').hide();
    $('#btnSaveLeave').text('Save');
    $("#imgEmployee").attr("src", "/images/employee.jpg");
    $("#pills-general-tab").click();
    $('#btnSaveLeave').show();
}

testName();
function testName() {
    var data2 = [];
    for (x = 0; x < 1000; x++) {
        data2.push({
            "img": "",
            "id": x,
            "value": "B-" + x
        });
    }
    $("#txtEmpName").setData(data2);
}


function autoCompleteSelectedOption(input, data) {
    getEmployee(data.id);
    var year = $('#dteDate').val().split("-")[0];
    getEmployeeLeaveData(year, data.id);
}




function getEmployeeLeaveData(year, id) {

    $.ajax({
        type: "GET",
        url: "/hr/leave/employeeLeaveData/" + year + "/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var leave_type = response.data.result[i]['leave_type'];
                    var allocated = response.data.result[i]['allocated'];
                    var used = response.data.result[i]['used'];
                    var unlimited = response.data.result[i]['unlimited'];
                    var balance = response.data.result[i]['balance'];



                    data.push({
                        "leave_type": leave_type,
                        "allocated": allocated,
                        "used": used,
                        "unlimited": unlimited,
                        "balance": balance,

                    });
                }

                var table = $('#tblLeave').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



function leaveCount(employee_id, leaveType, year) {
    var leaveCount = 0;
    $.ajax({
        type: "GET",
        url: "/hr/leave/leaveCount/" + employee_id + "/" + leaveType + "/" + year,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                leaveCount = response.data.result;
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
    return leaveCount;
}




function employeeLeaveCount(employee_id, year, leaveType) {
    if (leaveType == 6) {
        leaveType = 1;
    }
    var leaveCount = 0;
    $.ajax({
        type: "GET",
        url: "/hr/leave/employeeLeaveCount/" + employee_id + "/" + year + "/" + leaveType,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                leaveCount = response.data.result[0].balance;
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
    return leaveCount;
}


