
var option = "export";

$(document).ready(function () {

    var data = {
        _token: $('input[name=_token]').val(),
        "is_category": false,
        "category": 0,
        "is_site": false,
        "site": 0,
        "is_department": false,
        "department": 0,
        "is_section": false,
        "section": 0,
        "is_subsection": false,
        "subsection": 0,
        "is_company": false,
        "company": 0,

    };

    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('&');

        var setting_name = param[0];
        for (i = 0; i < param.length; i++) {
            var param_arr = param[i].split(',');
            var setting = param_arr[0].split('=');
            var val = param_arr[1];

            if (setting[0] == "is_category") {
                if (setting[1] == "true") {
                    data.is_category = true;
                    data.category = val;
                }

            } else if (setting[0] == "is_site") {
                if (setting[1] == "true") {
                    data.is_site = true;
                    data.site = val;
                }

            } else if (setting[0] == "is_department") {
                if (setting[1] == "true") {
                    data.is_department = true;
                    data.department = val;
                }

            } else if (setting[0] == "is_section") {
                if (setting[1] == "true") {
                    data.is_section = true;
                    data.section = val;
                }

            } else if (setting[0] == "is_subsection") {
                if (setting[1] == "true") {
                    data.is_subsection = true;
                    data.subsection = val;
                }
            } else if (setting[0] == "is_company") {
                if (setting[1] == "true") {
                    data.is_company = true;
                    data.company = val;
                }
            }

            if(setting[0] == "export"){
                option = "export";
            }else if(setting[0] == "print"){
                option = "print";
            }
        }

        console.log(data);
        search(data);
    }
});





function search(data) {

    $.ajax({
        type: "GET",
        url: '/hr/reportEmployeeList/search',
        data: data,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                appendTableRow(response.data.result);
            }


        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {
            if(option == "print"){
              window.print();  
            }else if(option == "export"){
                ExportExcel('xlsx');
            }
            
        }

    });
}





function ExportExcel(type, fn, dl) {
    var elt = document.getElementById('tblEmployee');
    var wb = XLSX.utils.table_to_book(elt, {sheet:"Sheet JS"});
    return dl ?
       XLSX.write(wb, {bookType:type, bookSST:true, type: 'base64'}) :
       XLSX.writeFile(wb, fn || ('employeeList.' + (type || 'xlsx')));
 }
 
 




function appendTableRow(result) {

    for(i = 0; i < result.length; i++){
        var row = '<tr>';
        row+='<td>'+result[i].employee_id+'</td>';
        row+='<td>'+result[i].name_withinitial+'</td>';
        row+='<td>'+result[i].name_full+'</td>';
        row+='<td>'+result[i].address+'</td>';
        row+='<td>'+result[i].bank_account+'</td>';
        row+='<td>'+result[i].town+'</td>';
        row+='<td>'+result[i].passport+'</td>';
        row+='<td>'+result[i].birthday+'</td>';
        if(result[i].gender_id == 0){
           row+='<td>Female</td>'; 
        }else{
            row+='<td>Male</td>';  
        }
        
        row+='<td>'+result[i].designation+'</td>';
        row+='<td>'+result[i].nic+'</td>';
        row+='<td>'+result[i].drvl+'</td>';
        row+='<td>'+result[i].date_join+'</td>';
        row+='<td>'+result[i].civilstatus+'</td>';
        row+='<td>'+result[i].email+'</td>';
        row+='<td>'+result[i].fixed+'</td>';
        row+='<td>'+result[i].mobile+'</td>';
        row+='<td>'+result[i].gmap+'</td>';
        row+='<td>'+result[i].emegency_contact+'</td>';
        row+='<td>'+result[i].emegency_contactno1+'</td>';
        row+='<td>'+result[i].emegency_contactno2+'</td>';
        row+='<td>'+result[i].attendance_id+'</td>';
        row+='<td>'+result[i].epf_no+'</td>';
        row+='<td>'+result[i].employeestatus+'</td>';
        row+='<td>'+result[i].category+'</td>';
        row+='<td>'+result[i].site+'</td>';
        row+='<td>'+result[i].department+'</td>';
        row+='<td>'+result[i].section+'</td>';
        row+='<td>'+result[i].subsection+'</td>';
        row+='<td>'+result[i].supervisor_id+'</td>';
        row+= '<tr>';
        $('#body-content').append(row);
    }
}
