
var setting_array = {
    "category": null,
    "site": null,
    "department": null,
    "section": null,
    "subsection": null,
    "company": null,
    "team": null,
    "employee": null,
};

var REPORT_ID = 0;

$(document).ready(function () {
    allSettings();
    $('#divDate2').hide();
    $('#selcCategory').prop("disabled", true);
    $('#selcSite').prop("disabled", true);
    $('#selcDepartment').prop("disabled", true);
    $('#selcSection').prop("disabled", true);
    $('#selcSubsection').prop("disabled", true);
    $('#selcCompany').prop("disabled", true);
    $('#selcTeam').prop("disabled", true);
    $('#employee-autocomplete').prop("disabled", true);

    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="startDate"]').on('apply.daterangepicker', function (ev, picker) {
        setDateRangeToDatePicker('endDate', picker.startDate.format('YYYY MM D'));

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    setDateRangeToDatePicker('endDate', $('input[name="startDate"]').val());




    $('#checkCategorySearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcCategory').prop("disabled", false);
            setting_array.category = $('#selcCategory').val();
        } else {
            $('#selcCategory').prop("disabled", true);
            setting_array.category = null;
        }
        //switch_settings('checkCategorySearch');
        console.log(setting_array);
    });



    $('#checkSiteSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSite').prop("disabled", false);
            setting_array.site = $('#selcSite').val();
        } else {
            $('#selcSite').prop("disabled", true);
            setting_array.site = null;
        }
        //switch_settings('checkSiteSearch');
    });


    $('#checkDepartmentSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcDepartment').prop("disabled", false);
            setting_array.department = $('#selcDepartment').val();
        } else {
            $('#selcDepartment').prop("disabled", true);
            setting_array.department = null;
        }
        //switch_settings('checkDepartmentSearch');
    });


    $('#checkSectionSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSection').prop("disabled", false);
            var value = $('#selcSection').val();
            setting_array.section = $('#selcSection').val();
            allSubsection(value);
        } else {
            $('#selcSection').prop("disabled", true);
            setting_array.section = null;
            setting_array.subsection = null;
            $('#selcSubsection').empty();
            $('#checkSubsectionSearch').prop('checked', false);
        }
        //switch_settings('checkSectionSearch');
    });


    $('#checkSubsectionSearch').change(function () {
        var sectionbool = $('#checkSectionSearch').is(":checked");
        if (!sectionbool) {
            $('#checkSubsectionSearch').prop('checked', false);
            showWarningMessage('Please select section');
            return;
        }
        var subsectionbool = $(this).is(":checked");
        if (subsectionbool) {
            $('#selcSubsection').prop("disabled", false);
            setting_array.subsection = $('#selcSubsection').val();
        } else {
            $('#selcSubsection').prop("disabled", true);
            setting_array.subsection = null;
        }
        //switch_settings('checkSubsectionSearch');
    });


    $('#checkCompanySearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcCompany').prop("disabled", false);
            setting_array.company = $('#selcCompany').val();
        } else {
            $('#selcCompany').prop("disabled", true);
            setting_array.company = null;
        }
        //switch_settings('checkCompanySearch');
    });


    $('#checkTeamSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcTeam').prop("disabled", false);
            setting_array.team = $('#selcTeam').val();
        } else {
            $('#selcTeam').prop("disabled", true);
            setting_array.team = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkEmployeeSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#employee-autocomplete').prop("disabled", false);
            setting_array.employee = $('#employee-autocomplete').optionID();
        } else {
            $('#employee-autocomplete').prop("disabled", true);
            setting_array.employee = null;
        }
        //switch_settings('checkEmployeeSearch');
    });

    $('#selcCategory').change(function () {
        setting_array.category = $('#selcCategory').val();
    });

    $('#selcSite').change(function () {
        setting_array.site = $('#selcSite').val();
    });

    $('#selcDepartment').change(function () {
        setting_array.department = $('#selcDepartment').val();
    });

    $('#selcSection').change(function () {
        var value = $('#selcSection').val();
        setting_array.section = value;
        allSubsection(value);
    });

    $('#selcSubsection').change(function () {
        setting_array.subsection = $('#selcSubsection').val();
    });

    $('#selcCompany').change(function () {
        setting_array.company = $('#selcCompany').val();
    });

    $('#selcTeam').change(function () {
        setting_array.team = $('#selcTeam').val();
    });

    $('#employee-autocomplete').change(function () {
        setting_array.employee = $('#employee-autocomplete').optionID();
    });

    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        $('#lblEmployee').text('Employee');
        if (REPORT_ID == 1) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 2) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 3) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 4) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 5) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 6) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 7) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 8) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 11) {
            showDate('SINGLE_DATE');
            $('#lblEmployee').text('Supervisor');
        } else {
            showDate('DATE_RANGE');
        }
    });


});





function allSettings() {

    $.ajax({
        type: "GET",
        url: "/hr/employeeAttendanceReport/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOption("selcCategory", settings.category);
                appendOption("selcSite", settings.site);
                appendOption("selcDepartment", settings.department);
                appendOption("selcSection", settings.section);
                appendOption("selcCompany", settings.company);
                appendOption("selcTeam", settings.team);
                $('#employee-autocomplete').setData(settings.employee);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}





function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}







function allSubsection(section_id) {


    $.ajax({
        type: "GET",
        url: "/hr/employeeAttendanceReport/subSection/" + section_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                appendOption("selcSubsection", response.data.result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function settings() {

    return "category=" + setting_array.category + "&"
        + "site=" + setting_array.site + "&"
        + "department=" + setting_array.department + "&"
        + "section=" + setting_array.section + "&"
        + "subsection=" + setting_array.subsection + "&"
        + "company=" + setting_array.company + "&"
        + "employee=" + setting_array.employee;
}


function createReport(flag) {

    if (setting_array.category == null && setting_array.site == null && setting_array.department == null && setting_array.section == null && setting_array.subsection == null && setting_array.company == null && setting_array.team == null && setting_array.employee == null) {
        showWarningMessage("Please select setting");
        return;
    }

    var employee_id = $('#employee-autocomplete').optionID();
    if (setting_array.employee != null && employee_id == "") {
        showWarningMessage("Please select employee");
        return;
    }


    var company = $('#selcCompany').val();
    if (setting_array.company == null || company == "disabled" || !$('#checkCompanySearch').is(':checked')) {
        showWarningMessage("Please select company");
        return;
    }


    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report title");
        return;
    }

    if (REPORT_ID == 11) {
        if ($('#employee-autocomplete').val() == "" || $('#employee-autocomplete').attr('data-id') == "" || !$('#checkEmployeeSearch').is(':checked')) {
            showWarningMessage("Please select supervisor");
            return;
        }
    }




    if (REPORT_ID == 1) {

        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/dailyAbsentReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                dailyAbsentReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    } else if (REPORT_ID == 2) {

        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/dailyPresentReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                dailyPresentReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    } else if (REPORT_ID == 3) {

        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/attendanceRegisterReport/" + JSON.stringify(setting_array) + "/" + $('#cmbYear').val() + "/" + $('#cmbMonth').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                attendanceRegisterReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 4) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/dailyMarkingSheetReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                dailyMarkingSheetReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 5) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/dailyHeadCountReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                dailyHeadCountReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 6) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/attendanceSummryReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                attendanceSummryReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 7) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/timeCardsReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                timeCardsReport2(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 8) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/dailyInvalidReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                dailyInvalidReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 9) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/leaveReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                leaveReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 10) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/attendanceReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                attendanceReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 11) {
        var id = $('#employee-autocomplete').optionID();
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/supervisorApprovalReport/" + id + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                supervisorAttendanceApprovalReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 12) {
        $.ajax({
            type: "GET",
            url: "/hr/employeeAttendanceReport/employeeMissingRosterReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                rosterMissingReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });
    }



}











function allEmployeeDetailsReport(result, flag) {

    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            /*logo: {
                path: '/images/logo.png',
                width: 200,
                height: 30,
                alignment: 'left',
            },*/
            content: [

                {
                    table: {
                        widths: ['*', '*', '*'],
                        headerRows: 1,
                        body: [
                            [{ text: '', border: [false, false, false, false] }, { text: 'Riococo Lanka Pvt Ltd', fontSize: 5, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 5, bold: true, alignment: 'right', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 6, border: [false, false, false, false] }, { text: "\n", fontSize: 6, bold: true, alignment: 'center', border: [false, false, false, false] }, { text: '\n', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                            [{ text: 'June 2021', fontSize: 4, border: [false, false, false, false] }, { text: "EMPLOYEE'S DETAIL REPORT", fontSize: 6, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                }
            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 30, 80, 80, 30, 40, 30, 30, 50, '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'],
                headerRows: 1,
                body: allEmployeeDetailsReportBody(result),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A3');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }


}




function allEmployeeDetailsReportBody(result) {

    var font_size = 3;
    var body = [];
    body.push([
        { text: 'Employee ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'EPF No', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Name', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Address', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Date Of Birth', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Gender', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Designation', fontSize: font_size, border: [true, true, true, true] },
        { text: 'NIC', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Date Of Joined', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Civil Status', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Fixed Phone NO', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Attendance ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Employee Status', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Category', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Site', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Department', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Team', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Supervisior', fontSize: font_size, border: [true, true, true, true] },
        { text: 'GS Division', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Police Divition', fontSize: font_size, border: [true, true, true, true] },
        { text: 'MOH', fontSize: font_size, border: [true, true, true, true] },

    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].epf_no, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].address, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].birthday, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].gender, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].designation, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].nic, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].date_join, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].civilstatus, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].fixed_mobile, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].attendance_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employeestatus, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].category, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].site, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].department, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].team_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].supervisor, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].division, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].police, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].moh, fontSize: font_size, border: [false, false, false, true] },

        ]);
    }
    return body;
}











function dailyAbsentReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Absent Report for ' + result.report_date, fontSize: 12, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', 60, '*', '*', '*', 60, 60, 30],
                headerRows: 1,
                body: dailyAbsentReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function dailyAbsentReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Date Of Joined', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Category', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Department', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Service', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Last Present Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Absent', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].date_join, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].category, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].department, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].team_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].service, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].last_present_date, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].absent, fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

        ]);
    }
    return body;
}






function dailyPresentReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Present Report for ' + result.report_date, fontSize: 12, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],
                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', '*', '*', 60, 50, 50, 30, 30, 30],
                headerRows: 1,
                body: dailyPresentReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function dailyPresentReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Shift', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'In Time', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Time', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Late(M)', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'OT', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    for (i = 0; i < result.length; i++) {


        var late_arriver = result[i].late_arriver;
        if (!late_arriver) {
            late_arriver = 0;
        }

        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].team_name, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].shift, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].in_time, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].out_time, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].out_date, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: parseFloat(late_arriver * 60.0).toFixed(0), fontSize: font_size, border: [false, false, false, true], alignment: "right" },
            { text: parseFloat(n_ot).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: "right" },
            { text: parseFloat(d_ot).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: "right" },


        ]);
    }
    return body;
}







function attendanceRegisterReport(result, flag) {

    var dayCount = daysInMonth(1, 2021);


    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Employee Attendance Register for ' + result.report_date[0]['year'] + " " + result.report_date[0]['month'], fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [15, 50, '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', 20, 20, 20, 20],
                headerRows: 1,
                body: attendanceRegisterReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function attendanceRegisterReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([
        { text: 'ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Employee Name', fontSize: font_size, border: [true, true, true, true] },
        { text: '1', fontSize: font_size, border: [true, true, true, true] },
        { text: '2', fontSize: font_size, border: [true, true, true, true] },
        { text: '3', fontSize: font_size, border: [true, true, true, true] },
        { text: '4', fontSize: font_size, border: [true, true, true, true] },
        { text: '5', fontSize: font_size, border: [true, true, true, true] },
        { text: '6', fontSize: font_size, border: [true, true, true, true] },
        { text: '7', fontSize: font_size, border: [true, true, true, true] },
        { text: '8', fontSize: font_size, border: [true, true, true, true] },
        { text: '9', fontSize: font_size, border: [true, true, true, true] },
        { text: '10', fontSize: font_size, border: [true, true, true, true], padding: 0 },
        { text: '11', fontSize: font_size, border: [true, true, true, true] },
        { text: '12', fontSize: font_size, border: [true, true, true, true] },
        { text: '13', fontSize: font_size, border: [true, true, true, true] },
        { text: '14', fontSize: font_size, border: [true, true, true, true] },
        { text: '15', fontSize: font_size, border: [true, true, true, true] },

        { text: '16', fontSize: font_size, border: [true, true, true, true] },
        { text: '17', fontSize: font_size, border: [true, true, true, true] },
        { text: '18', fontSize: font_size, border: [true, true, true, true] },
        { text: '19', fontSize: font_size, border: [true, true, true, true] },
        { text: '20', fontSize: font_size, border: [true, true, true, true] },
        { text: '21', fontSize: font_size, border: [true, true, true, true] },
        { text: '22', fontSize: font_size, border: [true, true, true, true] },
        { text: '23', fontSize: font_size, border: [true, true, true, true] },
        { text: '24', fontSize: font_size, border: [true, true, true, true] },
        { text: '25', fontSize: font_size, border: [true, true, true, true] },
        { text: '26', fontSize: font_size, border: [true, true, true, true] },
        { text: '27', fontSize: font_size, border: [true, true, true, true] },
        { text: '28', fontSize: font_size, border: [true, true, true, true] },
        { text: '29', fontSize: font_size, border: [true, true, true, true] },
        { text: '30', fontSize: font_size, border: [true, true, true, true] },
        { text: '31', fontSize: font_size, border: [true, true, true, true] },

        { text: 'Present Days', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Absent Days', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Leave Days', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Total', fontSize: font_size, border: [true, true, true, true] },


    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day1, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day2, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day3, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day4, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day5, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day6, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day7, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day8, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day9, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day10, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day11, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day12, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day13, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day14, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day15, fontSize: font_size, border: [true, true, true, true] },

            { text: result[i].day16, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day17, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day18, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day19, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day20, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day21, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day22, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day23, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day24, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day25, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day26, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day27, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day28, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day29, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day30, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day31, fontSize: font_size, border: [true, true, true, true] },

            { text: result[i].present_day, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].absent_day, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].leave_day, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].total_day, fontSize: font_size, border: [true, true, true, true] },


        ]);
    }
    return body;
}






function dailyMarkingSheetReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'DAILY MARKING SHEET for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{
                                table: {
                                    widths: [200, '*'],
                                    headerRows: 1,
                                    body: [
                                        [{ text: 'Total cadre : ' + result.summary[0]['total_carder'], fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Total Present : ' + result.summary[0]['present_carder'], fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Total Absent : ' + result.summary[0]['absent_carder'], fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Absent : ' + parseFloat(result.summary[0]['presentage']).toFixed(2) + '%', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                                    ],
                                }
                            }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, 130, 90, '*', '*', '*', '*', '*'],
                headerRows: 1,
                body: dailyMarkingSheetReportBody(result.body),

            },
        }
    ];




    var Footer = [

        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyMarkingSheetReportBody(result) {
    var font_size = 6;
    var body = [];

    body.push([
        { text: 'ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Shift', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'InTime', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'OutTime', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Late(M)', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'DOT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);
    for (i = 0; i < result.length; i++) {
        var late_arriver = result[i].late_arriver;
        if (!late_arriver) {
            late_arriver = 0;
        }

        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].shift, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].in_time, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].out_time, fontSize: font_size, border: [false, false, false, true] },
            { text: parseFloat(late_arriver * 60.0).toFixed(0), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: n_ot.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: d_ot.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },


        ]);
    }
    return body;
}






var total_carder_amount = 0;
var persent_carder_amount = 0;
var absent_carder_amount = 0;
var prsentage_carder_amount = 0;

function dailyHeadCountReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Head count Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [140, 135, '*', '*', '*', '*'],
                headerRows: 1,
                body: dailyHeadCountReportBody(result.body),

            },
        },
        {
            table: {
                widths: [140, 135, '*', '*', '*', '*'],
                headerRows: 1,
                body: [
                    [
                        { text: '', fontSize: 6, bold: true, alignment: 'right', border: [true, false, false, true] },
                        { text: 'Total', fontSize: 6, bold: true, alignment: 'right', border: [false, false, true, true] },
                        { text: total_carder_amount, fontSize: 6, bold: true, alignment: 'right', border: [true, false, true, true] },
                        { text: persent_carder_amount, fontSize: 6, bold: true, alignment: 'right', border: [true, false, true, true] },
                        { text: absent_carder_amount, fontSize: 6, bold: true, alignment: 'right', border: [true, false, true, true] },
                        { text: parseFloat(prsentage_carder_amount).toFixed(2)+'%', fontSize: 6, bold: true, alignment: 'right', border: [true, false, true, true] },
                    ],

                ],

            },
            margin: [0, 0],
        }
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyHeadCountReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([
        { text: 'Department', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Total Carder', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Present Carder', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Absent', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Absent Presentage', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);
    for (i = 0; i < result.length; i++) {
        var presentage = ((parseFloat(result[i].total_carder) - parseFloat(result[i].present_carder)) / parseFloat(result[i].total_carder)) * 100;
        if (!presentage) {
            presentage = 0;
        }

        total_carder_amount += parseFloat(result[i].total_carder);
        persent_carder_amount += parseFloat(result[i].present_carder);
        absent_carder_amount += (parseFloat(result[i].total_carder) - parseFloat(result[i].present_carder));
        prsentage_carder_amount = (absent_carder_amount / total_carder_amount) * 100.0;

        body.push([
            { text: result[i].department, fontSize: font_size, alignment: 'left', border: [true, true, true, true] },
            { text: result[i].designation, fontSize: font_size, alignment: 'left', border: [true, true, true, true] },
            { text: result[i].total_carder, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: result[i].present_carder, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: parseFloat(result[i].total_carder) - parseFloat(result[i].present_carder), fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: presentage.toFixed(2) + '%', fontSize: font_size, alignment: 'right', border: [true, true, true, true] },


        ]);
    }
    return body;
}



function basicSalaryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Basicsalary report', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

                {
                    table: {
                        widths: [30, 100, 98, 35, 35, 35, 35, 35, 30],
                        headerRows: 1,
                        body: [
                            [
                                { rowSpan: 2, text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { rowSpan: 2, text: 'Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { rowSpan: 2, text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { colSpan: 3, text: 'Basic', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }, '', '',
                                { colSpan: 2, text: 'Allowance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }, '',
                                { rowSpan: 2, text: 'Total Day Salary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }
                            ],
                            [
                                '',
                                '',
                                '',
                                { text: 'Basicsalary', fontSize: 6, rowspan: 2, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'BR1', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'BR2', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Travalling Allowance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Production Incentive', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Total Day Salary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }
                            ],



                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [

        {
            table: {
                widths: [30, 100, 98, 35, 35, 35, 35, 35, 30],
                headerRows: 0,
                body: basicSalaryReportBody(result.body),

            },
            /*layout: {
                hLineStyle: function (i, node) {
                    return { dash: { length: 1, space: 2 } };
                },
                hLineWidth: function (i, node) {
                    return 0.2;
                },



            },*/
            margin: [0, 0],
        },

    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function basicSalaryReportBody(result) {
    var font_size = 6;
    var body = [];
    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].br1, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].br2, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].travalling_allowance, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].production_incentive, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].total_day_salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}



function resignEmployeeDetailsReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Resign Employee Report', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, 30, 110, 140, 40, 110, 110, 110, 40, 40, 40, 40, 40, 40, '*'],
                headerRows: 1,
                body:
                    resignEmployeeDetailsReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A3');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function resignEmployeeDetailsReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'EPF No', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Address', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Mobile No', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Department', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Section', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'DOB', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Gender', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'NIC', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Register Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Resign Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Service', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Basicsalary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].epf_no, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].address, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].mobile, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].department, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].section, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].dob, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].gender, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].nic, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].date_join, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].resign_date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].service, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}







function attendanceSummryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Attendance Data - Summary ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0], 
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [35, 90, 30,30, 20, 20, 20,25,25,30,25, '*'],
                headerRows: 1,
                body: attendanceSummryReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function attendanceSummryReportBody(result) { 
    var font_size = 6;
  
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Working Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Working Days (Wthout Holiday)', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Poya OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Late(M)', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Early Departure(M)', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Hours(12)', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Hours(8)', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Signature', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        var late = parseFloat(result[i].late);
        if(isNaN(late)){
            late = 0;
        }
        var early = parseFloat(result[i].early);
        if(isNaN(early)){
            early = 0;
        }
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].worked_day, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].without_holyday, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].poya_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: parseFloat(late * 60.0).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: parseFloat(early * 60.0).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: parseFloat(result[i].hours_12).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: parseFloat(result[i].hours_8).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: '', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}



function timeCardsReport2(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Employee Time Card', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                        ],

                    },
                    margin: [0, 0],
                },
            ]
        }
    ];

    var Body = timeCardsReportBody2(result.body, result.title);



    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];




    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export2();
    } else if (flag == 'PRINT') {
        page.preview();
    }



}



function timeCardsReportBody2(body, title) {
    var Body = [];
    for (i = 0; i < body.length; i++) {
        var pageBreak = 'after';
        if (i == (body.length) - 1) {
            pageBreak = '';
        }
        var t_body = [];
        t_body.push([
            { text: 'Date', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Actual In', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Actual Out', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Shift', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Nopay', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Late(M)', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'N.Overtime', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'D.Overtime', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Earlydeparture', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Remark', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
        ]);


        Body.push([{
            stack: [
                { text: 'Employee ID : ' + body[i].employee_id, fontSize: 6 },
                { text: 'Employee Name : ' + body[i].employee_name, fontSize: 6 },
                { text: title, fontSize: 6 },
                {
                    table: {
                        widths: ['auto', 'auto', 'auto', 'auto', 'auto', 'auto', 'auto', 'auto', 'auto', '*'],
                        headerRows: 1,
                        body: t_body,
                    },
                    margin: [0, 0],
                },
                { text: '\n', pageBreak: pageBreak },
            ]
        }]);

        for (i2 = 0; i2 < body[i].result.length; i2++) {

            var late_arriver = body[i].result[i2].late_arriver;
            if (!late_arriver) {
                late_arriver = 0;
            }

            var n_ot = body[i].result[i2].n_ot;
            if (!n_ot) {
                n_ot = 0;
            }

            var d_ot = body[i].result[i2].d_ot;
            if (!d_ot) {
                d_ot = 0;
            }

            var early_departure = body[i].result[i2].early_departure;
            if (!early_departure) {
                early_departure = 0;
            }

            t_body.push([
                { text: body[i].result[i2].Date, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].InTime, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].OutTime, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].shift_name, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].NoPay, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: parseFloat(late_arriver * 60.0).toFixed(0), fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: n_ot.toFixed(2), fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: d_ot.toFixed(2), fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: early_departure.toFixed(2), fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: body[i].result[i2].leave_type, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
            ]);
        }


    }
    return Body;

}





function dailyOTReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily OT Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, '*', '*', 20, 70, 70, 20, 20, 30],
                headerRows: 1,
                body: dailyOTReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyOTReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Shift', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'In Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Pay OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);



    for (i = 0; i < result.length; i++) {

        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        var ot_amount = result[i].ot_amount;
        if (!ot_amount) {
            ot_amount = 0;
        }

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].shift, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].in_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].out_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: ot_amount.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}



function highOTReopt(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Highest OT Report From ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, '*', 100, 100, 25, 30, 25, 30],
                headerRows: 1,
                body: highOTReoptBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function highOTReoptBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);



    for (i = 0; i < result.length; i++) {
        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var n_ot_cost = result[i].n_ot_cost;
        if (!n_ot_cost) {
            n_ot_cost = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        var d_ot_cost = result[i].d_ot_cost;
        if (!d_ot_cost) {
            d_ot_cost = 0;
        }

        var n_ot_cost =
            body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
            { text: n_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
            { text: d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
            { text: d_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}



function monthlyOTSummaryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Monthly OT Summary From ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, '*', 125, 125, 30, 30, 30, 30, 30, 30, 30, 30],
                headerRows: 1,
                body: monthlyOTSummaryReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function monthlyOTSummaryReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'P.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'P.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total OT Hours', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {

        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var n_ot_cost = result[i].n_ot_cost;
        if (!n_ot_cost) {
            n_ot_cost = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        var d_ot_cost = result[i].d_ot_cost;
        if (!d_ot_cost) {
            d_ot_cost = 0;
        }

        var p_ot = result[i].p_ot;
        if (!p_ot) {
            p_ot = 0;
        }

        var p_ot_cost = result[i].p_ot_cost;
        if (!p_ot_cost) {
            p_ot_cost = 0;
        }

        var total_ot_hours = result[i].total_ot_hours;
        if (!total_ot_hours) {
            total_ot_hours = 0;
        }

        var total_ot_amount = result[i].total_ot_amount;
        if (!total_ot_amount) {
            total_ot_amount = 0;
        }

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: n_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: d_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: p_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: p_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: total_ot_hours.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: total_ot_amount.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}


function dailyInvalidReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Invalied Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, '*', '*', 'auto', 70, 70],
                headerRows: 1,
                body: dailyInvalidReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyInvalidReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Shift', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'In Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].shift, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].in_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].out_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}


function epf_etfReports(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],

                            [
                                {
                                    table: {
                                        widths: ['*', 150, 150],
                                        headerRows: 1,
                                        body: [
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'C Form EPF Act NO. 15 OF 1985', bold: true, fontSize: 10, border: [true, true, false, true] }, { text: '', fontSize: 10, border: [false, true, true, true] }],
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'E.P.F Registration No', fontSize: 10 }, { text: 'Y16965', fontSize: 10 }],
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'Contributions for', fontSize: 10 }, { text: result.report_date, fontSize: 10 }],
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'Total Remittance', fontSize: 10 }, { text: '', fontSize: 10 }],
                                        ]
                                    }, border: [false, false, false, false]
                                }
                            ]

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 60, '*', 30, 60, 60, 60, 60, 60, 30],
                headerRows: 1,
                body: epf_etfReportsBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function epf_etfReportsBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'NIC', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'EPF No', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Contribution Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Employer Contribution Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Employee Contribution Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Earnings Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'ETF Contribution Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    var total_contribution_amount = 0;
    var total_employer_epf = 0;
    var total_employee_epf = 0;
    var grand_total_earnings = 0;
    var total_employee_etf = 0;
    var total_days = 0;

    for (i = 0; i < result.length; i++) {
        total_contribution_amount += result[i].total_contribution;
        total_employer_epf += result[i].employer_contribution;
        total_employee_epf += result[i].employee_contribution;
        grand_total_earnings += (parseFloat(result[i].employee_contribution) / 8) * 100;
        total_employee_etf += result[i].employee_etf;
        total_days += result[i].work_day;

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].nic, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].epf_no, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].total_contribution.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].employer_contribution.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].employee_contribution.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: ((parseFloat(result[i].employee_contribution) / 8) * 100).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].employee_etf.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].work_day, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }
    body.push([{ text: '', fontSize: 6, bold: true, alignment: 'center', border: [true, true, false, true] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, true, false, true] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, true, false, true] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, true, false, true] },
    { text: total_contribution_amount.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_employer_epf.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_employee_epf.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: grand_total_earnings.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_employee_etf.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_days, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    return body;
}



function allDeductionsReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'All Deductions from ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 130, '*', '*', '*', '*', '*', '*'],
                headerRows: 1,
                body: allDeductionsReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function allDeductionsReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Salary Advance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Loan', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Welfare Shop Deduction', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Welfare Fund', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Other Deduction', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Deduction', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    var total_advance = 0;
    var total_loan = 0;
    var total_welfare_shop_deduction = 0;
    var total_welfare_fund = 0;
    var total_other_deduction = 0;
    var grand_total_deductions = 0;

    for (i = 0; i < result.length; i++) {
        total_advance += result[i].advance;
        total_loan += result[i].loan;
        total_welfare_shop_deduction += result[i].welfare_shop_deduction;
        total_welfare_fund += result[i].welfare_fund;
        total_other_deduction += result[i].other_deduction;
        grand_total_deductions = result[i].total_deductions

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].advance.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].loan.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].welfare_shop_deduction.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].welfare_fund.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].other_deduction.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].total_deductions.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }
    body.push([{ text: '', fontSize: 6, bold: true, alignment: 'center', border: [true, true, false, true] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, true, true, true] },
    { text: total_advance.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_loan.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_welfare_shop_deduction.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_welfare_fund.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_other_deduction.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: grand_total_deductions.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);

    return body;
}





function leaveReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Leave Report from ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 130, '*', 40, 40, 40, '*', 30, '*'],
                headerRows: 1,
                body: leaveReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function leaveReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Leave Type', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Starting', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Ending', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Req Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Leave Approved By', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Section', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);



    for (i = 0; i < result.length; i++) {


        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].leave_type, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].from, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].to, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].request_date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].approved_by, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].days, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].section, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }


    return body;
}





function nightAllowanceReport(result, flag) {

    var day_count = 0;
    var amount = 0;
    for (i = 0; i < result.length; i++) {

        day_count += parseFloat(result[i].total_day);
        amount = (day_count * 20);
    }

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Night Allowance Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [
                                {
                                    table: {
                                        widths: ['*', 150, 150],
                                        headerRows: 1,
                                        body: [
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'TOTAL WORK DAYS', fontSize: 10 }, { text: day_count, fontSize: 10, alignment: 'right' }],
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'TOTAL AMOUNT', fontSize: 10 }, { text: amount.toFixed(2), fontSize: 10, alignment: 'right' }],
                                        ]
                                    }, border: [false, false, false, false]
                                }
                            ],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 130, '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', 30, 30],
                headerRows: 1,
                body: nightAllowanceReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function nightAllowanceReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '1', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '2', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '3', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '4', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '5', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '6', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '7', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '8', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '9', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '10', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '11', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '12', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '13', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '14', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '15', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '16', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '17', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '18', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '19', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '20', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '21', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '22', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '23', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '24', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '25', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '26', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '27', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '28', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '29', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '30', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '31', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Days', fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Amount', fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }


    ]);




    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day1, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day2, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day3, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day4, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day5, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day6, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day7, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day8, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day9, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day10, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day11, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day12, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day13, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day14, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day15, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day16, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day17, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day18, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day19, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day20, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day21, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day22, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day23, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day24, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day25, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day26, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day27, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day28, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day29, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day30, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].day31, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].total_day, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: (parseFloat(result[i].total_day) * 20).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },

        ]);
    }


    return body;
}





function attendanceAllowanceReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Attendance Allowance for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', '*', 40, 40],
                headerRows: 1,
                body: attendanceAllowanceReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];







    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function attendanceAllowanceReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Category', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Present Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Amount', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);




    for (i = 0; i < result.length; i++) {

        var amount = 0.0;
        if (parseFloat(result[i].attendance_count) >= parseFloat(result[i].schedule_day_count)) {
            amount = 2500;
        } else if (parseFloat(result[i].attendance_count) == (parseFloat(result[i].schedule_day_count) - 0.5)) {
            amount = 1500;
        } else if (parseFloat(result[i].attendance_count) == (parseFloat(result[i].schedule_day_count) - 1)) {
            amount = 1000;
        }
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].category, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].attendance_count, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: amount.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }


    return body;
}
























function attendanceReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Employee Attendance Report', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                        ],

                    },
                    margin: [0, 0],
                },
            ]
        }
    ];

    var Body = attendanceReportBody(result.body, result.title);



    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];




    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export2();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function attendanceReportBody(body, title) {
    var Body = [];
    for (i = 0; i < body.length; i++) {
        var pageBreak = 'after';
        if (i == (body.length) - 1) {
            pageBreak = '';
        }
        var t_body = [];
        t_body.push([
            { text: 'Date', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Schedule InTime', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Schedule OutTime', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Actual InTime', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Actusl OutTime', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Shift', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Remark', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },

        ]);


        Body.push([{
            stack: [
                { text: 'Employee ID : ' + body[i].employee_id, fontSize: 6 },
                { text: 'Employee Name : ' + body[i].employee_name, fontSize: 6 },
                { text: title, fontSize: 6 },
                {
                    table: {
                        widths: [50,'*', '*', '*', '*', '*', 'auto'],
                        headerRows: 1,
                        body: t_body,
                    },
                    margin: [0, 0],
                },
                { text: '\n', pageBreak: pageBreak },
            ]
        }]);

        for (i2 = 0; i2 < body[i].result.length; i2++) {
            t_body.push([
                { text: body[i].result[i2].Date, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].schedule_in, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].schedule_out, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].actual_in, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].actual_out, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].shift, fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: body[i].result[i2].remark, fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },

            ]);
        }


    }
    return Body;
}








function supervisorAttendanceApprovalReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Supervisor Attendance Approval Report', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                        ],

                    },
                    margin: [0, 0],
                },
            ]
        }
    ];


    var Body = [
        {
            table: {
                widths: [30, 100, 70, 70, 30, '*'],
                headerRows: 1,
                body: supervisorAttendanceApprovalReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];



    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];




    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function supervisorAttendanceApprovalReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'InTime', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'OutTime Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Approval', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Remark', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);





    for (i = 0; i < result.length; i++) {

        var approval = '';
        if (result[i].approval == '1') {
            approval = 'Approved';
        }

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].InTime, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].OutTime, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: approval, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].remark, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}








function rosterMissingReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Roster Missing Report', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                        ],

                    },
                    margin: [0, 0],
                },
            ]
        }
    ];


    var Body = [
        {
            table: {
                widths: [100, '*', '*', 100],
                headerRows: 1,
                body: rosterMissingReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];



    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];




    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function rosterMissingReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Site', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);





    for (i = 0; i < result.length; i++) {


        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].site, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}









function daysInMonth(month, year) {
    return new Date(year, month, 0).getDate();
}

function switch_settings(setting) {

    if (setting != 'checkCategorySearch') {
        $('#checkCategorySearch').prop('checked', false);
        $('#selcCategory').prop("disabled", true);
        setting_array.category = null;
    }
    if (setting != 'checkSiteSearch') {
        $('#checkSiteSearch').prop('checked', false);
        $('#selcSite').prop("disabled", true);
        setting_array.site = null;
    }
    if (setting != 'checkDepartmentSearch') {
        $('#checkDepartmentSearch').prop('checked', false);
        $('#selcDepartment').prop("disabled", true);
        setting_array.department = null;
    }
    if (setting != 'checkSectionSearch') {
        $('#checkSectionSearch').prop('checked', false);
        $('#selcSection').prop("disabled", true);
        setting_array.section = null;
    }
    if (setting != 'checkSubsectionSearch') {
        $('#checkSubsectionSearch').prop('checked', false);
        $('#selcSubsection').prop("disabled", true);
        setting_array.subsection = null;
    }
    if (setting != 'checkCompanySearch') {
        $('#checkCompanySearch').prop('checked', false);
        $('#selcCompany').prop("disabled", true);
        setting_array.company = null;
    }
    if (setting != 'checkTeamSearch') {
        $('#checkTeamSearch').prop('checked', false);
        $('#selcTeam').prop("disabled", true);
        setting_array.team = null;
    }
    if (setting != 'checkEmployeeSearch') {
        $('#checkEmployeeSearch').prop('checked', false);
        $('#selcEmployee').prop("disabled", true);
        setting_array.employee = null;
    }
}


function showDate(args) {

    if (args == 'YEAR_MONTH') {
        $('#divDate1').hide();
        $('#divDate2').show();
    } else {
        $('#divDate1').show();
        $('#divDate2').hide();
    }

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else {
        $('#endDate').show();
    }


}



function _export() {
    createReport('EXPORT');
}






/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
