class DayBasis {

    static create(data) {
        var BASIC_SALARY = parseFloat(data.basic_salary);
        //var REAL_WORK_DAY = parseFloat($('#txtRealWorked_days').val());
        var CAT_WORK_DAY = parseFloat(data.category_work_day);
        var CAT_WORK_HOUR = parseFloat(data.category_work_hour);
        var ADDITIONAL_WORK_DAY = parseFloat($('#txtAdditionalWorked_days').val());

        if(isNaN(ADDITIONAL_WORK_DAY)){
            ADDITIONAL_WORK_DAY = 0;
        }
        //var NOPAY_DAY = parseFloat($('#txtNopay_days').val());
        var NOPAY_DAY = (ORIGINAL_NOPAY_DAY - ADDITIONAL_WORK_DAY);
        $('#txtNopay_days').val(NOPAY_DAY);
        var REAL_WORK_DAY = parseFloat(data.category_work_day - NOPAY_DAY);

        /*var nopay_days = 0;
        if (isNaN(REAL_WORK_DAY)) {
            REAL_WORK_DAY = 0;
        }
        if (CAT_WORK_DAY >= REAL_WORK_DAY) {
            nopay_days = (CAT_WORK_DAY - REAL_WORK_DAY);
            $('#txtNopay_days').val(nopay_days);
        }


        var NOPAY_DAY = parseFloat($('#txtNopay_days').val());*/
        var BUDGET_ALLOWANCE_RATE1 = parseFloat(data.category_budget_allowance1);
        var BUDGET_ALLOWANCE_RATE2 = parseFloat(data.category_budget_allowance2);
        var EPF_EMPLOYER = parseFloat(data.category_epf_employer);
        var EPF_EMPLOYEE = parseFloat(data.category_epf_employee);
        var ETF_EMPLOYEE = parseFloat(data.category_etf_employee);
        var CAT_FINE_RATE = parseFloat(data.category_fine_rate);
        var FINE_HOUR = parseFloat($('#txtFine_hours').val());
        var OT_RATE1 = parseFloat(data.category_ot_rate1);
        var OT_RATE2 = parseFloat(data.category_ot_rate2);
        var OT_RATE3 = parseFloat(data.category_ot_rate3);
        var OT_HOUR1 = parseFloat($('#txtOt_hours1').val());
        var OT_HOUR2 = parseFloat($('#txtOt_hours2').val());
        var OT_HOUR3 = parseFloat($('#txtOt_hours3').val());
        var EARNINGS = DayBasis.getEarnings();
        var DEDUCTIONS = DayBasis.getDeductions();
        var ADVANCE = parseFloat($('#txtAdvance').val());
        var LOAN = parseFloat($('#txtLoan').val());
        var LOAN_INTEREST = parseFloat($('#txtLoan_interest').val());
        var DEBTOR_LOAN = parseFloat($('#txtDebtor_loan').val());
        var DEBTOR_LOAN_INTEREST = parseFloat($('#txtDebtor_loan_interest').val());

        if (isNaN(ADVANCE)) {
            ADVANCE = 0.00;
        }

        if (isNaN(LOAN)) {
            LOAN = 0.00;
        }

        if (isNaN(LOAN_INTEREST)) {
            LOAN_INTEREST = 0.00;
        }

        if (isNaN(DEBTOR_LOAN)) {
            DEBTOR_LOAN = 0.00;
        }

        if (isNaN(DEBTOR_LOAN_INTEREST)) {
            DEBTOR_LOAN_INTEREST = 0.00;
        }


        var SALARY = DayBasis.getBasicSalary(BASIC_SALARY, CAT_WORK_DAY, REAL_WORK_DAY);
        if (isNaN(SALARY)) {
            SALARY = 0.00;
        }
        $('#lblGenaral_BasicSalary').text(parseFloat(SALARY).toFixed(2));

        var NOPAY_AMOUNT = DayBasis.getNopayAmount(BASIC_SALARY, CAT_WORK_DAY, NOPAY_DAY);
        if (isNaN(NOPAY_AMOUNT)) {
            NOPAY_AMOUNT = 0.00;
        }
        $('#txtNopay_amount').val(parseFloat(NOPAY_AMOUNT).toFixed(2));

        var BUDGET_ALLOWANCE_AMOUNT1 = DayBasis.getBudget1(BUDGET_ALLOWANCE_RATE1, CAT_WORK_DAY, REAL_WORK_DAY);
        if (isNaN(BUDGET_ALLOWANCE_AMOUNT1)) {
            BUDGET_ALLOWANCE_AMOUNT1 = 0.00;
        }
        $('#txtBudget1').val(parseFloat(BUDGET_ALLOWANCE_AMOUNT1).toFixed(2));

        var BUDGET_ALLOWANCE_AMOUNT2 = DayBasis.getBudget2(BUDGET_ALLOWANCE_RATE2, CAT_WORK_DAY, REAL_WORK_DAY);
        if (isNaN(BUDGET_ALLOWANCE_AMOUNT2)) {
            BUDGET_ALLOWANCE_AMOUNT2 = 0.00;
        }
        $('#txtBudget2').val(parseFloat(BUDGET_ALLOWANCE_AMOUNT2).toFixed(2));

        var EPF_EMPLOYER_AMOUNT = DayBasis.getEmployerEPF(SALARY, BUDGET_ALLOWANCE_AMOUNT1, BUDGET_ALLOWANCE_AMOUNT2, EPF_EMPLOYER);
        if (isNaN(EPF_EMPLOYER_AMOUNT)) {
            EPF_EMPLOYER_AMOUNT = 0.00;
        }
        $('#txtEmployer_epf').val(parseFloat(EPF_EMPLOYER_AMOUNT).toFixed(2));

        var EPF_EMPLOYEE_AMOUNT = DayBasis.getEmployeeEPF(SALARY, BUDGET_ALLOWANCE_AMOUNT1, BUDGET_ALLOWANCE_AMOUNT2, EPF_EMPLOYEE);
        if (isNaN(EPF_EMPLOYEE_AMOUNT)) {
            EPF_EMPLOYEE_AMOUNT = 0.00;
        }
        $('#txtEmployee_epf').val(parseFloat(EPF_EMPLOYEE_AMOUNT).toFixed(2));

        var ETF_EMPLOYEE_AMOUNT = DayBasis.getEmployeeETF(SALARY, BUDGET_ALLOWANCE_AMOUNT1, BUDGET_ALLOWANCE_AMOUNT2, ETF_EMPLOYEE);
        if (isNaN(ETF_EMPLOYEE_AMOUNT)) {
            ETF_EMPLOYEE_AMOUNT = 0.00;
        }
        $('#txtEmployee_etf').val(parseFloat(ETF_EMPLOYEE_AMOUNT).toFixed(2));

        var FINE_AMOUNT = DayBasis.getFineAmount(FINE_HOUR, CAT_FINE_RATE);
        if (isNaN(FINE_AMOUNT)) {
            FINE_AMOUNT = 0.00;
        }
        $('#txtFine_amount').val(parseFloat(FINE_AMOUNT).toFixed(2));

        var OT_AMOUNT1_HOUR1 = DayBasis.get_1hour_overtimeAmount(BASIC_SALARY, BUDGET_ALLOWANCE_RATE1, BUDGET_ALLOWANCE_RATE2, CAT_WORK_DAY, CAT_WORK_HOUR, OT_RATE1);
        if (isNaN(OT_AMOUNT1_HOUR1)) {
            OT_AMOUNT1_HOUR1 = 0.00;
        }
        $('#hid_ot_rate1_amount').val(OT_AMOUNT1_HOUR1);

        var OT_AMOUNT1 = DayBasis.getOverTime(OT_AMOUNT1_HOUR1, OT_HOUR1);
        if (isNaN(OT_AMOUNT1)) {
            OT_AMOUNT1 = 0.00;
        }
        $('#lblOt_amount1').text(parseFloat(OT_AMOUNT1).toFixed(2));

        var OT_AMOUNT2_HOUR1 = DayBasis.get_1hour_overtimeAmount(BASIC_SALARY, BUDGET_ALLOWANCE_RATE1, BUDGET_ALLOWANCE_RATE2, CAT_WORK_DAY, CAT_WORK_HOUR, OT_RATE2);
        if (isNaN(OT_AMOUNT2_HOUR1)) {
            OT_AMOUNT2_HOUR1 = 0.00;
        }
        $('#hid_ot_rate2_amount').val(OT_AMOUNT2_HOUR1);

        var OT_AMOUNT2 = DayBasis.getOverTime(OT_AMOUNT2_HOUR1, OT_HOUR2);
        if (isNaN(OT_AMOUNT2)) {
            OT_AMOUNT2 = 0.00;
        }
        $('#lblOt_amount2').text(parseFloat(OT_AMOUNT2).toFixed(2));

        var OT_AMOUNT3_HOUR1 = DayBasis.get_1hour_overtimeAmount(BASIC_SALARY, BUDGET_ALLOWANCE_RATE1, BUDGET_ALLOWANCE_RATE2, CAT_WORK_DAY, CAT_WORK_HOUR, OT_RATE3);
        if (isNaN(OT_AMOUNT3_HOUR1)) {
            OT_AMOUNT3_HOUR1 = 0.00;
        }
        $('#hid_ot_rate3_amount').val(OT_AMOUNT3_HOUR1);

        var OT_AMOUNT3 = DayBasis.getOverTime(OT_AMOUNT3_HOUR1, OT_HOUR3);
        if (isNaN(OT_AMOUNT3)) {
            OT_AMOUNT3 = 0.00;
        }
        $('#lblOt_amount3').text(parseFloat(OT_AMOUNT3).toFixed(2));

        var BASIC_EARNING = DayBasis.getBasicEarning(BASIC_SALARY, BUDGET_ALLOWANCE_AMOUNT1, BUDGET_ALLOWANCE_AMOUNT2, NOPAY_AMOUNT);
        console.log(BASIC_EARNING);
        if (isNaN(BASIC_EARNING)) {
            BASIC_EARNING = 0.00;
        }

        var TOTAL_EARNING_AMOUNT = DayBasis.getTotalEarningAmount(OT_AMOUNT1, OT_AMOUNT2, OT_AMOUNT3, EARNINGS);
        console.log(TOTAL_EARNING_AMOUNT);
        if (isNaN(TOTAL_EARNING_AMOUNT)) {
            TOTAL_EARNING_AMOUNT = 0.00;
        }

        var GROSS_SALARY = DayBasis.getGrossSalary(BASIC_EARNING, TOTAL_EARNING_AMOUNT);
        if (isNaN(GROSS_SALARY)) {
            GROSS_SALARY = 0.00;
        }

        $('#lblGross_salary').text(parseFloat(GROSS_SALARY).toFixed(2));

        
        var TOTAL_DEDUCTION = DayBasis.getTotalDeduction(EPF_EMPLOYEE_AMOUNT, FINE_AMOUNT, DEDUCTIONS, ADVANCE, LOAN, LOAN_INTEREST, DEBTOR_LOAN, DEBTOR_LOAN_INTEREST);
        if (isNaN(TOTAL_DEDUCTION)) {
            TOTAL_DEDUCTION = 0.00;
        }
        $('#lblTotal_deduction').text(parseFloat(TOTAL_DEDUCTION).toFixed(2));

        var NET_SALARY = DayBasis.getNetSalary(GROSS_SALARY, TOTAL_DEDUCTION);
        if (isNaN(NET_SALARY)) {
            NET_SALARY = 0.00;
        }
        $('#lblNet_salary').text(parseFloat(NET_SALARY).toFixed(2));

    }


    static getBasicSalary(BASIC_SALARY, CAT_WORK_DAY, REAL_WORK_DAY) {
        var salary = 0;
        if (REAL_WORK_DAY > CAT_WORK_DAY) {
            salary = (BASIC_SALARY / CAT_WORK_DAY) * CAT_WORK_DAY;
        } else if (REAL_WORK_DAY <= CAT_WORK_DAY) {
            salary = (BASIC_SALARY / CAT_WORK_DAY) * REAL_WORK_DAY;
        }
        return salary;

    }

    static getNopayAmount(BASIC_SALARY, CAT_WORK_DAY, NOPAY_DAY) {
        return (BASIC_SALARY / CAT_WORK_DAY) * NOPAY_DAY;
    }

    static getBudget1(BUDGET_ALLOWANCE_RATE1, CAT_WORK_DAY, REAL_WORK_DAY) {
        var amount = 0;
        if (REAL_WORK_DAY > CAT_WORK_DAY) {
            amount = (BUDGET_ALLOWANCE_RATE1 / CAT_WORK_DAY) * CAT_WORK_DAY;
        } else if (REAL_WORK_DAY <= CAT_WORK_DAY) {
            amount = (BUDGET_ALLOWANCE_RATE1 / CAT_WORK_DAY) * REAL_WORK_DAY;
        }
        return amount;
    }

    static getBudget2(BUDGET_ALLOWANCE_RATE2, CAT_WORK_DAY, REAL_WORK_DAY) {
        var amount = 0;
        if (REAL_WORK_DAY > CAT_WORK_DAY) {
            amount = (BUDGET_ALLOWANCE_RATE2 / CAT_WORK_DAY) * CAT_WORK_DAY;
        } else if (REAL_WORK_DAY <= CAT_WORK_DAY) {
            amount = (BUDGET_ALLOWANCE_RATE2 / CAT_WORK_DAY) * REAL_WORK_DAY;
        }
        return amount;
    }

    static getEmployerEPF(SALARY, BUDGET_ALLOWANCE_AMOUNT1, BUDGET_ALLOWANCE_AMOUNT2, EPF_EMPLOYER) {
        return ((SALARY + BUDGET_ALLOWANCE_AMOUNT1 + BUDGET_ALLOWANCE_AMOUNT2) / 100) * EPF_EMPLOYER;
    }

    static getEmployeeEPF(SALARY, BUDGET_ALLOWANCE_AMOUNT1, BUDGET_ALLOWANCE_AMOUNT2, EPF_EMPLOYEE) {
        return ((SALARY + BUDGET_ALLOWANCE_AMOUNT1 + BUDGET_ALLOWANCE_AMOUNT2) / 100) * EPF_EMPLOYEE;
    }

    static getEmployeeETF(SALARY, BUDGET_ALLOWANCE_AMOUNT1, BUDGET_ALLOWANCE_AMOUNT2, ETF_EMPLOYEE) {
        return ((SALARY + BUDGET_ALLOWANCE_AMOUNT1 + BUDGET_ALLOWANCE_AMOUNT2) / 100) * ETF_EMPLOYEE;
    }

    static getFineAmount(FINE_HOURS, CAT_FINE_RATE) {
        return (FINE_HOURS * CAT_FINE_RATE);
    }

    static get_1hour_overtimeAmount(BASIC_SALARY, BUDGET_ALLOWANCE_RATE1, BUDGET_ALLOWANCE_RATE2, CAT_WORK_DAY, CAT_WORK_HOUR, OT_RATE) {
        return (((BASIC_SALARY + BUDGET_ALLOWANCE_RATE1 + BUDGET_ALLOWANCE_RATE2) / CAT_WORK_DAY) / CAT_WORK_HOUR) * OT_RATE;
    }

    static getOverTime(OT_AMOUNT1_HOUR1, OT_HOUR) {
        return (OT_AMOUNT1_HOUR1 * OT_HOUR);
    }


    static getEarnings() {

        var earn1 = parseFloat($('#txt_earn_01').val());
        if (isNaN(earn1)) {
            earn1 = 0;
        }

        var earn2 = parseFloat($('#txt_earn_02').val());
        if (isNaN(earn2)) {
            earn2 = 0;
        }

        var earn3 = parseFloat($('#txt_earn_03').val());
        if (isNaN(earn3)) {
            earn3 = 0;
        }

        var earn4 = parseFloat($('#txt_earn_04').val());
        if (isNaN(earn4)) {
            earn4 = 0;
        }

        var earn5 = parseFloat($('#txt_earn_05').val());
        if (isNaN(earn5)) {
            earn5 = 0;
        }

        var earn6 = parseFloat($('#txt_earn_06').val());
        if (isNaN(earn6)) {
            earn6 = 0;
        }

        var earn7 = parseFloat($('#txt_earn_07').val());
        if (isNaN(earn7)) {
            earn7 = 0;
        }

        var earn8 = parseFloat($('#txt_earn_08').val());
        if (isNaN(earn8)) {
            earn8 = 0;
        }

        var earn9 = parseFloat($('#txt_earn_09').val());
        if (isNaN(earn9)) {
            earn9 = 0;
        }

        var earn10 = parseFloat($('#txt_earn_10').val());
        if (isNaN(earn10)) {
            earn10 = 0;
        }


        return (earn1 + earn2 + earn3 + earn4 + earn5 + earn6 + earn7 + earn8 + earn9 + earn10);
    }



    static getDeductions() {

        var deduct1 = parseFloat($('#txt_deduct_01').val());
        if (isNaN(deduct1)) {
            deduct1 = 0;
        }

        var deduct2 = parseFloat($('#txt_deduct_02').val());
        if (isNaN(deduct2)) {
            deduct2 = 0;
        }

        var deduct3 = parseFloat($('#txt_deduct_03').val());
        if (isNaN(deduct3)) {
            deduct3 = 0;
        }

        var deduct4 = parseFloat($('#txt_deduct_04').val());
        if (isNaN(deduct4)) {
            deduct4 = 0;
        }

        var deduct5 = parseFloat($('#txt_deduct_05').val());
        if (isNaN(deduct5)) {
            deduct5 = 0;
        }

        var deduct6 = parseFloat($('#txt_deduct_06').val());
        if (isNaN(deduct6)) {
            deduct6 = 0;
        }

        var deduct7 = parseFloat($('#txt_deduct_07').val());
        if (isNaN(deduct7)) {
            deduct7 = 0;
        }

        var deduct8 = parseFloat($('#txt_deduct_08').val());
        if (isNaN(deduct8)) {
            deduct8 = 0;
        }

        var deduct9 = parseFloat($('#txt_deduct_09').val());
        if (isNaN(deduct9)) {
            deduct9 = 0;
        }

        var deduct10 = parseFloat($('#txt_deduct_10').val());
        if (isNaN(deduct10)) {
            deduct10 = 0;
        }


        return (deduct1 + deduct2 + deduct3 + deduct4 + deduct5 + deduct6 + deduct7 + deduct8 + deduct9 + deduct10);
    }



    static getBasicEarning(BASIC_SALARY, BUDGET_ALLOWANCE_AMOUNT1, BUDGET_ALLOWANCE_AMOUNT2, NOPAY_AMOUNT) {
        return (BASIC_SALARY + BUDGET_ALLOWANCE_AMOUNT1 + BUDGET_ALLOWANCE_AMOUNT2) - NOPAY_AMOUNT;
    }


    static getTotalEarningAmount(OT_AMOUNT1, OT_AMOUNT2, OT_AMOUNT3, EARNINGS) {
        return (OT_AMOUNT1 + OT_AMOUNT2 + OT_AMOUNT3 + EARNINGS);
    }

    static getGrossSalary(BASIC_EARNING, TOTAL_EARNING_AMOUNT) {
        return (BASIC_EARNING + TOTAL_EARNING_AMOUNT);
    }

    static getTotalDeduction(EPF_EMPLOYEE_AMOUNT, FINE_AMOUNT, DEDUCTIONS, ADVANCE, LOAN, LOAN_INTEREST, DEBTOR_LOAN, DEBTOR_LOAN_INTEREST) {
        return (EPF_EMPLOYEE_AMOUNT + FINE_AMOUNT + DEDUCTIONS + ADVANCE + LOAN + LOAN_INTEREST + DEBTOR_LOAN + DEBTOR_LOAN_INTEREST);
    }

    static getNetSalary(GROSS_SALARY, TOTAL_DEDUCTION) {
        return (GROSS_SALARY - TOTAL_DEDUCTION);
    }
}