@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<link rel="stylesheet" href="{{ url('vendors/selects/select2.min.css') }}" type="text/css">
<script>
    var edit_permission = "{{ Auth::user()->can('employee_edit')}} ";
    var view_permission = "{{ Auth::user()->can('employee_view')}} ";
    var delete_permission = "{{ Auth::user()->can('employee_delete')}} ";

</script>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee list</h6>
                <div class="row">
                    <div class="col-md-4">
                        <select class="form-control" id="cmbType">
                            <option value="any">Any</option>
                            <option value="id">Employee ID</option>
                            <option value="nic">NIC</option>
                        </select>
                    </div>
                    <div class="col-md-5">
                        <div class="row" id="div_search">
                            <div class="col-md-10">
                                <select id="cmbSearchFrom" class="form-control"></select>
                            </div>
                            <div class="col-md-2">
                                <button type="button" class="btn btn-primary" id="btnSearch"><i class="fa fa-search" aria-hidden="true"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                <div>
                    {{ csrf_field() }}
                    <table id="myTable" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                        <thead>
                            <tr>
                                <th class="id">Employee ID</th>
                                <th>NIC</th>
                                <th>Name</th>
                                <th>Designation</th>
                                <th>Edit</th>
                                <th>View</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<script src="{{ url('vendors/selects/select2.min.js') }}"></script>
<script src="{{ Module::asset('hr:js/employeeList.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection
