@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<script>
    var edit_permission = "{{ Auth::user()->can('employee_edit')}} ";
    var view_permission = "{{ Auth::user()->can('employee_view')}} ";
    var delete_permission = "{{ Auth::user()->can('employee_delete')}} ";
</script>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee list</h6>
                {{ csrf_field() }}
                <table class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                    <thead>
                        <tr>
                            <th class="id">Employee ID</th>
                            <th>Name</th>
                            <th>Designation</th>
                            <th>Site</th>
                            <th>Month</th>
                        </tr>
                    </thead>
                    <tbody id="tblData"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')

<script src="{{ Module::asset('hr:js/employee_3_6_month_completed.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection