<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>RBS</title>

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ url('assets/media/image/favicon.png') }}" />

    <!-- Main css -->
    <link rel="stylesheet" href="{{ url('vendors/bundle.css') }}" type="text/css">

    <!-- Google font -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    @yield('head')

    <!-- App css -->
    <link rel="stylesheet" href="{{ url('assets/css/app.min.css') }}" type="text/css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <script>
        var user_id = '{{Auth::user()->user_id}}';
        var user_name = '{{Auth::user()->name}}';
        var user_email = '{{Auth::user()->email}}';
    </script>
    <style>
        .notification {
            color: white;
            text-decoration: none;
            padding: 15px 26px;
            position: relative;
            display: inline-block;
            border-radius: 2px;
        }


        .notification .badge {
            position: absolute;
            top: -10px;
            right: 10px;
            padding: 5px 5px;
            border-radius: 50%;
            background: red;
            color: white;
        }
    </style>
</head>

<body class="hidden-navigation scrollable-layout">
    <!-- Preloader -->
    <div class="preloader">
        <div class="preloader-icon"></div>
        <span>Loading...</span>
    </div>
    <!-- ./ Preloader -->

    <!-- Sidebar group -->
    <div class="sidebar-group">

        <!-- BEGIN: Settings -->
        <div class="sidebar" id="settings">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title d-flex justify-content-between">
                        Settings
                        <a class="btn-sidebar-close" href="#">
                            <i class="ti-close"></i>
                        </a>
                    </h6>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item pl-0 pr-0">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="customSwitch1" checked>
                                <label class="custom-control-label" for="customSwitch1">Allow notifications.</label>
                            </div>
                        </li>
                        <li class="list-group-item pl-0 pr-0">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="customSwitch2">
                                <label class="custom-control-label" for="customSwitch2">Hide user requests</label>
                            </div>
                        </li>
                        <li class="list-group-item pl-0 pr-0">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="customSwitch3" checked>
                                <label class="custom-control-label" for="customSwitch3">Speed up demands</label>
                            </div>
                        </li>
                        <li class="list-group-item pl-0 pr-0">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="customSwitch4" checked>
                                <label class="custom-control-label" for="customSwitch4">Hide menus</label>
                            </div>
                        </li>
                        <li class="list-group-item pl-0 pr-0">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="customSwitch5">
                                <label class="custom-control-label" for="customSwitch5">Remember next visits</label>
                            </div>
                        </li>
                        <li class="list-group-item pl-0 pr-0">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="customSwitch6">
                                <label class="custom-control-label" for="customSwitch6">Enable report
                                    generation.</label>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- END: Settings -->

        <!-- BEGIN: Chat List -->
        <div class="sidebar" id="chat-list">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title d-flex justify-content-between">
                        Chats
                        <a class="btn-sidebar-close" href="#">
                            <i class="ti-close"></i>
                        </a>
                    </h6>
                    <div class="list-group list-group-flush">
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-danger">
                                    <img src="{{ url('assets/media/image/user/women_avatar3.jpg') }}" class="rounded-circle" alt="image">
                                </span>
                            </div>
                            <div class="flex-grow- 1">
                                <h6 class="mb-1">Cass Queyeiro</h6>
                                <span class="text-muted">
                                    <i class="fa fa-image mr-1"></i> Photo
                                </span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">Yesterday</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-warning">
                                    <img src="{{ url('assets/media/image/user/man_avatar4.jpg') }}" class="rounded-circle" alt="image">
                                </span>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">Evered Asquith</h6>
                                <span class="text-muted">
                                    <i class="fa fa-video-camera mr-1"></i> Video
                                </span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">Last week</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item px-0 d-flex align-items-start">
                            <div class="pr-3">
                                <div class="avatar avatar-state-danger">
                                    <span class="avatar-title bg-success rounded-circle">F</span>
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">Francisco Ubsdale</h6>
                                <span class="text-muted">Hello how are you?</span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">2:32 PM</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item px-0 d-flex align-items-start">
                            <div class="pr-3">
                                <div class="avatar avatar-state-success">
                                    <img src="{{ url('assets/media/image/user/women_avatar1.jpg') }}" class="rounded-circle" alt="image">
                                </div>
                            </div>
                            <div>
                                <h6 class="mb-1">Natale Janu</h6>
                                <span class="text-muted">Hi!</span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="badge badge-primary badge-pill ml-auto mb-2">3</span>
                                <span class="small text-muted">08:27 PM</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-warning">
                                    <img src="{{ url('assets/media/image/user/women_avatar2.jpg') }}" class="rounded-circle" alt="image">
                                </span>
                            </div>
                            <div class="flex-grow- 1">
                                <h6 class="mb-1">Orelie Rockhall</h6>
                                <span class="text-muted">
                                    <i class="fa fa-image mr-1"></i> Photo
                                </span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">Yesterday</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-info">
                                    <img src="{{ url('assets/media/image/user/man_avatar1.jpg') }}" class="rounded-circle" alt="image">
                                </span>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">Barbette Bolf</h6>
                                <span class="text-muted">
                                    <i class="fa fa-video-camera mr-1"></i> Video
                                </span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">Last week</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-secondary">
                                    <span class="avatar-title bg-warning rounded-circle">D</span>
                                </span>
                            </div>
                            <div>
                                <h6 class="mb-1">Dudley Laborde</h6>
                                <span class="text-muted">Hello how are you?</span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">2:32 PM</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-success">
                                    <img src="{{ url('assets/media/image/user/man_avatar2.jpg') }}" class="rounded-circle" alt="image">
                                </span>
                            </div>
                            <div>
                                <h6 class="mb-1">Barbaraanne Riby</h6>
                                <span class="text-muted">Hi!</span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">08:27 PM</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-danger">
                                    <img src="{{ url('assets/media/image/user/women_avatar3.jpg') }}" class="rounded-circle" alt="image">
                                </span>
                            </div>
                            <div class="flex-grow- 1">
                                <h6 class="mb-1">Mariana Ondrousek</h6>
                                <span class="text-muted">
                                    <i class="fa fa-image mr-1"></i> Photo
                                </span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">Yesterday</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-warning">
                                    <img src="{{ url('assets/media/image/user/man_avatar4.jpg') }}" class="rounded-circle" alt="image">
                                </span>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">Ruprecht Lait</h6>
                                <span class="text-muted">
                                    <i class="fa fa-video-camera mr-1"></i> Video
                                </span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">Last week</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-info">
                                    <img src="{{ url('assets/media/image/user/man_avatar1.jpg') }}" class="rounded-circle" alt="image">
                                </span>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">Cosme Hubbold</h6>
                                <span class="text-muted">
                                    <i class="fa fa-video-camera mr-1"></i> Video
                                </span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">Last week</span>
                            </div>
                        </a>
                        <a href="#" class="list-group-item d-flex px-0 align-items-start">
                            <div class="pr-3">
                                <span class="avatar avatar-state-secondary">
                                    <span class="avatar-title bg-secondary rounded-circle">M</span>
                                </span>
                            </div>
                            <div>
                                <h6 class="mb-1">Mallory Darch</h6>
                                <span class="text-muted">Hello how are you?</span>
                            </div>
                            <div class="text-right ml-auto d-flex flex-column">
                                <span class="small text-muted">2:32 PM</span>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- END: Chat List -->

    </div>
    <!-- ./ Sidebar group -->

    <!-- Layout wrapper -->
    <div class="layout-wrapper">

        <!-- Header -->
        <div class="header d-print-none">
            <div class="header-container">
                <div class="header-left">
                    <div class="navigation-toggler">
                        <a href="#" data-action="navigation-toggler">
                            <i data-feather="menu"></i>
                        </a>
                    </div>

                    <div class="header-logo">
                        <a href="{{ url('/') }}">
                            <!-- <img class="logo" src="{{ url('assets/media/image/logo.png') }}" alt="logo"> -->
                        </a>
                    </div>
                </div>

                <div class="header-body">
                    <div class="header-body-left">
                        <ul class="navbar-nav">
                            <li class="nav-item mr-3">
                                <div class="header-search-form">
                                    <form>
                                        <div class="input-group">
                                            <!--<div class="input-group-prepend">
                                                <button class="btn">
                                                    <i data-feather="search"></i>
                                                </button>
                                            </div>
                                            <input type="text" class="form-control" placeholder="Search">
                                            <div class="input-group-append">
                                                <button class="btn header-search-close-btn">
                                                    <i data-feather="x"></i>
                                                </button>
                                            </div>!-->
                                        </div>
                                    </form>
                                </div>
                            </li>
                            <!--<li class="nav-item dropdown d-none d-md-block">
                                <a href="#" class="nav-link" title="Apps" data-toggle="dropdown">Apps</a>
                                <div class="dropdown-menu dropdown-menu-big">
                                    <div class="border-bottom px-4 py-3 text-center d-flex justify-content-between">
                                        <h5 class="mb-0">Apps</h5>
                                    </div>
                                    <div class="p-3">
                                        <div class="row row-xs">
                                            <div class="col-6">
                                                <a href="#">
                                                    <div class="border-radius-1 text-center mb-3">
                                                        <figure class="avatar avatar-lg border-0">
                                                            <span class="avatar-title bg-primary text-white rounded-circle">
                                                                <i class="width-30 height-30" data-feather="message-circle"></i>
                                                            </span>
                                                        </figure>
                                                        <div class="mt-2">Chat</div>
                                                    </div>
                                                </a>
                                            </div>
                                            <div class="col-6">
                                                <a href="#">
                                                    <div class="border-radius-1 text-center mb-3">
                                                        <figure class="avatar avatar-lg border-0">
                                                            <span class="avatar-title bg-secondary text-white rounded-circle">
                                                                <i class="width-30 height-30" data-feather="mail"></i>
                                                            </span>
                                                        </figure>
                                                        <div class="mt-2">Mail</div>
                                                    </div>
                                                </a>
                                            </div>
                                            <div class="col-6">
                                                <a href="#">
                                                    <div class="border-radius-1 text-center">
                                                        <figure class="avatar avatar-lg border-0">
                                                            <span class="avatar-title bg-info text-white rounded-circle">
                                                                <i class="width-30 height-30" data-feather="check-circle"></i>
                                                            </span>
                                                        </figure>
                                                        <div class="mt-2">Todo List</div>
                                                    </div>
                                                </a>
                                            </div>
                                            <div class="col-6">
                                                <a href="#">
                                                    <div class="border-radius-1 text-center">
                                                        <figure class="avatar avatar-lg border-0">
                                                            <span class="avatar-title bg-warning text-white rounded-circle">
                                                                <i class="width-30 height-30" data-feather="file"></i>
                                                            </span>
                                                        </figure>
                                                        <div class="mt-2">File Manager</div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>-->
                            <li class="nav-item dropdown d-none d-md-block">
                                <a href="#" class="nav-link" title="Actions" data-toggle="dropdown">Quick Links</a>
                                <div class="dropdown-menu">
                                    <a href="/welcome" class="dropdown-item">Main Board</a>
                                    <div class="dropdown-divider"></div>
                                    <a href="/hr/employeeList" class="dropdown-item">Employee</a>
                                    <div class="dropdown-divider"></div>
                                    <a href="/hr/printid" class="dropdown-item">ID Card</a>
                                </div>
                            </li>

                        </ul>
                    </div>
                    <div style="text-align: center;">
                        <label style="color: white;font-size: 16px;" title="Actions">Customer Support +94701610001</label>
                    </div>

                    <div class="header-body-right">
                        <ul class="navbar-nav">
                            <li class="nav-item">
                                <a href="#" class="nav-link mobile-header-search-btn" title="Search">
                                    <i data-feather="search"></i>
                                </a>
                            </li>

                            <li class="nav-item dropdown d-none d-md-block">
                                <a href="#" class="nav-link" title="Fullscreen" data-toggle="fullscreen">
                                    <i class="maximize" data-feather="maximize"></i>
                                    <i class="minimize" data-feather="minimize"></i>
                                </a>
                            </li>

                            <!--<li class="nav-item dropdown">
                                <a href="#" class="nav-link nav-link-notify" title="Chats" data-sidebar-target="#chat-list">
                                    <i data-feather="message-circle"></i>
                                </a>
                            </li>-->

                            @php($count=0)
                            @if(Auth::user())
                            @foreach(Auth::user()->Notifications as $notification)

                            @if($notification->read_at == null)
                            @php($count++)
                            @endif
                            @endforeach
                            @endif
                            <li class="nav-item dropdown">
                                <a href="#" id="notify-ico" class="notification nav-link" title="Notifications" data-toggle="dropdown">
                                    <span class="badge" id="notify-count">{{$count}}</span>
                                    <i data-feather="bell"></i>
                                </a>

                                <div class="dropdown-menu dropdown-menu-right dropdown-menu-big">
                                    <div class="border-bottom px-4 py-3 text-center d-flex justify-content-between align-items-center">
                                        <h5 class="mb-0">Notifications</h5>
                                        <small class="opacity-7" id="notification_count">{{$count}} unread notifications</small>
                                    </div>
                                    <div class="dropdown-scroll">
                                        <ul class="list-group list-group-flush" id="notification_content">
                                            @foreach(Auth::user()->Notifications as $notification)
                                            @if($notification->read_at == null)
                                            <li class="px-4 py-3 list-group-item">
                                                <a href="/readNotification/{{ $notification->id}}" class="d-flex align-items-center hide-show-toggler">

                                                    <div class="flex-grow-1">
                                                        <p class="mb-0 line-height-20 d-flex justify-content-between">
                                                            {{ $notification->data['data']}}
                                                            <i title="Mark as read" data-toggle="tooltip" class="hide-show-toggler-item fa fa-circle-o font-size-11"></i>
                                                        </p>
                                                        <!--<span class="text-muted small">20 min ago</span>!-->
                                                    </div>
                                                </a>
                                            </li>
                                            @endif
                                            @endforeach
                                        </ul>
                                    </div>
                                    <div class="px-4 py-3 text-right border-top">
                                        <ul class="list-inline small">
                                            <li class="list-inline-item mb-0">
                                                <a href="#">Mark All Read</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </li>

                            <!--<li class="nav-item">
                                <a href="#" title="Cart" class="nav-link" data-toggle="dropdown">
                                    <i data-feather="shopping-bag"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right dropdown-menu-big">
                                    <div class="border-bottom px-4 py-3 text-center d-flex justify-content-between align-items-center">
                                        <h5 class="mb-0">Cart</h5>
                                        <small class="opacity-7">4 products</small>
                                    </div>
                                    <div class="dropdown-scroll">
                                        <div class="list-group list-group-flush">
                                            <a href="#" class="px-4 py-3 list-group-item d-flex">
                                                <div class="flex-shrink-0">
                                                    <figure class="avatar mr-3">
                                                        <img class="rounded" src="{{ url('assets/media/image/products/product6.png') }}" alt="Canon 4000D 18-55 MM">
                                                    </figure>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <p class="mb-0 line-height-20 d-flex justify-content-between">
                                                        Canon 4000D 18-55 MM
                                                        <i title="Close" data-toggle="tooltip" class="hide-show-toggler-item small ti-close"></i>
                                                    </p>
                                                    <span class="text-muted small">X $1,200</span>
                                                </div>
                                            </a>
                                            <a href="#" class="px-4 py-3 list-group-item d-flex">
                                                <div class="flex-shrink-0">
                                                    <figure class="avatar mr-3">
                                                        <img class="rounded" src="{{ url('assets/media/image/products/product3.png') }}" alt="pineapple">
                                                    </figure>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <p class="mb-0 line-height-20 d-flex justify-content-between">
                                                        Snopy SN-BT96 Pretty
                                                        <i title="Close" data-toggle="tooltip" class="hide-show-toggler-item small ti-close"></i>
                                                    </p>
                                                    <span class="text-muted small">X $250</span>
                                                </div>
                                            </a>
                                            <a href="#" class="px-4 py-3 list-group-item d-flex">
                                                <div class="flex-shrink-0">
                                                    <figure class="avatar mr-3">
                                                        <img src="{{ url('assets/media/image/products/product7.png') }}" class="rounded" alt="pineapple">
                                                    </figure>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <p class="mb-0 line-height-20 d-flex justify-content-between">
                                                        Lenovo Tab E10 TB-X104F 32GB
                                                        <i title="Close" data-toggle="tooltip" class="hide-show-toggler-item small ti-close"></i>
                                                    </p>
                                                    <span class="text-muted small">X $100</span>
                                                </div>
                                            </a>
                                            <a href="#" class="px-4 py-3 list-group-item d-flex">
                                                <div class="flex-shrink-0">
                                                    <figure class="avatar mr-3">
                                                        <img class="rounded" src="{{ url('assets/media/image/products/product6.png') }}" alt="Canon 4000D 18-55 MM">
                                                    </figure>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <p class="mb-0 line-height-20 d-flex justify-content-between">
                                                        Canon 4000D 18-55 MM
                                                        <i title="Close" data-toggle="tooltip" class="hide-show-toggler-item small ti-close"></i>
                                                    </p>
                                                    <span class="text-muted small">X $1,200</span>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="px-4 py-3 border-top text-right small">
                                        <p class="d-flex justify-content-between align-items-center mb-1">
                                            <span>Sub Total</span>
                                            <span>$1,650</span>
                                        </p>
                                        <p class="d-flex justify-content-between align-items-center mb-1">
                                            <span>Taxes</span>
                                            <span>$15</span>
                                        </p>
                                        <p class="d-flex justify-content-between align-items-center mb-1 font-weight-bold">
                                            <span>Total</span>
                                            <span>$1,665</span>
                                        </p>
                                        <button class="btn btn-primary btn-block mt-2">
                                            Order and Payment <i class="ti-arrow-right ml-2"></i>
                                        </button>
                                    </div>
                                </div>
                            </li>-->

                            <!--<li class="nav-item dropdown">
                                <a href="#" class="nav-link" title="Settings" data-sidebar-target="#settings">
                                    <i data-feather="settings"></i>
                                </a>
                            </li>-->

                            <li class="nav-item dropdown">
                                <a href="#" class="nav-link dropdown-toggle" title="User menu" data-toggle="dropdown">
                                    <figure class="avatar avatar-sm">
                                        <img src="{{ url('assets/media/image/user/man_avatar3.jpg') }}" class="rounded-circle" alt="avatar">
                                    </figure>
                                    <span class="ml-2 d-sm-inline d-none" id="main_user_name">Demo</span>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right dropdown-menu-big">
                                    <div class="text-center py-4">
                                        <figure class="avatar avatar-lg mb-3 border-0">
                                            <img src="{{ url('assets/media/image/user/man_avatar3.jpg') }}" class="rounded-circle" alt="image">
                                        </figure>
                                        <h5 class="text-center" id="sub_user_name">Demo</h5>
                                        <div class="mb-3 small text-center text-muted" id="user_email">@demouser</div>
                                        <a href="#" class="btn btn-outline-light btn-rounded">Manage Your Account</a>
                                    </div>
                                    <div class="list-group">
                                        <a href="/changePassword" class="list-group-item">Change Password</a>
                                        <a href="/logout" class="list-group-item text-danger">Sign Out!</a>
                                    </div>
                                    <div class="p-4">
                                        <div class="mb-4">
                                            <h6 class="d-flex justify-content-between">
                                                Storage
                                                <span>%25</span>
                                            </h6>
                                            <div class="progress" style="height: 5px;">
                                                <div class="progress-bar bg-success-gradient" role="progressbar" style="width: 40%;" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                        </div>
                                        <hr class="mb-3">
                                        <p class="small mb-0">
                                            <a href="#">Privacy policy</a>
                                        </p>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>

                <ul class="navbar-nav ml-auto">
                    <li class="nav-item header-toggler">
                        <a href="#" class="nav-link">
                            <i data-feather="arrow-down"></i>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- ./ Header -->

        <!-- Content wrapper -->
        <div class="content-wrapper">
            <!-- begin::navigation -->
            <div class="navigation">
                <div class="navigation-header">
                    <span>Navigation</span>
                    <a href="#">
                        <i class="ti-close"></i>
                    </a>
                </div>
                <div class="navigation-menu-body">
                    <ul>
                        <li>
                            <a @if(request()->segment(2)== 'dashboard') class="active" @endif href="/hr/dashboard">
                                <span class="nav-link-icon">
                                    <i data-feather="pie-chart"></i>
                                </span>
                                <span>Dashboard</span>
                            </a>
                        </li>
                        <!-- <li>
                            <a @if(request()->segment(2) == 'chat') class="active"
                                @endif href="#">
                                <span class="nav-link-icon">
                                    <i data-feather="message-circle"></i>
                                </span>
                                <span>Chat</span>
                                <span class="badge badge-danger">5</span>
                            </a>
                        </li> -->

                        @if(Auth::user()->can('personal_information'))
                        <li>
                            <a href="#">
                                <span class="nav-link-icon">
                                    <i data-feather="users"></i>
                                </span>
                                <span>Personal Information </span>
                            </a>
                            <ul>
                                @if(Auth::user()->can('employee'))
                                <li>
                                    <a @if(request()->segment(2) == 'employee') class="active"
                                        @endif href="/hr/employee">Employee</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('employee_list'))
                                <li>
                                    <a @if(request()->segment(2) == 'employeeList') class="active"
                                        @endif href="/hr/employeeList">Employee List</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('attachment'))
                                <li>
                                    <a @if(request()->segment(2) == 'attachment') class="active"
                                        @endif href="/hr/attachment">Attachment</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('create_id_card'))
                                <li>
                                    <a @if(request()->segment(2) == 'printid') class="active"
                                        @endif href="/hr/printid">Create ID Card</a>
                                </li>
                                @endif


                                @if(Auth::user()->can('personal_information_setting'))
                                <li>
                                    <a href="#">Setting</a>
                                    <ul>
                                        @if(Auth::user()->can('personal_information_general'))
                                        <li>
                                            <a @if(request()->segment(2) == 'settings') class="active"
                                                @endif href="/hr/settings">General</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('personal_information_basic_salary'))
                                        <li>
                                            <a @if(request()->segment(2) == 'salary') class="active"
                                                @endif href="/hr/salary">Basic Salary</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('personal_information_category'))
                                        <li>
                                            <a @if(request()->segment(2) == 'category') class="active"
                                                @endif href="/hr/category">Category</a>
                                        </li>
                                        @endif
                                    </ul>
                                </li>
                                @endif

                                @if(Auth::user()->can('team'))
                                <li>
                                    <a href="#">Team</a>
                                    <ul>
                                        @if(Auth::user()->can('team_create'))
                                        <li>
                                            <a @if(request()->segment(2) == 'team') class="active"
                                                @endif href="/hr/team">Create</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('team_assign'))
                                        <li>
                                            <a @if(request()->segment(2) == 'employeeTeam') class="active"
                                                @endif href="/hr/employeeTeam">Assign to Team</a>
                                        </li>
                                        @endif
                                    </ul>
                                </li>
                                @endif

                                @if(Auth::user()->can('personal_information_report'))
                                <li>
                                    <a href="#">Report</a>
                                    <ul>
                                        @if(Auth::user()->can('persona_information_report_employee_list'))
                                        <li>
                                            <a @if(request()->segment(2) == 'reportEmployeeList') class="active"
                                                @endif href="/hr/reportEmployeeList">Employee List</a>
                                        </li>
                                        @endif

                                        <!--<li>
                                            <a @if(request()->segment(2) == 'employeeDetailReport') class="active"
                                                @endif href="/hr/employeeDetailReport">Employee Detail Report</a>
                                        </li>-->
                                        <li>
                                            <a @if(request()->segment(2) == 'employeeDetailReport') class="active"
                                                @endif href="/hr/employeeDetailReport">Employee Detail Report</a>
                                        </li>
                                    </ul>
                                </li>
                                @endif
                            </ul>
                        </li>
                        @endif
                        <!-- Time & Attendance  -->

                        @if(Auth::user()->can('time_and_attendande'))
                        <li>
                            <a href="#">
                                <span class="nav-link-icon">
                                    <i data-feather="clock"></i>
                                </span>
                                <span>Time & Attendance </span>
                            </a>
                            <ul>
                                @if(Auth::user()->can('time_schedule'))
                                <li>
                                    <a href="#">Times Schedule</a>
                                    <ul>
                                        @if(Auth::user()->can('time_and_attendande_create'))
                                        <li>
                                            <a @if(request()->segment(2) == 'attendanceEmployeeScheduleSetting') class="active"
                                                @endif href="/hr/attendanceEmployeeScheduleSetting">Create</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('time_and_attendande_supervisor'))
                                        <li>
                                            <a @if(request()->segment(2) == 'attendanceEmployeeScheduleSupervisor') class="active"
                                                @endif href="/hr/attendanceEmployeeScheduleSupervisor">By Supervisor</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('time_and_attendande_employee'))
                                        <li>
                                            <a @if(request()->segment(2) == 'attendanceEmployeeSchedule') class="active"
                                                @endif href="/hr/attendanceEmployeeSchedule">By Employee</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('time_and_attendande_team'))
                                        <li>
                                            <a @if(request()->segment(2) == 'employeeTeamSchedule') class="active"
                                                @endif href="/hr/employeeTeamSchedule">By Team</a>
                                        </li>
                                        @endif
                                    </ul>
                                </li>
                                @endif

                                @if(Auth::user()->can('attendance_edit'))
                                <li>
                                    <a @if(request()->segment(2) == 'attendanceEdit') class="active"
                                        @endif href="/hr/attendanceEdit">Attendance Edit</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('approve_supervisor'))
                                <li>
                                    <a @if(request()->segment(2) == 'supervisorAttendanceApproval') class="active"
                                        @endif href="/hr/supervisorAttendanceApproval">Approve By Supervisor</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('attendance_report'))
                                <li>
                                    <a @if(request()->segment(2) == 'reportAttSheet') class="active"
                                        @endif href="/hr/reportAttSheet">Attendance Reports</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('attendance_process'))
                                <li>
                                    <a @if(request()->segment(2) == 'attendanceProcess') class="active"
                                        @endif href="/hr/attendanceProcess">Attendance Process</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('attendance_setting'))
                                <li>
                                    <a href="#">Setting</a>
                                    <ul>
                                        @if(Auth::user()->can('attendance_general'))
                                        <li>
                                            <a @if(request()->segment(2) == 'attSettings') class="active"
                                                @endif href="/hr/attSettings">General</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('attendance_shift'))
                                        <li>
                                            <a @if(request()->segment(2) == 'shift') class="active"
                                                @endif href="/hr/shift">Shift</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('attendance_holiday'))
                                        <li>
                                            <a @if(request()->segment(2) == 'attHoliday') class="active"
                                                @endif href="/hr/attHoliday">Holiday</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('attendance_special_workdays'))
                                        <li>
                                            <a @if(request()->segment(2) == 'specialWorkdays') class="active"
                                                @endif href="/hr/specialWorkdays">Special Workday </a>
                                        </li>
                                        @endif
                                        <!-- <li>
                                            <a @if(request()->segment(2) == 'leave') class="active"
                                                @endif href="#">Leave </a>
                                        </li> -->
                                        @if(Auth::user()->can('attendance_leave'))
                                        <li>
                                            <a @if(request()->segment(2) == 'attendanceEmployeeLeave') class="active"
                                                @endif href="/hr/attendanceEmployeeLeave">Leave Setup</a>
                                        </li>
                                        @endif
                                    </ul>
                                </li>
                                @endif

                            </ul>
                        </li>
                        @endif

                        <!-- Pay Roll -->
                        @if(Auth::user()->can('payroll'))
                        <li>
                            <a href="#">
                                <span class="nav-link-icon">
                                    <i data-feather="dollar-sign"></i>
                                </span>
                                <span>Payroll</span>
                            </a>
                            <ul>
                                @if(Auth::user()->can('salary_sheet'))
                                <li>
                                    <a @if(request()->segment(2) == 'salarySheet') class="active"
                                        @endif href="/hr/salarySheet">Salary Sheet</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('salary_sheet_list'))
                                <li>
                                    <a @if(request()->segment(2) == 'salarySheetList') class="active"
                                        @endif href="/hr/salarySheetList">Salary Sheet List</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('salary_import_data'))
                                <li>
                                    <a @if(request()->segment(2) == 'importSalaryData') class="active"
                                        @endif href="/hr/importSalaryData">Import Salary Data</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('salary_advance'))
                                <li>
                                    <a @if(request()->segment(2) == 'salaryAdvance') class="active"
                                        @endif href="/hr/salaryAdvance">Advance Payment</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('salary_advance_list'))
                                <li>
                                    <a @if(request()->segment(2) == 'salaryAdvanceList') class="active"
                                        @endif href="/hr/salaryAdvanceList">Advance List</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('salary_loan'))
                                <li>
                                    <a @if(request()->segment(2) == 'loan') class="active"
                                        @endif href="/hr/loan">Loan Payment</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('salary_loan_list'))
                                <li>
                                    <a @if(request()->segment(2) == 'loanList') class="active"
                                        @endif href="/hr/loanList">Loan List</a>
                                </li>
                                @endif

                                <!--<li>
                                    <a @if(request()->segment(2) == 'loanlist') class="active"
                                        @endif href="/hr/loanList">Loan List</a>
                                </li>!-->
                                @if(Auth::user()->can('salary_debtor_loan'))
                                <li>
                                    <a @if(request()->segment(2) == 'debtorLoan') class="active"
                                        @endif href="/hr/debtorLoan">Debtor Loan Payment</a>
                                </li>
                                @endif

                                @if(Auth::user()->can('salary_debtor_loan_list'))
                                <li>
                                    <a @if(request()->segment(2) == 'debtorLoanList') class="active"
                                        @endif href="/hr/debtorLoanList">Debtor Loan List</a>
                                </li>
                                @endif




                                @if(Auth::user()->can('salary_payroll_report'))
                                <li>
                                    <a @if(request()->segment(2) == 'payrollReport') class="active"
                                        @endif href="/hr/payrollReport">Payroll Reports</a>
                                </li>
                                @endif





                                @if(Auth::user()->can('payroll_setting'))
                                <li>
                                    <a href="#">Setting</a>
                                    <ul>
                                        @if(Auth::user()->can('payroll_naration'))
                                        <li>
                                            <a @if(request()->segment(2) == 'transactionItem') class="active"
                                                @endif href="/hr/transactionItem">Narration</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('payroll_naration_setup'))
                                        <li>
                                            <a @if(request()->segment(2) == 'transactionItemSetup') class="active"
                                                @endif href="/hr/transactionItemSetup">Narration Setup</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('payroll_earning_deduction'))
                                        <li>
                                            <a @if(request()->segment(2) == 'otherEarningDeduction') class="active"
                                                @endif href="/hr/otherEarningDeduction">Earning and Deduction</a>
                                        </li>
                                        @endif

                                        @if(Auth::user()->can('payroll_earning_deduction_setup'))
                                        <li>
                                            <a @if(request()->segment(2) == 'employeeOtherEarningDeduction') class="active"
                                                @endif href="/hr/employeeOtherEarningDeduction">Earning and Deduction Setup</a>
                                        </li>
                                        @endif

                                    </ul>
                                </li>
                                @endif

                            </ul>
                        </li>
                        @endif

                        {{-- forms --}}
                        @if(Auth::user()->can('hr_forms'))
                        <li>
                            <a href="#">
                                <span class="nav-link-icon">
                                    <i data-feather="users"></i>
                                </span>
                                <span>Forms </span>
                            </a>
                            <ul>
                                @if(Auth::user()->can('hr_leave'))
                                <li>
                                    <a @if(request()->segment(2) == 'employee') class="active"
                                        @endif href="/hr/leave">Leave Application</a>
                                </li>
                                @endif
                                @if(Auth::user()->can('hr_leave_list'))
                                <li>
                                    <a @if(request()->segment(2) == 'employeeList') class="active"
                                        @endif href="/hr/leave_list">Leave Application List</a>
                                </li>
                                @endif
                            </ul>
                        </li>
                        @endif

                        {{-- recruitment --}}
                        <!--<li>
                            <a href="#">
                                <span class="nav-link-icon">
                                    <i data-feather="users"></i>
                                </span>
                                <span>Recruitment Management </span>
                            </a>
                            <ul>
                                <li>
                                    <a @if(request()->segment(2) == 'employee') class="active"
                                        @endif href="/hr/recruitment_request">Request </a>
                                </li>
                                <li>
                                    <a @if(request()->segment(2) == 'employeeList') class="active"
                                        @endif href="/hr/recruitment_request_list">Request List</a>
                                </li>

                            </ul>
                        </li>!-->




                    </ul>
                </div>
            </div>
            <!-- end::navigation -->

            <!-- Content body -->
            <div class="content-body">
                <!-- Content -->
                <div class="content @yield('parentClassName')">
                    @yield('content')
                </div>
                <!-- ./ Content -->

                <!-- Footer -->
                <footer class="content-footer">
                    <div>© {{ date('Y') }} - <a href="" target="_blank">Rapidventure Bussiness Solutions</a></div>
                    <div>
                        <nav class="nav">
                            <a href="#" class="nav-link">Licenses</a>
                            <a href="#" class="nav-link">Change Log</a>
                            <a href="#" class="nav-link">Get Help</a>
                        </nav>
                    </div>
                </footer>
                <!-- ./ Footer -->
            </div>
            <!-- ./ Content body -->
        </div>
        <!-- ./ Content wrapper -->
    </div>
    <!-- ./ Layout wrapper -->

    <!-- Main scripts -->
    <script src="{{ url('vendors/bundle.js') }}"></script>
    @yield('script')

    <!-- App scripts -->
    <script src="{{ url('assets/js/app.min.js') }}"></script>
    <script>
        $('#main_user_name').text(user_name);
        $('#sub_user_name').text(user_name);
        $('#user_email').text(user_email);
    </script>
</body>

</html>