@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">

<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<script>
    var view_permission = "{{Auth::user()->can('employee_earn_deduct_view')}}";
    var edit_permission = "{{Auth::user()->can('employee_earn_deduct_edit')}}";
    var delete_permission = "{{Auth::user()->can('employee_earn_deduct_delete')}}";
</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Earning & Deduction</h6>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        @if(Auth::user()->can('employee_earn_deduct_create'))
                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal()">
                            <i class="fa fa-plus" aria-hidden="true"></i>
                        </button>
                        @endif
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table id="tblAllowance" class="table table-striped  datatable">
                                <thead>
                                    <tr>
                                        <th class="thAllowanceID">Allowance ID</th>
                                        <th class="thAllowance">Type</th>
                                        <th class="thAllowance">Name</th>
                                        <th class="edit">Edit</th>
                                        <th class="view">View</th>
                                        <th class="delete">Delete</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="allowanceAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="allowanceAddModalTitle">Add Earning & Deduction</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form action="POST" id="allowanceForm">
                    {{csrf_field()}}
                    <div class="modal-body" id="allowanceAddModalBody">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-9 mb-3">
                                        <label>Type</label>
                                        <select class="form-control" id="selcType" name="selcType" onchange="naration(event.target.value,null)">
                                            <option value="1">Allowance</option>
                                            <option value="2">Incentive</option>
                                            <option value="3">Deduction</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3" style="padding-top: 30px;">
                                        <div class="form-control">
                                            <label>EPF:</label>
                                            <input type="checkbox" id="checkEPF" name="checkEPF">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label>Title</label>
                                        <input type="text" class="form-control" id="txtTitle" name="txtTitle">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label>Narations</label>
                                        <select class="form-control" id="selcNaration" name="selcNaration"></select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label>Calculate</label>
                                        <select class="form-control" id="selcCalculate" name="selcCalculate">
                                            <option value="1">Formula</option>
                                            <option value="2"> Day Basis</option>
                                            <option value="3">Month Basis</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label>Amount</label>
                                        <textarea class="form-control" id="txtFormula" name="txtFormula"></textarea>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnAction" onclick="actionBtn(event)">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ Module::asset('hr:js/allowance.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection