@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">

<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/salary.css') }}" type="text/css">
<script>
    var edit_permission = "{{Auth::user()->can('employee_basic_salary_edit')}}";
    var delete_permission = "{{Auth::user()->can('employee_basic_salary_delete')}}";
    var disable_permission = "{{Auth::user()->can('employee_basic_salary_enable_disable')}}";
</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee Salary</h6>
                <div class="row">
                    <!--Left side -->
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-12 mb-3 autocomplete">
                                <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                <label>Employee ID</label>
                                <input type="text" class="form-control auto-complete" id="auto-comp2" name="txtAutoCompleteID" onchange="onChangeAutoCompleteOption(event)">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3 autocomplete">
                                <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                <label>Employee (Name with Initials)</label>
                                <input type="text" class="form-control auto-complete" id="auto-comp1" name="txtAutoComplete" onchange="onChangeAutoCompleteOption(event)">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-12">
                                <i class="fa fa-address-book-o text-info" aria-hidden="true"></i>
                                <label>Address</label>
                                <textarea class="form-control" id="txtEmployeeAddress" name="txtEmployeeAddress"></textarea>
                            </div>
                        </div>
                        <br>
                        <form method="POST" id="formSalaryEmployee" name="formSalaryEmployee">
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-md-6">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label>Date</label>
                                    <input type="text" class="form-control" name="dteDate" id="dteDate" placeholder="YYYY-MM-DD">
                                </div>
                                <div class="col-md-6">
                                    <i class="fa fa-money text-info" aria-hidden="true"></i>
                                    <label>Basic Salary</label>
                                    <input type="text" class="form-control" id="txtSalary" name="txtSalary">
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-md-12">
                                    <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                    <label>Remark</label>
                                    <input type="text" class="form-control" id="txtRemark" name="remark">
                                </div>
                            </div>
                        </form>

                        <div class="row">
                            <div class="col-md-12">
                                @if(Auth::user()->can('employee_basic_salary_create'))
                                <button type="button" class="btn btn-primary" id="btnAction" onclick="actionBtn()">Save</button>
                                @endif
                            </div>
                        </div>
                    </div>
                    <!--Left side end-->

                    <!--Right side -->
                    <div class="col-md-3">
                        <br>
                        <div class="row">
                            <div class="col-md-12">
                                <img class="img img-thumbnail" id="imgEmployee" src="/images/employee.jpg" width="170" height="170">
                            </div>
                        </div>
                    </div>
                    <!--Right side end-->

                </div>
                <br>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table id="salaryTable" class="table table-striped  datatable">
                                <thead>
                                    <tr>
                                        <th class="thEmployee ID">Employee ID</th>
                                        <th class="thName">Name</th>
                                        <th class="thSalary">Salary(.Rs)</th>
                                        <th class="thEdit">Edit</th>
                                        <th class="thDelete">Delete</th>
                                        <th class="thStatus">Status</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>

<script src="{{ Module::asset('hr:js/salary.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection