@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<!--<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/attendanceHoliday.css') }}" type="text/css">!-->
<script>
    var view_permission = "{{Auth::user()->can('employee_special_workday_view')}}";
    var edit_permission = "{{Auth::user()->can('employee_special_workday_edit')}}";
    var delete_permission = "{{Auth::user()->can('employee_special_workday_delete')}}";
</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Special Workdays</h6>
                <div class="row">
                    <!--Left side -->
                    <div class="col-md-6">
                        <form method="POST" id="frmSpWorkdays">
                            {{csrf_field()}}

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                    <label>Date</label>
                                    <input type="text" class="form-control" name="date" id="txtDate" placeholder="YYYY-MM-DD">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                    <label>Type</label>
                                    <select class="form-control" id="cmbSpWorkType" name="spWorkType"></select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                    <label>Day Type</label>
                                    <select class="form-control" id="cmbDayType" name="dayType">
                                        <option value="1">Full Day</option>
                                        <option value="2">Half Day</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                    <label>Remarks</label>
                                    <textarea class="form-control" id="txtRemark" name="remark"></textarea>
                                </div>
                            </div>
                        </form>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                @if(Auth::user()->can('employee_special_workday_create'))
                                <button type="button" class="btn btn-primary" id="btnAction">Save</button>
                                @endif
                            </div>
                        </div>
                    </div>
                    <!--Left side end-->

                    <!--Right side -->
                    <div class="col-md-3"></div>
                    <!--Right side end-->

                </div>
                <br>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table id="tblSpecialWorkday" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Edit</th>
                                        <th>View</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('hr:js/specialWorkdays.js') }}"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection