@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<style>
    td {
        font-size: 14px;
    }
</style>
<script>
    var uid = "{{ Auth::user()->user_id }}";
    var userRoleID = "{{ Auth::user()->user_role_id }}";
    var userName = "{{ Auth::user()->name }}";
    var approval_permission = "{{Auth::user()->can('employee_supervisor_attendance_approval')}}";
</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title">Supervisor Attendance Approval</h6>
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="row">
                            <div class="col-md-6">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>Date</label>
                                <input type="text" class="form-control" id="txtDateFrom" name="date">
                            </div>
                            <div class="col-md-3" style="text-align: right;">
                                @if(Auth::user()->can('employee_supervisor_attendance_submit'))
                                <button id="btnProcess" class="btn btn-primary" style="margin-top: 25px;" onclick="approval()">Submit</button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <hr>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-12 seperator">
                                <div class="card bg-light">
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Actual InTime</th>
                                                    <th>Actual OutTime</th>
                                                    <th class="approval">
                                                        <input type="checkbox" id="chekApproval"> Apploval
                                                    </th>
                                                    <th>Remark</th>
                                                </tr>
                                            </thead>
                                            <tbody id="att_timeBody"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>

    @endsection

    <!-- Javascript -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @section('script')
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- AutoComplete -->
    <script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}"></script>

    <script src="{{ Module::asset('hr:js/supervisorAttendanceApproval.js') }}"></script>

    <!-- Prism -->
    <script src="{{ url('vendors/prism/prism.js') }}"></script>
    @endsection